pub mod http;
pub mod bindings;
pub mod core;
pub mod log;

/// Define modules exported by this library.
///
/// These are normally generated by the Nginx module system, but need to be
/// defined when building modules outside of it.
#[macro_export]
macro_rules! ngx_modules {
    ($( $mod:ident ),+) => {
        #[no_mangle]
        pub static mut ngx_modules: [*const ngx_module_t; $crate::count!($( $mod, )+) + 1] = [
            $( unsafe { &$mod } as *const ngx_module_t, )+
            ptr::null()
        ];

        #[no_mangle]
        pub static mut ngx_module_names: [*const c_char; $crate::count!($( $mod, )+) + 1] = [
            $( concat!(stringify!($mod), "\0").as_ptr() as *const i8, )+
            ptr::null()
        ];

        #[no_mangle]
        pub static mut ngx_module_order: [*const c_char; 1] = [
            ptr::null()
        ];
    };
}

/// Count number of arguments
#[macro_export]
macro_rules! count {
    () => { 0usize };
    ($x:tt, $( $xs:tt ),*) => { 1usize + $crate::count!($( $xs, )*) };
}
