use crate::*;

#[derive(BorshDeserialize, BorshSerialize, Serialize, Deserialize, Clone)]
#[serde(crate = "near_sdk::serde")]
pub struct NFTMetadata {
  pub spec: String,
  pub name: String,
  pub symbol: String,
  pub icon: Option<String>,
  pub base_uri: Option<String>,
  pub reference: Option<String>,
  pub reference_hash: Option<Base64VecU8>,
}

#[derive(BorshDeserialize, BorshSerialize, Serialize, Deserialize)]
#[serde(crate = "near_sdk::serde")]
pub struct TokenMetadata {
  pub title: Option<String>,
  pub description: Option<String>,
  pub media: Option<String>,
  pub media_hash: Option<Base64VecU8>,
  pub copies: Option<u64>,
  pub issued_at: Option<u64>,
  pub expires_at: Option<u64>,
  pub starts_at: Option<u64>,
  pub updated_at: Option<u64>,
  pub extra: Option<String>,
  pub reference: Option<String>,
  pub reference_hash: Option<Base64VecU8>,
}

pub trait NonFungibleTokenMetadata {
  fn nft_metadata(&self) -> NFTMetadata;
}

#[near_bindgen]
impl NonFungibleTokenMetadata for Contract {
  fn nft_metadata(&self) -> NFTMetadata {
    self.metadata.get().unwrap()
  }
}