# Instruction
<!-- https://github.com/near/core-contracts/tree/7eb1b0d06f79893cb13b82178a37af2a49c46b9f -->

## Commands to run
1. Build WASM file in target directory:
``` cargo build --target wasm32-unknown-unknown --release ```
2. Login to near protocol:
``` near login ```
3. Deploy smart contract on testnet:
``` near deploy --wasmFile target/wasm32-unknown-unknown/release/<fileName>.wasm --accountId <accountID (0000.testnet ```

## Files
1. nft를 발행하는 mint
2. nft의 개수를 세는 기능인 enumerable
3. nft 내부 정보를 관리하는 internal
4. nft에 이미지 등의 정보를 넣을 수 있는 metadata
5. NEP-171 표준을 명시하는 nft_core

## Reference
1. NEAR University
2. NEAR Discord

## Read material
check out these resources

0. prework
- https://bit.ly/ncd-prework (a few slides to get you started)
- https://hackmd.io/@nearly-learning/ncd-day-0 (this is some of the best content i've found in the last 2 years of my own learning.)

1. NCD
- http://bit.ly/ncd-1-1d-slides (self-paced course to learn how to read, write, deploy and test contracts on NEAR)
- https://hackmd.io/@nearly-learning/ncd-2-1d--exploring (self-paced course to learn how to build full stack apps that connects to NEAR (dApps))

examples 
- https://github.com/learn-near?q=L1 (10 sample contracts)
- https://github.com/learn-near?q=L2 (10 sample frontends for the L1 contracts )
- the other 50+ examples are good student work but may not be as useful for learning
- please star repos if you find them useful because this helps promote highest quality content

senior devs 
- https://hackmd.io/@nearly-learning/near-201  (hundreds of production examples including video walkthrough by core engineers and more)

`Near CRUD app` and an `NFT Skeleton and Architecture` tutorial on the Near docs.
Near CRUD app: https://docs.near.org/docs/tutorials/apps/todos-crud-app#introduction
NFT Skeleton and Architecture: https://docs.near.org/docs/tutorials/contracts/nfts/skeleton#introduction

## Demo submission
https://airtable.com/shrPNZwDh2o646eJd

## NEAR examples
https://github.com/Learn-NEAR/starter--near-sdk-as