/*
Copyright (c) 2016 Saurav Sachidanand

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/* automatically generated by rust-bindgen */

#![allow(
    dead_code,
    non_camel_case_types,
    non_upper_case_globals,
    non_snake_case
)]

use std::os::raw;
pub type ptrdiff_t = isize;
pub type size_t = usize;
pub type nfdchar_t = raw::c_char;

#[repr(C)]
#[derive(Copy, Clone, Debug)]
pub struct nfdpathset_t {
    pub buf: *mut nfdchar_t,
    pub indices: *mut size_t,
    pub count: size_t,
}

impl Default for nfdpathset_t {
    fn default() -> Self {
        unsafe { std::mem::zeroed() }
    }
}

#[derive(Copy, Clone)]
#[repr(u32)]
#[derive(Debug)]
pub enum nfdresult_t {
    Error = 0,
    Okay = 1,
    Cancel = 2,
}

extern "C" {
    pub fn NFD_OpenDialog(
        filterList: *const nfdchar_t,
        defaultPath: *const nfdchar_t,
        outPath: *mut *mut nfdchar_t,
    ) -> nfdresult_t;
    pub fn NFD_OpenDialogMultiple(
        filterList: *const nfdchar_t,
        defaultPath: *const nfdchar_t,
        outPaths: *mut nfdpathset_t,
    ) -> nfdresult_t;
    pub fn NFD_SaveDialog(
        filterList: *const nfdchar_t,
        defaultPath: *const nfdchar_t,
        outPath: *mut *mut nfdchar_t,
    ) -> nfdresult_t;
    pub fn NFD_PickFolder(
        defaultPath: *const nfdchar_t,
        outPath: *mut *mut nfdchar_t,
    ) -> nfdresult_t;
    pub fn NFD_GetError() -> *const raw::c_char;
    pub fn NFD_PathSet_GetCount(pathSet: *const nfdpathset_t) -> size_t;
    pub fn NFD_PathSet_GetPath(pathSet: *const nfdpathset_t, index: size_t) -> *mut nfdchar_t;
    pub fn NFD_PathSet_Free(pathSet: *mut nfdpathset_t);
    pub fn NFD_Free(ptr: *mut std::os::raw::c_void);
}
