SET(LIBNFC_DRIVER_PCSC OFF CACHE BOOL "Enable PC/SC reader support (Depends on PC/SC)")
SET(LIBNFC_DRIVER_ACR122_PCSC OFF CACHE BOOL "Enable ACR122 support (Depends on PC/SC)")
SET(LIBNFC_DRIVER_ACR122_USB ON CACHE BOOL "Enable ACR122 support (Direct USB connection)")
SET(LIBNFC_DRIVER_ACR122S ON CACHE BOOL "Enable ACR122S support (Use serial port)")
SET(LIBNFC_DRIVER_ARYGON ON CACHE BOOL "Enable ARYGON support (Use serial port)")
IF(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
  SET(LIBNFC_DRIVER_PN532_I2C ON CACHE BOOL "Enable PN532 I2C support (Use I2C bus)")
  SET(LIBNFC_DRIVER_PN532_SPI ON CACHE BOOL "Enable PN532 SPI support (Use SPI bus)")
ELSE(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
  SET(LIBNFC_DRIVER_PN532_I2C OFF CACHE BOOL "Enable PN532 I2C support (Use I2C bus)")
  SET(LIBNFC_DRIVER_PN532_SPI OFF CACHE BOOL "Enable PN532 SPI support (Use SPI bus)")
ENDIF(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
SET(LIBNFC_DRIVER_PN532_UART ON CACHE BOOL "Enable PN532 UART support (Use serial port)")
SET(LIBNFC_DRIVER_PN53X_USB ON CACHE BOOL "Enable PN531 and PN531 USB support (Depends on libusb)")

IF(LIBNFC_DRIVER_PCSC)
  FIND_PACKAGE(PCSC REQUIRED)
  ADD_DEFINITIONS("-DDRIVER_PCSC_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/pcsc")
ENDIF(LIBNFC_DRIVER_PCSC)

IF(LIBNFC_DRIVER_ACR122_PCSC)
  FIND_PACKAGE(PCSC REQUIRED)
  ADD_DEFINITIONS("-DDRIVER_ACR122_PCSC_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/acr122_pcsc")
ENDIF(LIBNFC_DRIVER_ACR122_PCSC)

IF(LIBNFC_DRIVER_ACR122_USB)
  FIND_PACKAGE(LIBUSB REQUIRED)
  ADD_DEFINITIONS("-DDRIVER_ACR122_USB_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/acr122_usb")
ENDIF(LIBNFC_DRIVER_ACR122_USB)

IF(LIBNFC_DRIVER_ACR122S)
  ADD_DEFINITIONS("-DDRIVER_ACR122S_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/acr122s")
  SET(UART_REQUIRED TRUE)
ENDIF(LIBNFC_DRIVER_ACR122S)

IF(LIBNFC_DRIVER_ARYGON)
  ADD_DEFINITIONS("-DDRIVER_ARYGON_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/arygon")
  SET(UART_REQUIRED TRUE)
ENDIF(LIBNFC_DRIVER_ARYGON)

IF(LIBNFC_DRIVER_PN532_I2C)
  ADD_DEFINITIONS("-DDRIVER_PN532_I2C_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/pn532_i2c")
  SET(I2C_REQUIRED TRUE)
ENDIF(LIBNFC_DRIVER_PN532_I2C)

IF(LIBNFC_DRIVER_PN532_SPI)
  ADD_DEFINITIONS("-DDRIVER_PN532_SPI_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/pn532_spi")
  SET(SPI_REQUIRED TRUE)
ENDIF(LIBNFC_DRIVER_PN532_SPI)

IF(LIBNFC_DRIVER_PN532_UART)
  ADD_DEFINITIONS("-DDRIVER_PN532_UART_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/pn532_uart")
  SET(UART_REQUIRED TRUE)
ENDIF(LIBNFC_DRIVER_PN532_UART)

IF(LIBNFC_DRIVER_PN53X_USB)
  FIND_PACKAGE(LIBUSB REQUIRED)
  ADD_DEFINITIONS("-DDRIVER_PN53X_USB_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/pn53x_usb")
  SET(USB_REQUIRED TRUE)
ENDIF(LIBNFC_DRIVER_PN53X_USB)

IF(LIBNFC_DRIVER_ACR122_USB)
  FIND_PACKAGE(LIBUSB REQUIRED)
  ADD_DEFINITIONS("-DDRIVER_ACR122_USB_ENABLED")
  SET(DRIVERS_SOURCES ${DRIVERS_SOURCES} "drivers/acr122_usb")
  SET(USB_REQUIRED TRUE)
ENDIF(LIBNFC_DRIVER_ACR122_USB)

INCLUDE_DIRECTORIES(${CMAKE_CURRENT_SOURCE_DIR}/libnfc/drivers)
