# nextest-runner

[![nextest-runner on crates.io](https://img.shields.io/crates/v/nextest-runner)](https://crates.io/crates/nextest-runner)
[![Documentation (latest release)](https://img.shields.io/badge/docs-latest-brightgreen.svg)](https://docs.rs/nextest-runner/)
[![Documentation (main)](https://img.shields.io/badge/docs-main-purple)](https://nexte.st/rustdoc/nextest_runner/)
[![Changelog](https://img.shields.io/badge/changelog-latest-blue)](CHANGELOG.md)
[![License](https://img.shields.io/badge/license-Apache-green.svg)](LICENSE-APACHE)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE-MIT)

Core functionality for [cargo nextest](https://crates.io/crates/cargo-nextest). For a
higher-level overview, see that documentation.

Here's the basic flow of operations in nextest.

### Building the test list

1. `cargo test --no-run` is invoked to build test binaries. (This is handled by cargo-nextest;
   nextest just processes the messages produced by the command.)
2. The messages generated by Cargo are processed into a list of `test_list::RustTestArtifact`
   instances.
3. Separately, a `test_filter::TestFilter` is created based on text filters, along with the
   run-ignored and partitioning filters if provided.
4. The list of test binaries and test filter are combined. Each binary is run with `--list` to
   grab the list of tests, the given filters are applied to it, and everything is put together
   to create a `test_list::TestList`.

If `cargo nextest list-tests` is called, this `test_list::TestList` is printed out. If `cargo
nextest run` is called, nextest proceeds to run the tests.

### Running the tests

1. A new `runner::TestRunner` is created with the test list and appropriate configuration.
2. The runner sets up two thread pools:
    * The *run pool*: each thread in this pool executes a test (+ 1 thread for overall
      management).
    * The *wait pool*: each thread in this pool monitors the status of a test being run by the
      run pool.
3. The test runner is executed with a callback to send `reporter::TestEvent` instances to the
   test reporter.
4. The test runner iterates over the test list to get individual `test_list::TestInstance`
   information. Test instances are sent to the thread pool to be executed.
5. If a test fails and fail-fast is true, or if a signal is encountered, the run is cancelled;
   currently executing tests are allowed to complete, but no new tests are scheduled.
6. The test reporter sees events and prints them to stderr (and aggregates them if necessary
   based on configs).

## Contributing

See the [CONTRIBUTING](../CONTRIBUTING.md) file for how to help out.

## License

This project is available under the terms of either the [Apache 2.0 license](../LICENSE-APACHE) or
the [MIT license](../LICENSE-MIT).

<!--
README.md is generated from README.tpl by cargo readme. To regenerate, run from the repository root:

./scripts/regenerate-readmes.sh
-->
