use super::*;

pub type WNDPROC = extern "C" fn(HWND, UINT, WPARAM, LPARAM) -> LRESULT;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct WNDCLASSEXA {
	pub cbSize: UINT,
	pub style: UINT,
	pub lpfnWndProc: Option<WNDPROC>,
	pub cbClsExtra: u32,
	pub cbWndExtra: u32,
	pub hInstance: HINSTANCE,
	pub hIcon: HICON,
	pub hCursor: HCURSOR,
	pub hbrBackground: HBRUSH,
	pub lpszMenuName: LPCSTR,
	pub lpszClassName: LPCSTR,
	pub hIconSm: HICON,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct MSG {
	pub hWnd: HWND,
	pub message: UINT,
	pub wParam: WPARAM,
	pub lParam: LPARAM,
	pub time: DWORD,
	pub pt: POINT,
}
pub type LPMSG = *mut MSG;

pub const WS_OVERLAPPED: u32 = 0x00000000;
pub const WS_POPUP: u32 = 0x80000000;
pub const WS_CHILD: u32 = 0x40000000;
pub const WS_MINIMIZE: u32 = 0x20000000;
pub const WS_VISIBLE: u32 = 0x10000000;
pub const WS_DISABLED: u32 = 0x08000000;
pub const WS_CLIPSIBLINGS: u32 = 0x04000000;
pub const WS_CLIPCHILDREN: u32 = 0x02000000;
pub const WS_MAXIMIZE: u32 = 0x01000000;
pub const WS_CAPTION: u32 = 0x00C00000;
pub const WS_BORDER: u32 = 0x00800000;
pub const WS_DLGFRAME: u32 = 0x00400000;
pub const WS_VSCROLL: u32 = 0x00200000;
pub const WS_HSCROLL: u32 = 0x00100000;
pub const WS_SYSMENU: u32 = 0x00080000;
pub const WS_THICKFRAME: u32 = 0x00040000;
pub const WS_GROUP: u32 = 0x00020000;
pub const WS_TABSTOP: u32 = 0x00010000;

pub const WS_MINIMIZEBOX: u32 = 0x00020000;
pub const WS_MAXIMIZEBOX: u32 = 0x00010000;

pub const WS_OVERLAPPEDWINDOW: u32 =
	WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX;

pub const GWLP_USERDATA: i32 = -21;

pub const PM_NOREMOVE: u32 = 0x0000;
pub const PM_REMOVE: u32 = 0x0001;
pub const PM_NOYIELD: u32 = 0x0002;

// Window Messages
pub const WM_DESTROY: u32 = 0x0002;
pub const WM_SIZE: u32 = 0x0005;
pub const WM_SETFOCUS: u32 = 0x0007;
pub const WM_KILLFOCUS: u32 = 0x0008;
pub const WM_CLOSE: u32 = 0x0010;
pub const WM_QUIT: u32 = 0x0012;

pub const WM_KEYDOWN: u32 = 0x0100;
pub const WM_KEYUP: u32 = 0x0101;
pub const WM_CHAR: u32 = 0x0102;

pub const WM_SYSKEYDOWN: u32 = 0x0104;
pub const WM_SYSKEYUP: u32 = 0x0105;
pub const WM_SYSCHAR: u32 = 0x0106;

pub const WM_MOUSEMOVE: u32 = 0x0200;
pub const WM_LBUTTONDOWN: u32 = 0x0201;
pub const WM_LBUTTONUP: u32 = 0x0202;
pub const WM_LBUTTONDBLCLK: u32 = 0x0203;
pub const WM_RBUTTONDOWN: u32 = 0x0204;
pub const WM_RBUTTONUP: u32 = 0x0205;
pub const WM_RBUTTONDBLCLK: u32 = 0x0206;
pub const WM_MBUTTONDOWN: u32 = 0x0207;
pub const WM_MBUTTONUP: u32 = 0x0208;
pub const WM_MBUTTONDBLCLK: u32 = 0x0209;
pub const WM_MOUSEWHEEL: u32 = 0x020A;
pub const WM_XBUTTONDOWN: u32 = 0x020B;
pub const WM_XBUTTONUP: u32 = 0x020C;
pub const WM_XBUTTONDBLCLK: u32 = 0x020D;

pub const WM_MOUSELEAVE: u32 = 0x02A3;

pub const WM_SIZING: u32 = 0x0214;

pub const WM_NCCALCSIZE: u32 = 0x0083;
pub const WM_NCHITTEST: u32 = 0x0084;
pub const WM_NCACTIVATE: u32 = 0x0086;
pub const WM_DWMCOMPOSITIONCHANGED: u32 = 798;

pub const WM_SYSCOMMAND: u32 = 0x0112;
pub const SC_MAXIMIZE: u64 = 0xF030;

pub const SM_CXSCREEN: i32 = 0;
pub const SM_CYSCREEN: i32 = 1;

pub const SW_HIDE: i32 = 0;
pub const SW_SHOW: i32 = 5;
pub const SM_CXFRAME: i32 = 32;
pub const SM_CYFRAME: i32 = 33;
pub const SM_CXPADDEDBORDER: i32 = 92;

pub const SWP_NOSIZE: u32 = 0x0001;
pub const SWP_NOZORDER: u32 = 0x0004;

pub const MONITOR_DEFAULTTONULL: DWORD = 0x00000000;
pub const MONITOR_DEFAULTTOPRIMARY: DWORD = 0x00000001;
pub const MONITOR_DEFAULTTONEAREST: DWORD = 0x00000002;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct TRACKMOUSEEVENT {
	pub cbSize: DWORD,
	pub dwFlags: DWORD,
	pub hwndTrack: HWND,
	pub dwHoverTime: DWORD,
}
pub type LPTRACKMOUSEEVENT = *mut TRACKMOUSEEVENT;

#[link(name = "user32")]
extern "stdcall" {
	pub fn GetCaretBlinkTime() -> UINT;

	pub fn RegisterClassExA(Arg1: *const WNDCLASSEXA) -> ATOM;
	pub fn CreateWindowExA(
		dwExStyle: DWORD,
		lpClassName: LPCSTR,
		lpWindowName: LPCSTR,
		dwStyle: DWORD,
		X: u32,
		Y: u32,
		nWidth: u32,
		nHeight: u32,
		hWndParent: HWND,
		hMenu: HMENU,
		hInstance: HINSTANCE,
		lpParam: LPVOID,
	) -> HWND;
	pub fn DestroyWindow(hWnd: HWND) -> BOOL;
	pub fn DefWindowProcA(hWnd: HWND, Msg: UINT, wParam: WPARAM, lParam: LPARAM) -> LRESULT;
	pub fn ShowWindow(hWnd: HWND, nCmdShow: i32) -> BOOL;
	pub fn SetWindowPos(
		hWnd: HWND,
		hWndInsertAfter: HWND,
		X: i32,
		Y: i32,
		cx: i32,
		cy: i32,
		uFlags: UINT,
	) -> BOOL;

	pub fn AdjustWindowRect(lpRect: LPRECT, dwStyle: DWORD, bMenu: BOOL) -> BOOL;
	pub fn GetClientRect(hWnd: HWND, lpRect: LPRECT) -> BOOL;
	pub fn GetWindowRect(hWnd: HWND, lpRect: LPRECT) -> BOOL;
	pub fn ScreenToClient(hWnd: HWND, lpPoint: LPPOINT) -> BOOL;
	pub fn GetCursorPos(lpPoint: LPPOINT) -> BOOL;

	pub fn SetWindowLongPtrA(hWnd: HWND, nIndex: i32, dwNewLong: LONG_PTR) -> LONG_PTR;
	pub fn GetWindowLongPtrA(hWnd: HWND, nIndex: i32) -> LONG_PTR;

	pub fn PeekMessageA(
		lpMsg: LPMSG,
		hWnd: HWND,
		wMsgFilterMin: UINT,
		wMsgFilterMax: UINT,
		wRemoveMsg: UINT,
	) -> BOOL;
	pub fn GetMessageA(lpMsg: LPMSG, hWnd: HWND, wMsgFilterMin: UINT, wMsgFilterMax: UINT) -> BOOL;
	pub fn TranslateMessage(lpMsg: *const MSG) -> BOOL;
	pub fn DispatchMessageA(lpMsg: *const MSG) -> LRESULT;

	pub fn LoadCursorA(hInstance: HINSTANCE, lpCursorName: LPCSTR) -> HCURSOR;

	pub fn GetSystemMetrics(nIndex: i32) -> i32;

	pub fn SetCapture(hWnd: HWND) -> HWND;
	pub fn ReleaseCapture() -> BOOL;

	pub fn MonitorFromWindow(hwnd: HWND, dwFlags: DWORD) -> HMONITOR;

	pub fn IsZoomed(hwnd: HWND) -> BOOL;
	pub fn IsIconic(hwnd: HWND) -> BOOL;

	pub fn TrackMouseEvent(lpEventTrack: LPTRACKMOUSEEVENT) -> BOOL;
}
