mod person {
    pub struct personal_info {
        pub age: u8, 
        pub education: String, 
    }

    impl personal_info{
        pub fn update_education(new_edu: &str) -> Self {
            Self {
                education: String::from(new_edu),
                age: 20,  
            }
        }
    }
}

pub fn some_person() {
    let mut person1 = person::personal_info::update_education("bachelors"); 
    person1.education = String::from("Masters");   //Point: By default fields within the struct are private: https://www.youtube.com/watch?v=5RPXgDQrjio&t=925s 
                                                    // to fix this we will change the education pub and it will work 
                                                    

                                                    
    // Point 2: we can not create the personal_info struct directly, this is becuase it contains a private field. 
    // the following code will give an error 

    let person2 = person::personal_info {
        age: 42,                    
        education: String::from("Masters"),
    }; 
    
}








