# New Derivable

Automatically create a `new` implementation for your Structs (Unnamed, and Named).

```rust
use new_derivable::New;

#[derive(New,Debug)]
pub struct Human {
	pub name: String,
	pub age: i64
}
```
will ceate
```rust
impl Human {
	fn new(name: String, age: i64) -> Self {
		Self { name, age }
	}
}
```
so then you can do
```rust
fn main() {
	let human = Human::new(String::from("Justin"),69);
	println!("{:#?}", human);
}
```
Which will give us 
```rust
Human {
	name: "Justin",
	age: 69
}
```