use std::net::IpAddr;
use pnet_packet::udp::MutableUdpPacket;

#[allow(dead_code)]
pub const UDP_HEADER_LEN: usize = 8;

pub fn build_udp_packet(udp_packet:&mut MutableUdpPacket, src_ip: IpAddr, src_port:u16, dst_ip: IpAddr, dst_port:u16) {
    udp_packet.set_length(8);
    udp_packet.set_source(src_port);
    udp_packet.set_destination(dst_port);
    udp_packet.set_length(32);
    match src_ip {
        IpAddr::V4(src_ip) => {
            match dst_ip {
                IpAddr::V4(dst_ip) => {
                    let checksum = pnet_packet::udp::ipv4_checksum(&udp_packet.to_immutable(), &src_ip, &dst_ip);
                    udp_packet.set_checksum(checksum);
                },
                IpAddr::V6(_) => {},
            }
        },
        IpAddr::V6(src_ip) => {
            match dst_ip {
                IpAddr::V4(_) => {},
                IpAddr::V6(dst_ip) => {
                    let checksum = pnet_packet::udp::ipv6_checksum(&udp_packet.to_immutable(), &src_ip, &dst_ip);
                    udp_packet.set_checksum(checksum);
                },
            }
        },
    }
}
