use std::net::IpAddr;
use pnet::packet::tcp::{MutableTcpPacket, TcpOption, TcpFlags};

pub fn build_tcp_packet(tcp_packet:&mut MutableTcpPacket, src_ip: IpAddr, src_port:u16, dst_ip: IpAddr, dst_port:u16) {
    tcp_packet.set_source(src_port);
    tcp_packet.set_destination(dst_port);
    tcp_packet.set_window(64240);
    tcp_packet.set_data_offset(8);
    tcp_packet.set_urgent_ptr(0);
    tcp_packet.set_sequence(0);
    tcp_packet.set_options(&[TcpOption::mss(1460)
    , TcpOption::sack_perm()
    , TcpOption::nop()
    , TcpOption::nop()
    , TcpOption::wscale(7)]);
    tcp_packet.set_flags(TcpFlags::SYN);
    match src_ip {
        IpAddr::V4(src_ip) => {
            match dst_ip {
                IpAddr::V4(dst_ip) => {
                    let checksum = pnet::packet::tcp::ipv4_checksum(&tcp_packet.to_immutable(), &src_ip, &dst_ip);
                    tcp_packet.set_checksum(checksum);
                },
                IpAddr::V6(_) => {},
            }
        },
        IpAddr::V6(src_ip) => {
            match dst_ip {
                IpAddr::V4(_) => {},
                IpAddr::V6(dst_ip) => {
                    let checksum = pnet::packet::tcp::ipv6_checksum(&tcp_packet.to_immutable(), &src_ip, &dst_ip);
                    tcp_packet.set_checksum(checksum);
                },
            }
        },
    }
}
