pub mod setting;
pub mod service;

#[cfg(test)]
mod tests {
    use std::net::{IpAddr, Ipv4Addr};
    use dns_lookup;
    use crate::setting::{Destination, PortDatabase};
    use crate::service;
    #[test]
    fn detect_test() {
        match dns_lookup::lookup_host("google.com") {
            Ok(ips) => {
                let mut ip_addr: IpAddr = IpAddr::V4(Ipv4Addr::new(127,0,0,1));
                for ip in ips {
                    match ip {
                        IpAddr::V4(_) => {
                            ip_addr = ip;
                        },
                        IpAddr::V6(_) => continue,
                    }
                }
                if ip_addr == IpAddr::V4(Ipv4Addr::new(127,0,0,1)) {
                    return;
                }
                let dst = Destination {
                    dst_ip: ip_addr,
                    dst_name: String::from("google.com"),
                    open_ports: vec![80, 443],
                    accept_invalid_certs: false,
                };
                let db = PortDatabase {
                    http_ports: vec![80],
                    https_ports: vec![443],
                };
                let service_map = service::detect_service(dst, db);
                println!("{:?}", service_map);
            },
            Err(e) => println!("{}", e)
        }
    }
}
