/*
 * Netlify's API documentation
 *
 * Netlify is a hosting service for the programmable web. It understands your documents and provides an API to handle atomic deploys of websites, manage form submissions, inject JavaScript snippets, and much more. This is a REST-style API that uses JSON for serialization and OAuth 2 for authentication.  This document is an OpenAPI reference for the Netlify API that you can explore. For more detailed instructions for common uses, please visit the [online documentation](https://www.netlify.com/docs/api/). Visit our Community forum to join the conversation about [understanding and using Netlify’s API](https://community.netlify.com/t/common-issue-understanding-and-using-netlifys-api/160).  Additionally, we have two API clients for your convenience: - [Go Client](https://github.com/netlify/open-api#go-client) - [JS Client](https://github.com/netlify/js-client)
 *
 * The version of the OpenAPI document: 2.5.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct RepoInfo {
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<i32>,
    #[serde(rename = "provider", skip_serializing_if = "Option::is_none")]
    pub provider: Option<String>,
    #[serde(rename = "deploy_key_id", skip_serializing_if = "Option::is_none")]
    pub deploy_key_id: Option<String>,
    #[serde(rename = "repo_path", skip_serializing_if = "Option::is_none")]
    pub repo_path: Option<String>,
    #[serde(rename = "repo_branch", skip_serializing_if = "Option::is_none")]
    pub repo_branch: Option<String>,
    #[serde(rename = "dir", skip_serializing_if = "Option::is_none")]
    pub dir: Option<String>,
    #[serde(rename = "functions_dir", skip_serializing_if = "Option::is_none")]
    pub functions_dir: Option<String>,
    #[serde(rename = "cmd", skip_serializing_if = "Option::is_none")]
    pub cmd: Option<String>,
    #[serde(rename = "allowed_branches", skip_serializing_if = "Option::is_none")]
    pub allowed_branches: Option<Vec<String>>,
    #[serde(rename = "public_repo", skip_serializing_if = "Option::is_none")]
    pub public_repo: Option<bool>,
    #[serde(rename = "private_logs", skip_serializing_if = "Option::is_none")]
    pub private_logs: Option<bool>,
    #[serde(rename = "repo_url", skip_serializing_if = "Option::is_none")]
    pub repo_url: Option<String>,
    #[serde(rename = "env", skip_serializing_if = "Option::is_none")]
    pub env: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "installation_id", skip_serializing_if = "Option::is_none")]
    pub installation_id: Option<i32>,
    #[serde(rename = "stop_builds", skip_serializing_if = "Option::is_none")]
    pub stop_builds: Option<bool>,
}

impl RepoInfo {
    pub fn new() -> RepoInfo {
        RepoInfo {
            id: None,
            provider: None,
            deploy_key_id: None,
            repo_path: None,
            repo_branch: None,
            dir: None,
            functions_dir: None,
            cmd: None,
            allowed_branches: None,
            public_repo: None,
            private_logs: None,
            repo_url: None,
            env: None,
            installation_id: None,
            stop_builds: None,
        }
    }
}


