/*
 * Netlify's API documentation
 *
 * Netlify is a hosting service for the programmable web. It understands your documents and provides an API to handle atomic deploys of websites, manage form submissions, inject JavaScript snippets, and much more. This is a REST-style API that uses JSON for serialization and OAuth 2 for authentication.  This document is an OpenAPI reference for the Netlify API that you can explore. For more detailed instructions for common uses, please visit the [online documentation](https://www.netlify.com/docs/api/). Visit our Community forum to join the conversation about [understanding and using Netlify’s API](https://community.netlify.com/t/common-issue-understanding-and-using-netlifys-api/160).  Additionally, we have two API clients for your convenience: - [Go Client](https://github.com/netlify/open-api#go-client) - [JS Client](https://github.com/netlify/js-client)
 *
 * The version of the OpenAPI document: 2.5.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DeployFiles {
    #[serde(rename = "files", skip_serializing_if = "Option::is_none")]
    pub files: Option<serde_json::Value>,
    #[serde(rename = "draft", skip_serializing_if = "Option::is_none")]
    pub draft: Option<bool>,
    #[serde(rename = "async", skip_serializing_if = "Option::is_none")]
    pub _async: Option<bool>,
    #[serde(rename = "functions", skip_serializing_if = "Option::is_none")]
    pub functions: Option<serde_json::Value>,
    #[serde(rename = "branch", skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[serde(rename = "framework", skip_serializing_if = "Option::is_none")]
    pub framework: Option<String>,
}

impl DeployFiles {
    pub fn new() -> DeployFiles {
        DeployFiles {
            files: None,
            draft: None,
            _async: None,
            functions: None,
            branch: None,
            framework: None,
        }
    }
}


