/*
 * Netlify's API documentation
 *
 * Netlify is a hosting service for the programmable web. It understands your documents and provides an API to handle atomic deploys of websites, manage form submissions, inject JavaScript snippets, and much more. This is a REST-style API that uses JSON for serialization and OAuth 2 for authentication.  This document is an OpenAPI reference for the Netlify API that you can explore. For more detailed instructions for common uses, please visit the [online documentation](https://www.netlify.com/docs/api/). Visit our Community forum to join the conversation about [understanding and using Netlify’s API](https://community.netlify.com/t/common-issue-understanding-and-using-netlifys-api/160).  Additionally, we have two API clients for your convenience: - [Go Client](https://github.com/netlify/open-api#go-client) - [JS Client](https://github.com/netlify/js-client)
 *
 * The version of the OpenAPI document: 2.5.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Deploy {
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "site_id", skip_serializing_if = "Option::is_none")]
    pub site_id: Option<String>,
    #[serde(rename = "user_id", skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
    #[serde(rename = "build_id", skip_serializing_if = "Option::is_none")]
    pub build_id: Option<String>,
    #[serde(rename = "state", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    #[serde(rename = "ssl_url", skip_serializing_if = "Option::is_none")]
    pub ssl_url: Option<String>,
    #[serde(rename = "admin_url", skip_serializing_if = "Option::is_none")]
    pub admin_url: Option<String>,
    #[serde(rename = "deploy_url", skip_serializing_if = "Option::is_none")]
    pub deploy_url: Option<String>,
    #[serde(rename = "deploy_ssl_url", skip_serializing_if = "Option::is_none")]
    pub deploy_ssl_url: Option<String>,
    #[serde(rename = "screenshot_url", skip_serializing_if = "Option::is_none")]
    pub screenshot_url: Option<String>,
    #[serde(rename = "review_id", skip_serializing_if = "Option::is_none")]
    pub review_id: Option<f32>,
    #[serde(rename = "draft", skip_serializing_if = "Option::is_none")]
    pub draft: Option<bool>,
    #[serde(rename = "required", skip_serializing_if = "Option::is_none")]
    pub required: Option<Vec<String>>,
    #[serde(rename = "required_functions", skip_serializing_if = "Option::is_none")]
    pub required_functions: Option<Vec<String>>,
    #[serde(rename = "error_message", skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
    #[serde(rename = "branch", skip_serializing_if = "Option::is_none")]
    pub branch: Option<String>,
    #[serde(rename = "commit_ref", skip_serializing_if = "Option::is_none")]
    pub commit_ref: Option<String>,
    #[serde(rename = "commit_url", skip_serializing_if = "Option::is_none")]
    pub commit_url: Option<String>,
    #[serde(rename = "skipped", skip_serializing_if = "Option::is_none")]
    pub skipped: Option<bool>,
    #[serde(rename = "created_at", skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "updated_at", skip_serializing_if = "Option::is_none")]
    pub updated_at: Option<String>,
    #[serde(rename = "published_at", skip_serializing_if = "Option::is_none")]
    pub published_at: Option<String>,
    #[serde(rename = "title", skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    #[serde(rename = "context", skip_serializing_if = "Option::is_none")]
    pub context: Option<String>,
    #[serde(rename = "locked", skip_serializing_if = "Option::is_none")]
    pub locked: Option<bool>,
    #[serde(rename = "review_url", skip_serializing_if = "Option::is_none")]
    pub review_url: Option<String>,
    #[serde(rename = "site_capabilities", skip_serializing_if = "Option::is_none")]
    pub site_capabilities: Option<Box<crate::models::DeploySiteCapabilities>>,
    #[serde(rename = "framework", skip_serializing_if = "Option::is_none")]
    pub framework: Option<String>,
}

impl Deploy {
    pub fn new() -> Deploy {
        Deploy {
            id: None,
            site_id: None,
            user_id: None,
            build_id: None,
            state: None,
            name: None,
            url: None,
            ssl_url: None,
            admin_url: None,
            deploy_url: None,
            deploy_ssl_url: None,
            screenshot_url: None,
            review_id: None,
            draft: None,
            required: None,
            required_functions: None,
            error_message: None,
            branch: None,
            commit_ref: None,
            commit_url: None,
            skipped: None,
            created_at: None,
            updated_at: None,
            published_at: None,
            title: None,
            context: None,
            locked: None,
            review_url: None,
            site_capabilities: None,
            framework: None,
        }
    }
}


