/*
 * Netlify's API documentation
 *
 * Netlify is a hosting service for the programmable web. It understands your documents and provides an API to handle atomic deploys of websites, manage form submissions, inject JavaScript snippets, and much more. This is a REST-style API that uses JSON for serialization and OAuth 2 for authentication.  This document is an OpenAPI reference for the Netlify API that you can explore. For more detailed instructions for common uses, please visit the [online documentation](https://www.netlify.com/docs/api/). Visit our Community forum to join the conversation about [understanding and using Netlify’s API](https://community.netlify.com/t/common-issue-understanding-and-using-netlifys-api/160).  Additionally, we have two API clients for your convenience: - [Go Client](https://github.com/netlify/open-api#go-client) - [JS Client](https://github.com/netlify/js-client)
 *
 * The version of the OpenAPI document: 2.5.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BuildStatusMinutes {
    #[serde(rename = "current", skip_serializing_if = "Option::is_none")]
    pub current: Option<i32>,
    #[serde(rename = "current_average_sec", skip_serializing_if = "Option::is_none")]
    pub current_average_sec: Option<i32>,
    #[serde(rename = "previous", skip_serializing_if = "Option::is_none")]
    pub previous: Option<i32>,
    #[serde(rename = "period_start_date", skip_serializing_if = "Option::is_none")]
    pub period_start_date: Option<String>,
    #[serde(rename = "period_end_date", skip_serializing_if = "Option::is_none")]
    pub period_end_date: Option<String>,
    #[serde(rename = "last_updated_at", skip_serializing_if = "Option::is_none")]
    pub last_updated_at: Option<String>,
    #[serde(rename = "included_minutes", skip_serializing_if = "Option::is_none")]
    pub included_minutes: Option<String>,
    #[serde(rename = "included_minutes_with_packs", skip_serializing_if = "Option::is_none")]
    pub included_minutes_with_packs: Option<String>,
}

impl BuildStatusMinutes {
    pub fn new() -> BuildStatusMinutes {
        BuildStatusMinutes {
            current: None,
            current_average_sec: None,
            previous: None,
            period_start_date: None,
            period_end_date: None,
            last_updated_at: None,
            included_minutes: None,
            included_minutes_with_packs: None,
        }
    }
}


