/*
 * Netlify's API documentation
 *
 * Netlify is a hosting service for the programmable web. It understands your documents and provides an API to handle atomic deploys of websites, manage form submissions, inject JavaScript snippets, and much more. This is a REST-style API that uses JSON for serialization and OAuth 2 for authentication.  This document is an OpenAPI reference for the Netlify API that you can explore. For more detailed instructions for common uses, please visit the [online documentation](https://www.netlify.com/docs/api/). Visit our Community forum to join the conversation about [understanding and using Netlify’s API](https://community.netlify.com/t/common-issue-understanding-and-using-netlifys-api/160).  Additionally, we have two API clients for your convenience: - [Go Client](https://github.com/netlify/open-api#go-client) - [JS Client](https://github.com/netlify/js-client)
 *
 * The version of the OpenAPI document: 2.5.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AccountUpdateSetup {
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "slug", skip_serializing_if = "Option::is_none")]
    pub slug: Option<String>,
    #[serde(rename = "type_id", skip_serializing_if = "Option::is_none")]
    pub type_id: Option<String>,
    #[serde(rename = "extra_seats_block", skip_serializing_if = "Option::is_none")]
    pub extra_seats_block: Option<i32>,
    #[serde(rename = "billing_name", skip_serializing_if = "Option::is_none")]
    pub billing_name: Option<String>,
    #[serde(rename = "billing_email", skip_serializing_if = "Option::is_none")]
    pub billing_email: Option<String>,
    #[serde(rename = "billing_details", skip_serializing_if = "Option::is_none")]
    pub billing_details: Option<String>,
}

impl AccountUpdateSetup {
    pub fn new() -> AccountUpdateSetup {
        AccountUpdateSetup {
            name: None,
            slug: None,
            type_id: None,
            extra_seats_block: None,
            billing_name: None,
            billing_email: None,
            billing_details: None,
        }
    }
}


