# Rust API client for openapi

Netlify is a hosting service for the programmable web. It understands your documents and provides an API to handle atomic deploys of websites, manage form submissions, inject JavaScript snippets, and much more. This is a REST-style API that uses JSON for serialization and OAuth 2 for authentication.

This document is an OpenAPI reference for the Netlify API that you can explore. For more detailed instructions for common uses, please visit the [online documentation](https://www.netlify.com/docs/api/). Visit our Community forum to join the conversation about [understanding and using Netlify’s API](https://community.netlify.com/t/common-issue-understanding-and-using-netlifys-api/160).

Additionally, we have two API clients for your convenience:
- [Go Client](https://github.com/netlify/open-api#go-client)
- [JS Client](https://github.com/netlify/js-client)

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 2.5.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.netlify.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessTokenApi* | [**exchange_ticket**](docs/AccessTokenApi.md#exchange_ticket) | **POST** /oauth/tickets/{ticket_id}/exchange | 
*AccountMembershipApi* | [**cancel_account**](docs/AccountMembershipApi.md#cancel_account) | **DELETE** /accounts/{account_id} | 
*AccountMembershipApi* | [**create_account**](docs/AccountMembershipApi.md#create_account) | **POST** /accounts | 
*AccountMembershipApi* | [**get_account**](docs/AccountMembershipApi.md#get_account) | **GET** /accounts/{account_id} | 
*AccountMembershipApi* | [**list_accounts_for_user**](docs/AccountMembershipApi.md#list_accounts_for_user) | **GET** /accounts | 
*AccountMembershipApi* | [**update_account**](docs/AccountMembershipApi.md#update_account) | **PUT** /accounts/{account_id} | 
*AccountTypeApi* | [**list_account_types_for_user**](docs/AccountTypeApi.md#list_account_types_for_user) | **GET** /accounts/types | 
*AssetApi* | [**create_site_asset**](docs/AssetApi.md#create_site_asset) | **POST** /sites/{site_id}/assets | 
*AssetApi* | [**delete_site_asset**](docs/AssetApi.md#delete_site_asset) | **DELETE** /sites/{site_id}/assets/{asset_id} | 
*AssetApi* | [**get_site_asset_info**](docs/AssetApi.md#get_site_asset_info) | **GET** /sites/{site_id}/assets/{asset_id} | 
*AssetApi* | [**list_site_assets**](docs/AssetApi.md#list_site_assets) | **GET** /sites/{site_id}/assets | 
*AssetApi* | [**update_site_asset**](docs/AssetApi.md#update_site_asset) | **PUT** /sites/{site_id}/assets/{asset_id} | 
*AssetPublicSignatureApi* | [**get_site_asset_public_signature**](docs/AssetPublicSignatureApi.md#get_site_asset_public_signature) | **GET** /sites/{site_id}/assets/{asset_id}/public_signature | 
*AuditLogApi* | [**list_account_audit_events**](docs/AuditLogApi.md#list_account_audit_events) | **GET** /accounts/{account_id}/audit | 
*BuildApi* | [**create_site_build**](docs/BuildApi.md#create_site_build) | **POST** /sites/{site_id}/builds | 
*BuildApi* | [**get_account_build_status**](docs/BuildApi.md#get_account_build_status) | **GET** /{account_id}/builds/status | 
*BuildApi* | [**get_site_build**](docs/BuildApi.md#get_site_build) | **GET** /builds/{build_id} | 
*BuildApi* | [**list_site_builds**](docs/BuildApi.md#list_site_builds) | **GET** /sites/{site_id}/builds | 
*BuildApi* | [**notify_build_start**](docs/BuildApi.md#notify_build_start) | **POST** /builds/{build_id}/start | 
*BuildHookApi* | [**create_site_build_hook**](docs/BuildHookApi.md#create_site_build_hook) | **POST** /sites/{site_id}/build_hooks | 
*BuildHookApi* | [**delete_site_build_hook**](docs/BuildHookApi.md#delete_site_build_hook) | **DELETE** /sites/{site_id}/build_hooks/{id} | 
*BuildHookApi* | [**get_site_build_hook**](docs/BuildHookApi.md#get_site_build_hook) | **GET** /sites/{site_id}/build_hooks/{id} | 
*BuildHookApi* | [**list_site_build_hooks**](docs/BuildHookApi.md#list_site_build_hooks) | **GET** /sites/{site_id}/build_hooks | 
*BuildHookApi* | [**update_site_build_hook**](docs/BuildHookApi.md#update_site_build_hook) | **PUT** /sites/{site_id}/build_hooks/{id} | 
*BuildLogMsgApi* | [**update_site_build_log**](docs/BuildLogMsgApi.md#update_site_build_log) | **POST** /builds/{build_id}/log | 
*DeployApi* | [**cancel_site_deploy**](docs/DeployApi.md#cancel_site_deploy) | **POST** /deploys/{deploy_id}/cancel | 
*DeployApi* | [**create_site_deploy**](docs/DeployApi.md#create_site_deploy) | **POST** /sites/{site_id}/deploys | 
*DeployApi* | [**get_deploy**](docs/DeployApi.md#get_deploy) | **GET** /deploys/{deploy_id} | 
*DeployApi* | [**get_site_deploy**](docs/DeployApi.md#get_site_deploy) | **GET** /sites/{site_id}/deploys/{deploy_id} | 
*DeployApi* | [**list_site_deploys**](docs/DeployApi.md#list_site_deploys) | **GET** /sites/{site_id}/deploys | 
*DeployApi* | [**lock_deploy**](docs/DeployApi.md#lock_deploy) | **POST** /deploys/{deploy_id}/lock | 
*DeployApi* | [**restore_site_deploy**](docs/DeployApi.md#restore_site_deploy) | **POST** /sites/{site_id}/deploys/{deploy_id}/restore | 
*DeployApi* | [**rollback_site_deploy**](docs/DeployApi.md#rollback_site_deploy) | **PUT** /sites/{site_id}/rollback | 
*DeployApi* | [**unlock_deploy**](docs/DeployApi.md#unlock_deploy) | **POST** /deploys/{deploy_id}/unlock | 
*DeployApi* | [**update_site_deploy**](docs/DeployApi.md#update_site_deploy) | **PUT** /sites/{site_id}/deploys/{deploy_id} | 
*DeployKeyApi* | [**create_deploy_key**](docs/DeployKeyApi.md#create_deploy_key) | **POST** /deploy_keys | 
*DeployKeyApi* | [**delete_deploy_key**](docs/DeployKeyApi.md#delete_deploy_key) | **DELETE** /deploy_keys/{key_id} | 
*DeployKeyApi* | [**get_deploy_key**](docs/DeployKeyApi.md#get_deploy_key) | **GET** /deploy_keys/{key_id} | 
*DeployKeyApi* | [**list_deploy_keys**](docs/DeployKeyApi.md#list_deploy_keys) | **GET** /deploy_keys | 
*DeployedBranchApi* | [**list_site_deployed_branches**](docs/DeployedBranchApi.md#list_site_deployed_branches) | **GET** /sites/{site_id}/deployed-branches | 
*DnsZoneApi* | [**configure_dns_for_site**](docs/DnsZoneApi.md#configure_dns_for_site) | **PUT** /sites/{site_id}/dns | 
*DnsZoneApi* | [**create_dns_record**](docs/DnsZoneApi.md#create_dns_record) | **POST** /dns_zones/{zone_id}/dns_records | 
*DnsZoneApi* | [**create_dns_zone**](docs/DnsZoneApi.md#create_dns_zone) | **POST** /dns_zones | 
*DnsZoneApi* | [**delete_dns_record**](docs/DnsZoneApi.md#delete_dns_record) | **DELETE** /dns_zones/{zone_id}/dns_records/{dns_record_id} | 
*DnsZoneApi* | [**delete_dns_zone**](docs/DnsZoneApi.md#delete_dns_zone) | **DELETE** /dns_zones/{zone_id} | 
*DnsZoneApi* | [**get_dns_for_site**](docs/DnsZoneApi.md#get_dns_for_site) | **GET** /sites/{site_id}/dns | 
*DnsZoneApi* | [**get_dns_records**](docs/DnsZoneApi.md#get_dns_records) | **GET** /dns_zones/{zone_id}/dns_records | 
*DnsZoneApi* | [**get_dns_zone**](docs/DnsZoneApi.md#get_dns_zone) | **GET** /dns_zones/{zone_id} | 
*DnsZoneApi* | [**get_dns_zones**](docs/DnsZoneApi.md#get_dns_zones) | **GET** /dns_zones | 
*DnsZoneApi* | [**get_individual_dns_record**](docs/DnsZoneApi.md#get_individual_dns_record) | **GET** /dns_zones/{zone_id}/dns_records/{dns_record_id} | 
*DnsZoneApi* | [**transfer_dns_zone**](docs/DnsZoneApi.md#transfer_dns_zone) | **PUT** /dns_zones/{zone_id}/transfer | 
*FileApi* | [**get_site_file_by_path_name**](docs/FileApi.md#get_site_file_by_path_name) | **GET** /sites/{site_id}/files/{file_path} | 
*FileApi* | [**list_site_files**](docs/FileApi.md#list_site_files) | **GET** /sites/{site_id}/files | 
*FileApi* | [**upload_deploy_file**](docs/FileApi.md#upload_deploy_file) | **PUT** /deploys/{deploy_id}/files/{path} | 
*FormApi* | [**delete_site_form**](docs/FormApi.md#delete_site_form) | **DELETE** /sites/{site_id}/forms/{form_id} | 
*FormApi* | [**list_site_forms**](docs/FormApi.md#list_site_forms) | **GET** /sites/{site_id}/forms | 
*FunctionApi* | [**upload_deploy_function**](docs/FunctionApi.md#upload_deploy_function) | **PUT** /deploys/{deploy_id}/functions/{name} | 
*HookApi* | [**create_hook_by_site_id**](docs/HookApi.md#create_hook_by_site_id) | **POST** /hooks | 
*HookApi* | [**delete_hook**](docs/HookApi.md#delete_hook) | **DELETE** /hooks/{hook_id} | 
*HookApi* | [**enable_hook**](docs/HookApi.md#enable_hook) | **POST** /hooks/{hook_id}/enable | 
*HookApi* | [**get_hook**](docs/HookApi.md#get_hook) | **GET** /hooks/{hook_id} | 
*HookApi* | [**list_hooks_by_site_id**](docs/HookApi.md#list_hooks_by_site_id) | **GET** /hooks | 
*HookApi* | [**update_hook**](docs/HookApi.md#update_hook) | **PUT** /hooks/{hook_id} | 
*HookTypeApi* | [**list_hook_types**](docs/HookTypeApi.md#list_hook_types) | **GET** /hooks/types | 
*MemberApi* | [**add_member_to_account**](docs/MemberApi.md#add_member_to_account) | **POST** /{account_slug}/members | 
*MemberApi* | [**list_members_for_account**](docs/MemberApi.md#list_members_for_account) | **GET** /{account_slug}/members | 
*MetadataApi* | [**get_site_metadata**](docs/MetadataApi.md#get_site_metadata) | **GET** /sites/{site_id}/metadata | 
*MetadataApi* | [**update_site_metadata**](docs/MetadataApi.md#update_site_metadata) | **PUT** /sites/{site_id}/metadata | 
*PaymentMethodApi* | [**list_payment_methods_for_user**](docs/PaymentMethodApi.md#list_payment_methods_for_user) | **GET** /billing/payment_methods | 
*ServiceApi* | [**get_services**](docs/ServiceApi.md#get_services) | **GET** /services/ | 
*ServiceApi* | [**show_service**](docs/ServiceApi.md#show_service) | **GET** /services/{addonName} | 
*ServiceApi* | [**show_service_manifest**](docs/ServiceApi.md#show_service_manifest) | **GET** /services/{addonName}/manifest | 
*ServiceInstanceApi* | [**create_service_instance**](docs/ServiceInstanceApi.md#create_service_instance) | **POST** /sites/{site_id}/services/{addon}/instances | 
*ServiceInstanceApi* | [**delete_service_instance**](docs/ServiceInstanceApi.md#delete_service_instance) | **DELETE** /sites/{site_id}/services/{addon}/instances/{instance_id} | 
*ServiceInstanceApi* | [**list_service_instances_for_site**](docs/ServiceInstanceApi.md#list_service_instances_for_site) | **GET** /sites/{site_id}/service-instances | 
*ServiceInstanceApi* | [**show_service_instance**](docs/ServiceInstanceApi.md#show_service_instance) | **GET** /sites/{site_id}/services/{addon}/instances/{instance_id} | 
*ServiceInstanceApi* | [**update_service_instance**](docs/ServiceInstanceApi.md#update_service_instance) | **PUT** /sites/{site_id}/services/{addon}/instances/{instance_id} | 
*SiteApi* | [**create_site**](docs/SiteApi.md#create_site) | **POST** /sites | 
*SiteApi* | [**create_site_in_team**](docs/SiteApi.md#create_site_in_team) | **POST** /{account_slug}/sites | 
*SiteApi* | [**delete_site**](docs/SiteApi.md#delete_site) | **DELETE** /sites/{site_id} | 
*SiteApi* | [**get_site**](docs/SiteApi.md#get_site) | **GET** /sites/{site_id} | 
*SiteApi* | [**list_sites**](docs/SiteApi.md#list_sites) | **GET** /sites | 
*SiteApi* | [**list_sites_for_account**](docs/SiteApi.md#list_sites_for_account) | **GET** /{account_slug}/sites | 
*SiteApi* | [**unlink_site_repo**](docs/SiteApi.md#unlink_site_repo) | **PUT** /sites/{site_id}/unlink_repo | 
*SiteApi* | [**update_site**](docs/SiteApi.md#update_site) | **PATCH** /sites/{site_id} | 
*SniCertificateApi* | [**provision_site_tls_certificate**](docs/SniCertificateApi.md#provision_site_tls_certificate) | **POST** /sites/{site_id}/ssl | 
*SniCertificateApi* | [**show_site_tls_certificate**](docs/SniCertificateApi.md#show_site_tls_certificate) | **GET** /sites/{site_id}/ssl | 
*SnippetApi* | [**create_site_snippet**](docs/SnippetApi.md#create_site_snippet) | **POST** /sites/{site_id}/snippets | 
*SnippetApi* | [**delete_site_snippet**](docs/SnippetApi.md#delete_site_snippet) | **DELETE** /sites/{site_id}/snippets/{snippet_id} | 
*SnippetApi* | [**get_site_snippet**](docs/SnippetApi.md#get_site_snippet) | **GET** /sites/{site_id}/snippets/{snippet_id} | 
*SnippetApi* | [**list_site_snippets**](docs/SnippetApi.md#list_site_snippets) | **GET** /sites/{site_id}/snippets | 
*SnippetApi* | [**update_site_snippet**](docs/SnippetApi.md#update_site_snippet) | **PUT** /sites/{site_id}/snippets/{snippet_id} | 
*SplitTestApi* | [**create_split_test**](docs/SplitTestApi.md#create_split_test) | **POST** /sites/{site_id}/traffic_splits | 
*SplitTestApi* | [**disable_split_test**](docs/SplitTestApi.md#disable_split_test) | **POST** /sites/{site_id}/traffic_splits/{split_test_id}/unpublish | 
*SplitTestApi* | [**enable_split_test**](docs/SplitTestApi.md#enable_split_test) | **POST** /sites/{site_id}/traffic_splits/{split_test_id}/publish | 
*SplitTestApi* | [**get_split_test**](docs/SplitTestApi.md#get_split_test) | **GET** /sites/{site_id}/traffic_splits/{split_test_id} | 
*SplitTestApi* | [**get_split_tests**](docs/SplitTestApi.md#get_split_tests) | **GET** /sites/{site_id}/traffic_splits | 
*SplitTestApi* | [**update_split_test**](docs/SplitTestApi.md#update_split_test) | **PUT** /sites/{site_id}/traffic_splits/{split_test_id} | 
*SubmissionApi* | [**delete_submission**](docs/SubmissionApi.md#delete_submission) | **DELETE** /submissions/{submission_id} | 
*SubmissionApi* | [**list_form_submission**](docs/SubmissionApi.md#list_form_submission) | **GET** /submissions/{submission_id} | 
*SubmissionApi* | [**list_form_submissions**](docs/SubmissionApi.md#list_form_submissions) | **GET** /forms/{form_id}/submissions | 
*SubmissionApi* | [**list_site_submissions**](docs/SubmissionApi.md#list_site_submissions) | **GET** /sites/{site_id}/submissions | 
*TicketApi* | [**create_ticket**](docs/TicketApi.md#create_ticket) | **POST** /oauth/tickets | 
*TicketApi* | [**show_ticket**](docs/TicketApi.md#show_ticket) | **GET** /oauth/tickets/{ticket_id} | 
*UserApi* | [**get_current_user**](docs/UserApi.md#get_current_user) | **GET** /user | 
*XInternalApi* | [**create_plugin_run**](docs/XInternalApi.md#create_plugin_run) | **POST** /deploys/{deploy_id}/plugin_runs | 
*XInternalApi* | [**get_latest_plugin_runs**](docs/XInternalApi.md#get_latest_plugin_runs) | **GET** /sites/{site_id}/plugin_runs/latest | 
*XInternalApi* | [**update_plugin**](docs/XInternalApi.md#update_plugin) | **PUT** /sites/{site_id}/plugins/{package} | 


## Documentation For Models

 - [AccessToken](docs/AccessToken.md)
 - [AccountMembership](docs/AccountMembership.md)
 - [AccountMembershipCapabilities](docs/AccountMembershipCapabilities.md)
 - [AccountSetup](docs/AccountSetup.md)
 - [AccountType](docs/AccountType.md)
 - [AccountUpdateSetup](docs/AccountUpdateSetup.md)
 - [AccountUsageCapability](docs/AccountUsageCapability.md)
 - [Asset](docs/Asset.md)
 - [AssetForm](docs/AssetForm.md)
 - [AssetPublicSignature](docs/AssetPublicSignature.md)
 - [AssetSignature](docs/AssetSignature.md)
 - [AuditLog](docs/AuditLog.md)
 - [Build](docs/Build.md)
 - [BuildHook](docs/BuildHook.md)
 - [BuildHookSetup](docs/BuildHookSetup.md)
 - [BuildLogMsg](docs/BuildLogMsg.md)
 - [BuildSetup](docs/BuildSetup.md)
 - [BuildStatus](docs/BuildStatus.md)
 - [BuildStatusMinutes](docs/BuildStatusMinutes.md)
 - [Deploy](docs/Deploy.md)
 - [DeployFiles](docs/DeployFiles.md)
 - [DeployKey](docs/DeployKey.md)
 - [DeploySiteCapabilities](docs/DeploySiteCapabilities.md)
 - [DeployedBranch](docs/DeployedBranch.md)
 - [DnsRecord](docs/DnsRecord.md)
 - [DnsRecordCreate](docs/DnsRecordCreate.md)
 - [DnsZone](docs/DnsZone.md)
 - [DnsZoneSetup](docs/DnsZoneSetup.md)
 - [Error](docs/Error.md)
 - [File](docs/File.md)
 - [Form](docs/Form.md)
 - [Function](docs/Function.md)
 - [Hook](docs/Hook.md)
 - [HookType](docs/HookType.md)
 - [Member](docs/Member.md)
 - [MinifyOptions](docs/MinifyOptions.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [PaymentMethodData](docs/PaymentMethodData.md)
 - [Plugin](docs/Plugin.md)
 - [PluginParams](docs/PluginParams.md)
 - [PluginRun](docs/PluginRun.md)
 - [PluginRunAllOf](docs/PluginRunAllOf.md)
 - [PluginRunData](docs/PluginRunData.md)
 - [RepoInfo](docs/RepoInfo.md)
 - [Service](docs/Service.md)
 - [ServiceInstance](docs/ServiceInstance.md)
 - [Site](docs/Site.md)
 - [SiteDefaultHooksData](docs/SiteDefaultHooksData.md)
 - [SiteProcessingSettings](docs/SiteProcessingSettings.md)
 - [SiteProcessingSettingsHtml](docs/SiteProcessingSettingsHtml.md)
 - [SiteProcessingSettingsImages](docs/SiteProcessingSettingsImages.md)
 - [SiteSetup](docs/SiteSetup.md)
 - [SiteSetupAllOf](docs/SiteSetupAllOf.md)
 - [SniCertificate](docs/SniCertificate.md)
 - [Snippet](docs/Snippet.md)
 - [SplitTest](docs/SplitTest.md)
 - [SplitTestSetup](docs/SplitTestSetup.md)
 - [Submission](docs/Submission.md)
 - [Ticket](docs/Ticket.md)
 - [User](docs/User.md)
 - [UserOnboardingProgress](docs/UserOnboardingProgress.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



