## Module 'math'

* ```acos(number)```

    Returns the arc cosine of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

Example: ```acos(1) //0.0```

* ```asin(number)```

    Returns the arc sine of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```asin(0) //0.0```

* ```atan(number)```

    Returns the arc tangent of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```atan(0) //0.0```

* ```cbrt(number)```

    Returns the cube root of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```cbrt(0) //0.0```

* ```ceil(number)```

    Returns the ceiling of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```ceil(1.5) //2.0```

* ```cos(number)```

    Returns the cosine of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```cos(0) //1.0```

* ```floor(number)```

    Returns the floor of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```floor(1.5) //1.0```

* ```round(number)```

    Returns the ```number``` rounded. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```round(1.5) //2.0```

* ```sin(number)```

    Returns the sine of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```sin(0) //0.0```

* ```sqrt(number)```

    Returns the square root of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```sqrt(1.0) //1.0```

* ```tan(number)```

    Returns the tangent of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```tan(0.0) //0.0```

* ```log(number)```

    Returns the natural logarithm of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```log(1.0) //0.0```

* ```log2(number)```

    Returns the base 2 logarithm of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```log2(1.0) //0.0```

* ```exp(number)```

    Returns e raised to the power of ```number```. Throws TypeError if ```number``` is not an ```Int``` or ```Float```

    Example: ```exp(0.0) //1.0```

* ```pow(base,exponent)```

    Returns ```base``` raised to the power of ```exponent```. TypeError if ```base``` or ```exponent``` is not an ```Int``` or ```Float```

    Example: ```pow(2,2) //4.0```

* ```abs(number)```

    Returns the absolute value of ```number```

    Example: ```abs(-2) //2```

* Constants

    ```NaN``` 

    ```Infinity```

    ```E```

    ```LN2```

    ```LOG2E```

    ```SQRT1_2```

    ```LN10```

    ```LOG10E```

    ```SQRT2```