Object.assign(window.search, {"doc_urls":["syntax.html#basic-syntax","syntax.html#comments","syntax.html#identifiers","syntax.html#statements","syntax.html#blocks","syntax.html#int-literals","syntax.html#float-literals","syntax.html#string-literals","types.html#types","types.html#object","types.html#int","types.html#float","types.html#bool","types.html#string","types.html#array","types.html#map","types.html#symbols","types.html#range","types.html#null","var_eq.html#variables-and-equality","var_eq.html#scope","var_eq.html#variable-declaration","var_eq.html#equality-and-strict-equality","fun_module.html#functions-and-modules","fun_module.html#functions","fun_module.html#modules","control_flow.html#control-flow","control_flow.html#basic-control-flow","control_flow.html#for-loop","control_flow.html#break-and-continue","control_flow.html#switch","control_flow.html#exception-handling","class_object.html#classes-and-objects","tasks_channels.html#tasks-and-channels","documentation.html#documentation","documentation/object.html#object","documentation/class.html#class","documentation/array.html#array","documentation/string.html#string","documentation/map.html#map","documentation/range.html#range","documentation/float.html#float","documentation/int.html#int","documentation/iterators.html#iterators","documentation/task.html#task","documentation/channel.html#channel","documentation/prelude.html#prelude","documentation/math.html#module-math","documentation/random.html#module-random","documentation/time.html#module-time","documentation/vm.html#module-vm","embed.html#embedding-api","embed.html#embedder-functions","embed.html#resources","internals.html#neptune-language-internals","internals.html#vm-design","internals.html#value-representation","internals.html#forloop-op","internals.html#wide-and-extrawide-arguments"],"index":{"documentStore":{"docInfo":{"0":{"body":0,"breadcrumbs":3,"title":2},"1":{"body":16,"breadcrumbs":2,"title":1},"10":{"body":18,"breadcrumbs":2,"title":1},"11":{"body":14,"breadcrumbs":2,"title":1},"12":{"body":32,"breadcrumbs":2,"title":1},"13":{"body":30,"breadcrumbs":2,"title":1},"14":{"body":28,"breadcrumbs":2,"title":1},"15":{"body":18,"breadcrumbs":2,"title":1},"16":{"body":22,"breadcrumbs":2,"title":1},"17":{"body":19,"breadcrumbs":2,"title":1},"18":{"body":5,"breadcrumbs":2,"title":1},"19":{"body":0,"breadcrumbs":4,"title":2},"2":{"body":7,"breadcrumbs":2,"title":1},"20":{"body":26,"breadcrumbs":3,"title":1},"21":{"body":25,"breadcrumbs":4,"title":2},"22":{"body":24,"breadcrumbs":5,"title":3},"23":{"body":0,"breadcrumbs":4,"title":2},"24":{"body":31,"breadcrumbs":3,"title":1},"25":{"body":78,"breadcrumbs":3,"title":1},"26":{"body":0,"breadcrumbs":4,"title":2},"27":{"body":15,"breadcrumbs":5,"title":3},"28":{"body":14,"breadcrumbs":3,"title":1},"29":{"body":12,"breadcrumbs":4,"title":2},"3":{"body":4,"breadcrumbs":2,"title":1},"30":{"body":40,"breadcrumbs":3,"title":1},"31":{"body":52,"breadcrumbs":4,"title":2},"32":{"body":69,"breadcrumbs":4,"title":2},"33":{"body":127,"breadcrumbs":4,"title":2},"34":{"body":20,"breadcrumbs":2,"title":1},"35":{"body":26,"breadcrumbs":3,"title":1},"36":{"body":17,"breadcrumbs":3,"title":1},"37":{"body":115,"breadcrumbs":3,"title":1},"38":{"body":37,"breadcrumbs":3,"title":1},"39":{"body":62,"breadcrumbs":3,"title":1},"4":{"body":6,"breadcrumbs":2,"title":1},"40":{"body":31,"breadcrumbs":3,"title":1},"41":{"body":24,"breadcrumbs":3,"title":1},"42":{"body":13,"breadcrumbs":3,"title":1},"43":{"body":108,"breadcrumbs":3,"title":1},"44":{"body":47,"breadcrumbs":3,"title":1},"45":{"body":9,"breadcrumbs":3,"title":1},"46":{"body":79,"breadcrumbs":3,"title":1},"47":{"body":211,"breadcrumbs":5,"title":2},"48":{"body":38,"breadcrumbs":5,"title":2},"49":{"body":13,"breadcrumbs":5,"title":2},"5":{"body":9,"breadcrumbs":3,"title":2},"50":{"body":51,"breadcrumbs":5,"title":2},"51":{"body":13,"breadcrumbs":4,"title":2},"52":{"body":54,"breadcrumbs":4,"title":2},"53":{"body":17,"breadcrumbs":3,"title":1},"54":{"body":0,"breadcrumbs":6,"title":3},"55":{"body":37,"breadcrumbs":5,"title":2},"56":{"body":62,"breadcrumbs":5,"title":2},"57":{"body":39,"breadcrumbs":5,"title":2},"58":{"body":110,"breadcrumbs":6,"title":3},"6":{"body":7,"breadcrumbs":3,"title":2},"7":{"body":27,"breadcrumbs":3,"title":2},"8":{"body":17,"breadcrumbs":2,"title":1},"9":{"body":16,"breadcrumbs":2,"title":1}},"docs":{"0":{"body":"","breadcrumbs":"Syntax » Basic Syntax","id":"0","title":"Basic Syntax"},"1":{"body":"Comments can be single line or multi-line Single line comment - // hello Multi line comment - /* hello */ Comments can nest /* /* nested */ */","breadcrumbs":"Syntax » Comments","id":"1","title":"Comments"},"10":{"body":"They are 32 bit signed integers. They can be manipulated using the operators +, -, *, -, %, <, <=, >, >=.Whenever any arithmetic operation overflows OverflowError is thrown. Shorthand assignment operators (+=,-=,etc.) can be used too.","breadcrumbs":"Types » Int","id":"10","title":"Int"},"11":{"body":"They are IEEE-754 double precision floating point numbers. Unlike Int errors in arithmetic operations result in NaN.","breadcrumbs":"Types » Float","id":"11","title":"Float"},"12":{"body":"There are two possible values: true and false. They can be manipulated using !(not),and and or. The latter two are short-circuiting(they dont compute the second value if the first is falsey/truthy). They can be used like the ternary operator in C. All values except false and null are considered truthy. let result = condition and 'true' or 'false'","breadcrumbs":"Types » Bool","id":"12","title":"Bool"},"13":{"body":"They are a sequence of characters encoded in UTF-8. They cannot be directly indexed but can be indexed using a range. \"Hello, 世界\"[7..10] //\"世\" The characters of a string can be got using the chars method which returns an iterator. Strings can be concated using the tilde ~ operator. Other types can be converted to strings using the toString method.","breadcrumbs":"Types » String","id":"13","title":"String"},"14":{"body":"They are a list of values. They can be indexed using the [] operator. They can grow or shrink using the push and pop methods. The elements can be iterated using the iter method. let a = [1,'hello',2] Arrays can also be sliced (indexed by range) like strings. [1, 2, 3, 4][1..3] //[2, 3]","breadcrumbs":"Types » Array","id":"14","title":"Array"},"15":{"body":"They are hashmaps that indexed using any type. The keys of a map can be iterated using the keys method but the order of keys is not defined. let m = Map{@a:1,2:false}\nm[2] //false\nm[\"abc\"]=1.5","breadcrumbs":"Types » Map","id":"15","title":"Map"},"16":{"body":"They are like strings but two symbols with the same contents are internally the same object. Comparing symbols are much faster than strings. They are used to store the names of properties and methods for quick access let cardColor = @red","breadcrumbs":"Types » Symbols","id":"16","title":"Symbols"},"17":{"body":"It denotes a range of integers. The range start..end contains all values with start <= x < end. It is an iterator. let r = 0..5\nr.collect() //[0, 1, 2, 3, 4,]","breadcrumbs":"Types » Range","id":"17","title":"Range"},"18":{"body":"It is used to denote nothing let linkedList = {next:null}","breadcrumbs":"Types » Null","id":"18","title":"Null"},"19":{"body":"","breadcrumbs":"Variables and Equality » Variables and Equality","id":"19","title":"Variables and Equality"},"2":{"body":"They can begin with _ or a letter and can contain letters, numbers and underscores.","breadcrumbs":"Syntax » Identifiers","id":"2","title":"Identifiers"},"20":{"body":"There are two types of scope: block scope and module scope. Variables declared in a block can be accessed within that block. Variables cannot be redeclared in a block but can be shadow a declaration from a higher scope. Variables declared at the top level have module scope.","breadcrumbs":"Variables and Equality » Scope","id":"20","title":"Scope"},"21":{"body":"Variables can be declared using let or const. Variables declared as const cannot be reassigned. const VERSION_STRING = '1.0.0' Variables can also be declared using 'destructuring declaration' let point = {x:1, y:2}\nlet {x,y} = point // x is 1 and y is 2","breadcrumbs":"Variables and Equality » Variable Declaration","id":"21","title":"Variable Declaration"},"22":{"body":"Variables can be tested for equality and strict equality using the == and === operators. Two values are strictly equal if they are equal and: They have the same type. So 1 and 1.0 are not strictly equal -0.0 and 0.0 are not strictly equal but NaN and NaN are","breadcrumbs":"Variables and Equality » Equality and Strict Equality","id":"22","title":"Equality and Strict Equality"},"23":{"body":"","breadcrumbs":"Functions and Modules » Functions and Modules","id":"23","title":"Functions and Modules"},"24":{"body":"Functions are can be declared as named functions: fun add(a,b){ return a+b\n} anonymous functions: let add = |a,b|a+b\n//or\nadd = |a,b|{return a+b} Functions can capture variables fun makeCounter(){ let count = 0 return ||{count+=1;return count}\n}\nlet counter = makeCounter()\ncounter() //1\ncounter() //2","breadcrumbs":"Functions and Modules » Functions","id":"24","title":"Functions"},"25":{"body":"Programs can be broken down into small pieces called modules. A new module is created by creating a new file and can be imported by using the import function. An embedder can decide how to resolve paths while importing. To share variables across modules they must be exported and then imported by the other module. A module variable that is exported can be accessed using the . operator. import('math').PI //3.1415926535898 If a module is imported multiple times only one copy of the module will be created and it will be reused. Example: //a.np\nexport fun f(){}\nexport class C{}\nexport let x=0 //b.np\nconst {x,C,f} = import(\"./a.np\") There are many inbuilt modules that can be used to generate random numbers, evaluate expressions at runtime,etc. They can be explored using the documentation. Functions/Classes that can be accessed from all modules are contained in the prelude module.","breadcrumbs":"Functions and Modules » Modules","id":"25","title":"Modules"},"26":{"body":"","breadcrumbs":"Control flow » Control flow","id":"26","title":"Control flow"},"27":{"body":"Like most languages Neptune lang supports if,if else and while statements. if x == 5{ print('five')\n} if cond { print('if')\n} else { print('else')\n} while x!==0 { x-=1\n}","breadcrumbs":"Control flow » Basic control flow","id":"27","title":"Basic control flow"},"28":{"body":"The for statement is used to loop through the values in an iterator. Refer the Iterator subchapter in the documentation for more information. for i in 0..10{ print(i)\n}","breadcrumbs":"Control flow » For loop","id":"28","title":"For loop"},"29":{"body":"They are used to exit a loop early. Break exits the loop while continue starts a new iteration of a loop.","breadcrumbs":"Control flow » Break and Continue","id":"29","title":"Break and Continue"},"3":{"body":"Statements may be separated by semicolons but it is not compulsory","breadcrumbs":"Syntax » Statements","id":"3","title":"Statements"},"30":{"body":"The switch statement can be used instead of an if else ladder. Unlike an if else ladder the time taken to go to the required statement is independent of the number of cases. Constant literals must be used as cases of the switch statement. default is used to execute a statement if nothing is matched. The or keyword can be used in a case as shown below. switch 1+1{ 1 or 2: print('1 or 2') default: print('other')\n}","breadcrumbs":"Control flow » Switch","id":"30","title":"Switch"},"31":{"body":"Exceptions are used to indicate errors. They are raised using throw. They can be caught using a try catch block. try{ throw new Error('abc')\n}catch e{ print(e.message) //abc\n} An error object contains two important fields: message - A description of the error stack - It contains the stack trace Error classes can be created by extending the class Error. For example, this is how the class TypeError is defined in the standard library. export class TypeError extends Error { construct(message) { super.construct(message) }\n}","breadcrumbs":"Control flow » Exception handling","id":"31","title":"Exception handling"},"32":{"body":"Classes are created using the class keyword class C extends Base{ construct(val){ super.construct() this.x=val } method1(){ return this.x }\n} Classes can inherit the methods of other classes using the extends keyword.If no parent class is given then it extends Object. The constructor is created by creating a method called construct. Objects of class C can be created by let c = new C(7) Methods of the parent class can be called by super. The this keyword represents the instance of the class. Properties can be get and set using the . operator or be using the [] operator. let person = {name:'abc', age:29}\nperson.age+=1\nperson[@gender]=@male // same as person.gender=@male Private properties begin with _. They cannot be accessed outside a method.","breadcrumbs":"Classes and Objects » Classes and Objects","id":"32","title":"Classes and Objects"},"33":{"body":"Tasks are lightweight units of concurrent execution. Tasks are created by the spawn() or spawn_link() functions . A task is killed when an uncaught exception is thrown but can also be killed by the kill() method. If a task fails it does not crash other tasks. spawn_link() links the newly created task with the task that created it. If two tasks are linked then one if one of them dies then the other will be killed. Tasks can be manually linked too. Tasks can also be given names for debugging purposes. Channels can be used to send() and recv() messages. If a task is waiting on a channel, it is woken up once the message is received. The join function can be used to wait for multiple tasks to complete. It throws an exception and if one of them fails. Errors from multiple tasks can be handled gracefully using the monitor() method of Task. An example is given below. class MySupervisor{ construct(){ this.monitorChan=new Channel() this.children=new Map() } // This method can be called even if it is running // restartPolicy can be // @permanent: it should be restarted if it exits // @transient: it should be restarted if it exits unsuccessfully // @temporary: it shouldnt be restarted spawn(f,restartPolicy){ let task=spawn(f) this.children[task]={f,restartPolicy} task.monitor(monitorChan) } run(){ while(true){ let task = monitorChan.recv(); let childEntry = this.children[task] switch childEntry.restartPolicy{ @permanent:this.spawn(childEntry.f,@permanent) @transient:if task.status === @killed{ this.spawn(childEntry.f,@transient) } //do nothing if @temporary } } }\n} All methods of Task can be viewed in the documentation section of the book.","breadcrumbs":"Tasks and Channels » Tasks and Channels","id":"33","title":"Tasks and Channels"},"34":{"body":"Object Class Array String Map Range Float Int Iterators Task Channel Prelude Module 'math' Module 'random' Module 'time' Module 'vm'","breadcrumbs":"Documentation » Documentation","id":"34","title":"Documentation"},"35":{"body":"All classes inherit from Object construct() Returns an empty object Example: new Object //{} toString() Returns the string corresponding to the object Example: 2.toString() //'2' getClass() Returns the class of the object Example: 2.getClass() //<Class Int>","breadcrumbs":"Documentation » Object » Object","id":"35","title":"Object"},"36":{"body":"getSuper() Returns the super class or null if it is Object Example: Int.getSuper() //<Class Object> name() Returns the name of the class Example: Int.name() //'Int'","breadcrumbs":"Documentation » Class » Class","id":"36","title":"Class"},"37":{"body":"construct(length,value) Returns an array of length length filled with value. Throws Error if length is negative and TypeError if length is not an Int Example: new Array(3,0) //[0,0,0] push(value) Appends value to its end Example let arr = [1,2]\narr.push(3)\narr[1,2,3] pop() Removes the last element and returns it. Throws IndexError if it is empty Example let arr = [1,2]\narr.pop() //2 len() Returns the length of the array Example let arr = [1,2]\narr.len() //2 insert(position,value) Inserts value at position. Throws IndexError if position is greater than its length and TypeError if position is not an Int Example let arr = [1,2]\narr.insert(0,3)\narr //[3,1,2] remove(position) Removes the value at position. Throws IndexError if position is greater than or equal to its length and TypeError if position is not an Int Example let arr = [1,2]\narr.remove(0)\narr //[2] clear() Removes all elements of the array Example let arr = [1,2]\narr.clear()\narr //[] iter() Returns an iterator to the elements of the array Example: [1,2,3].iter().collect() //[1,2,3] sort(compare) Sorts the array comparing by function compare. Example let arr = [4,1,3,2]\narr.sort(|x,y|x<y)\narr //[1,2,3,4]","breadcrumbs":"Documentation » Array » Array","id":"37","title":"Array"},"38":{"body":"construct() Returns an empty string Example new String() //'' find(str) Returns the position of the first occurence of str. Returns -1 if str is not present Example: 'abc'.find('bc') //1 replace(from,to) Returns a new string with all occurences of from replaced by to Example: 'abc'.replace('bc','xyz') //'axyz' chars() Returns an iterator to the characters of the string Example: 'abc'.chars().collect() //['a','b','c']","breadcrumbs":"Documentation » String » String","id":"38","title":"String"},"39":{"body":"construct() Returns and empty map Example: new Map() //Map {} contains(key) Returns whether key is in the map Example let map = Map{}\nmap.contains(2) //false remove(key) Removes the key from the map. Throws KeyError if the key is not present Example let map = Map{1:2,2:3}\nmap.remove(1)\nmap //Map{2:3} clear() Removes all keys from the map Example let map = Map{1:2,2:3}\nmap.clear()\nmap //Map{} len() Returns the number of keys in the map Example let map = Map{1:2,2:3}\nmap.len() //2 keys() Returns an iterator to the keys of the map Example let map = Map{1:2,2:3}\nmap.keys().collect() //[1,2]","breadcrumbs":"Documentation » Map » Map","id":"39","title":"Map"},"4":{"body":"They are declared using curly brackets { let a = 'hello' print(a)\n}","breadcrumbs":"Syntax » Blocks","id":"4","title":"Blocks"},"40":{"body":"construct(start,end) Returns a range whose start is start and end is end. Throws TypeError if start or end is not an Int Example: new Range(1,2) //1..2 start() Returns the start of the range Example (1..2).start() //1 end() Returns the end of the range Example (1..2).end() //2","breadcrumbs":"Documentation » Range » Range","id":"40","title":"Range"},"41":{"body":"construct() Returns 0.0 Example: new Float() //0.0 toInt() Returns its floor as an int. Throws OverflowError if it cannot be represented as an int Example (1.0).toInt() //1 isNaN() Returns if it is NaN Example (1.0).isNaN() //false","breadcrumbs":"Documentation » Float » Float","id":"41","title":"Float"},"42":{"body":"construct() Returns 0 Example: new Int() //0 toFloat() Returns it as a float Example 1.toFloat() //1.0","breadcrumbs":"Documentation » Int » Int","id":"42","title":"Int"},"43":{"body":"Iterators can be used in for-in loops. All iterators must have two methods hasNext: This should return a Bool indicating whether there are any more items left next: This should return the next element in the sequence Iterators that extend the class Iterator get the following methods each(fn) Calls function fn for all items in the iterator Example: let a=[]\n[1,2,3].iter().each(|x|a.push(x))\na //[1,2,3] all(fn) Returns if for all items in the interator fn(item) is truthy Example: [1,2,3].iter().all(|x|x<10) //true any(fn) Returns if for any item in the iterator fn(item) is truthy Example: [1,2,3].iter().any(|x|x==1) //true map(fn) Returns a new iterator whose items are fn(item) of the items of this iterator Example: [1,2,3].map(|x|x+1).collect() //[2,3,4] filter(fn) Returns a new iterator whose items are those items of this iterator for which fn(item) is truthy Example: [1,2,3].filter(|x|x%2==1).collect() //[1,3] collect() Collects all items of the iterator into an array Example: [1,2,3].iter().collect() //[1,2,3] count() Returns the number of items of the iterator Example: [1,2,3].iter().count() //3 reduce(fn,initial) Applys fn, a function of two arguments cummulatively to the items of the iterator starting with initial Example: [1,2,3].iter().reduce(|x,y|x+y,0) //6","breadcrumbs":"Documentation » Iterators » Iterators","id":"43","title":"Iterators"},"44":{"body":"kill(exception) Kills the task with exception name() Returns the name of the task setName(name) Sets the name of the task as name monitor(chan) When the task is completed or killed it sends the task to the channel chan. link(task2) Links the task to task2. If task2 is killed,it is killed and when it is killed, task2 is killed. status() Returns the status of the task (@running, @finished or @killed) getUncaughtException() Returns the uncaught exception that killed the task or null if there is no uncaught exception","breadcrumbs":"Documentation » Task » Task","id":"44","title":"Task"},"45":{"body":"send(msg) Sends the message msg to the channel recv() Consumes a message from the channel.","breadcrumbs":"Documentation » Channel » Channel","id":"45","title":"Channel"},"46":{"body":"All variables from this module are automatically in all modules print(value) Prints value eval(source) Evaluates expression source in the context of the current module and returns it. Throws TypeError if source is not a string and CompileError if there is a compile error. Example: eval('1+1') //2 exec(source) Executes expression source in the context of the current module. Throws TypeError if source is not a string and CompileError if source could not be compiled Example: eval('1+1') //2 spawn(fn) Spawns a new task with the function fn and returns the created task spawn_link(fn) Spawns a new task with the function fn which is linked with the current task and returns the created task. join(tasks) Waits for each task in tasks to complete. If any one task is killed, all tasks in tasks are killed and the error with which that task was killed is thrown.","breadcrumbs":"Documentation » Prelude » Prelude","id":"46","title":"Prelude"},"47":{"body":"acos(number) Returns the arc cosine of number. Throws TypeError if number is not an Int or Float Example: acos(1) //0.0 asin(number) Returns the arc sine of number. Throws TypeError if number is not an Int or Float Example: asin(0) //0.0 atan(number) Returns the arc tangent of number. Throws TypeError if number is not an Int or Float Example: atan(0) //0.0 cbrt(number) Returns the cube root of number. Throws TypeError if number is not an Int or Float Example: cbrt(0) //0.0 ceil(number) Returns the ceiling of number. Throws TypeError if number is not an Int or Float Example: ceil(1.5) //2.0 cos(number) Returns the cosine of number. Throws TypeError if number is not an Int or Float Example: cos(0) //1.0 floor(number) Returns the floor of number. Throws TypeError if number is not an Int or Float Example: floor(1.5) //1.0 round(number) Returns the number rounded. Throws TypeError if number is not an Int or Float Example: round(1.5) //2.0 sin(number) Returns the sine of number. Throws TypeError if number is not an Int or Float Example: sin(0) //0.0 sqrt(number) Returns the square root of number. Throws TypeError if number is not an Int or Float Example: sqrt(1.0) //1.0 tan(number) Returns the tangent of number. Throws TypeError if number is not an Int or Float Example: tan(0.0) //0.0 log(number) Returns the natural logarithm of number. Throws TypeError if number is not an Int or Float Example: log(1.0) //0.0 log2(number) Returns the base 2 logarithm of number. Throws TypeError if number is not an Int or Float Example: log2(1.0) //0.0 exp(number) Returns e raised to the power of number. Throws TypeError if number is not an Int or Float Example: exp(0.0) //1.0 pow(base,exponent) Returns base raised to the power of exponent. TypeError if base or exponent is not an Int or Float Example: pow(2,2) //4.0 abs(number) Returns the absolute value of number Example: abs(-2) //2 Constants NaN Infinity E LN2 LOG2E SQRT1_2 LN10 LOG10E SQRT2","breadcrumbs":"Documentation » Module 'math' » Module 'math'","id":"47","title":"Module 'math'"},"48":{"body":"random() Returns a random Float in the range 0.0 to 1.0 Example: random() //0.71189203412849 range(start,end) Returns a random Int in the range start to end. Throws TypeError if start or end is not an Int Example: range(1,10) //6 shuffle(array) Shuffles array. Throws TypeError if array is not an Array Example: let arr = [1,2,3,4,5]\nshuffle(arr)\narr //[4,2,1,5,3]","breadcrumbs":"Documentation » Module 'random' » Module 'random'","id":"48","title":"Module 'random'"},"49":{"body":"now() Returns the number of seconds since the Unix epoch as a float sleep(ms) Suspends the current task for ms milliseconds","breadcrumbs":"Documentation » Module 'time' » Module 'time'","id":"49","title":"Module 'time'"},"5":{"body":"Int literals can be hex - 0x,octal - 0o They can have underscores between them Example: 0xdead_beef","breadcrumbs":"Syntax » Int literals","id":"5","title":"Int literals"},"50":{"body":"disassemble(fn) Returns a string containing the bytecode of fn. Throws TypeError if fn is not a Function or if fn is a native function gc() Runs garbage collection generateStackTrace(depth) Returns the stack trace at depth depth. Throws TypeError if depth is not an Int ecall(op,args) Calls EFunc op with argument args. Throws TypeError if op is not a symbol and Error if op is not an EFunc currentTask() Returns the current task suspendCurrentTask() Suspends the current task and adds it to the back of the queue.","breadcrumbs":"Documentation » Module 'vm' » Module 'vm'","id":"50","title":"Module 'vm'"},"51":{"body":"Neptune lang can be embedded in any rust application. The complete API can be browsed through docs.rs. Some key terms that must known are","breadcrumbs":"Embedding API » Embedding API","id":"51","title":"Embedding API"},"52":{"body":"Embedder Functions aka Efuncs are functions that are created by the embedder. They may be synchronous or asynchronous. The EFunc can push or pop values from the stack using the EFuncContext that is passed to it. EFuncs can be called using the ecall function in the vm module. EFuncs must return Result where both variants satisfy the ToNeptuneValue trait. The Err variant can be returned to throw an exception. ToNeptuneValue indicates a type that can be converted to a Neptune value. Asynchronous efuncs return a Future<Result<T1,T2>>. Examples for creating efuncs, implementing ToNeptuneValue can be seen in the documentation.","breadcrumbs":"Embedding API » Embedder Functions","id":"52","title":"Embedder Functions"},"53":{"body":"Resources are opaque handles to rust values. They can be freed using the close() method. They can be created and used only from efuncs using the resource() and as_resource() methods of EFuncContext.","breadcrumbs":"Embedding API » Resources","id":"53","title":"Resources"},"54":{"body":"","breadcrumbs":"Neptune Language Internals » Neptune Language Internals","id":"54","title":"Neptune Language Internals"},"55":{"body":"Like V8, the VM is a register-based VM that has a special accumulator register. The accumulator register is the implicit input/output register for many ops. This reduces the number of arguments needed. The VM also has many dedicated ops to speed up integer operations like AddInt,LoadSmallInt and ForLoop. The bytecode generated for a function can be viewed by the disassemble function in the vm module.","breadcrumbs":"Neptune Language Internals » VM Design","id":"55","title":"VM Design"},"56":{"body":"On x86_64 and aarch64 the following scheme is used to represent values. Empty 0x0000 0000 0000 0000 (nullptr)\nNull 0x0000 0000 0000 0001\nTrue 0x0000 0000 0000 0002\nFalse 0x0000 0000 0000 0003\nPointer 0x0000 XXXX XXXX XXXX [due to alignment we can use the last 2bits]\nInt 0x0001 0000 XXXX XXXX\nFloat 0x0002 0000 0000 0000 to 0xFFFA 0000 0000 0000 Doubles lie from 0x0000000000000000 to 0xFFF8000000000000. On adding 2<<48\nthey lie in the range listed above.","breadcrumbs":"Neptune Language Internals » Value representation","id":"56","title":"Value representation"},"57":{"body":"Many for loops are of the form for i in a..b { do something\n} If hasNext and next methods are called it would be very slow. So two specialized ops exist for for loops of this form. BeginForLoop: It checks whether both the start and end are integers and whether the start is lesser than the end.It is only called once. ForLoop: It just increments the integer loop variable and compares it so it is much faster than other for loops.","breadcrumbs":"Neptune Language Internals » ForLoop op","id":"57","title":"ForLoop op"},"58":{"body":"To reduce bytecode size Neptune lang uses the strategy that V8 does. An op can have arguments of any size. 8 bit arguments are used normally but prefix bytecodes are used for 16 bit(wide) and 32 bit(extrawide) arguments. The Wide and Extrawide ops precede instructions with these arguments. These ops read the op next to it and dispatch to the wide and extrawide variants of the ops. The wide and extrawide handlers are assigned entries in the bytecode dispatch table that have a fixed offset from the normal variants. Macros are used to generate the wide and extrawide bytecode handlers. This scheme has the problem that the number of bytes to reserve for jump offsets is not known. To resolve this problem JumpConstant, JumpIfFalseOrNullConstant and similar ops exist. The jump offset is contained in the constants table. If later it is found that enough space exists to store the jump offset directly in the bytecode then they are converted to the non-constant variants like Jump and JumpIfFalseOrNull and the bytecode is patched. If enough space is not available then the constant table must be patched. | AddInt | | 5 |\n| Wide | | AddInt | | 300 |\n| Extrawide | | AddInt | | 10_000 |","breadcrumbs":"Neptune Language Internals » Wide and Extrawide arguments","id":"58","title":"Wide and Extrawide arguments"},"6":{"body":"They can contain underscores Exponential notation is also allowed Example: 1.2e9","breadcrumbs":"Syntax » Float literals","id":"6","title":"Float literals"},"7":{"body":"They can start and end with ' or \" They can be multi-line \\t,\\n,\\r,\\0 escape sequences can be used Unicode escape sequences begin with \\u let sparklingHeart = \"\\u{1F496}\" // 💖, Unicode scalar U+1F496 They also allow interpolation using \\ followed by an expression in parentheses let greeting = 'Hello \\(name)!'","breadcrumbs":"Syntax » String Literals","id":"7","title":"String Literals"},"8":{"body":"All values have a type and the type is associated with a class. The primitive types are listed below. These classes have many useful methods that can be seen in the documentation section of the book.","breadcrumbs":"Types » Types","id":"8","title":"Types"},"9":{"body":"All classes inherit Object.Objects can be directly created using object literals let point = {x:1, y:2} The point has two properties x and y.","breadcrumbs":"Types » Object","id":"9","title":"Object"}},"length":59,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{",":{"0":{",":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{".":{"1":{"0":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"47":{"tf":2.8284271247461903},"48":{"tf":1.0}}},"7":{"1":{"1":{"8":{"9":{"2":{"0":{"3":{"4":{"1":{"2":{"8":{"4":{"9":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"56":{"tf":4.0}}},"1":{"df":1,"docs":{"56":{"tf":1.0}}},"2":{"df":1,"docs":{"56":{"tf":1.0}}},"3":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"24":{"tf":1.0},"42":{"tf":1.4142135623730951}},"o":{"df":1,"docs":{"5":{"tf":1.0}}},"x":{",":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":2.23606797749979}}},"1":{"df":1,"docs":{"56":{"tf":1.0}}},"2":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"8":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}}},"1":{"+":{"1":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},",":{"'":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"'":{",":{"2":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"2":{",":{"3":{",":{"4":{",":{"5":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"]":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"%":{"2":{"=":{"=":{"1":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"<":{"1":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"=":{"=":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"a":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{",":{"df":0,"docs":{},"y":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"+":{"df":0,"docs":{},"y":{",":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"+":{"1":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"37":{"tf":2.449489742783178},"39":{"tf":1.0}}},"3":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},".":{".":{"2":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"0":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}},"df":0,"docs":{}},".":{"0":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"22":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.0}}},"2":{"df":0,"docs":{},"e":{"9":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":1,"docs":{"58":{"tf":1.0}}},"df":10,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0}}},"2":{",":{"3":{",":{"4":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"0":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"<":{"<":{"4":{"8":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":11,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772}}},"3":{",":{"1":{",":{"2":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"1":{"4":{"1":{"5":{"9":{"2":{"6":{"5":{"3":{"5":{"8":{"9":{"8":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":2,"docs":{"10":{"tf":1.0},"58":{"tf":1.0}}},"df":3,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"43":{"tf":1.0}}},"4":{",":{"1":{",":{"3":{",":{"2":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{",":{"1":{",":{"5":{",":{"3":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"]":{"[":{"1":{".":{".":{"3":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}},"5":{"df":2,"docs":{"27":{"tf":1.0},"58":{"tf":1.0}}},"6":{"df":2,"docs":{"43":{"tf":1.0},"48":{"tf":1.0}}},"7":{".":{".":{"1":{"0":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"4":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":2,"docs":{"13":{"tf":1.0},"58":{"tf":1.0}}},"_":{"df":2,"docs":{"2":{"tf":1.0},"32":{"tf":1.0}}},"a":{"'":{",":{"'":{"b":{"'":{",":{"'":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"+":{"b":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}},",":{"b":{"df":0,"docs":{},"|":{"a":{"+":{"b":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},".":{".":{"b":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"c":{"'":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"(":{"'":{"b":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"(":{"'":{"b":{"c":{"'":{",":{"'":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.0}}},"df":1,"docs":{"47":{"tf":1.0}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"56":{"tf":1.0}}}},"s":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"(":{"1":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"d":{"(":{"a":{",":{"b":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.4142135623730951},"50":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}}},"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{":":{"2":{"9":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"a":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}},"l":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"y":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"51":{"tf":1.0}}},"df":1,"docs":{"43":{"tf":1.0}}}}}},"r":{"c":{"df":1,"docs":{"47":{"tf":1.7320508075688772}}},"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"43":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":2.23606797749979}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}}}}}}}},"r":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"0":{",":{"3":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"3":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{",":{"df":0,"docs":{},"y":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"[":{"1":{",":{"2":{",":{"3":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"y":{"(":{"3":{",":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"14":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":2.449489742783178},"43":{"tf":1.0},"48":{"tf":1.7320508075688772}}}},"df":2,"docs":{"37":{"tf":3.3166247903554},"48":{"tf":1.4142135623730951}}}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"58":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"n":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"b":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"32":{"tf":1.0},"47":{"tf":1.7320508075688772},"55":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"0":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"2":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"30":{"tf":1.0},"33":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"10":{"tf":1.0},"58":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"20":{"tf":2.0},"31":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"33":{"tf":1.0},"8":{"tf":1.0}}},"l":{"df":2,"docs":{"12":{"tf":1.0},"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"52":{"tf":1.0},"57":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"50":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"df":1,"docs":{"58":{"tf":1.0}}}}}},"c":{"(":{"7":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"25":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"12":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"(":{"1":{".":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"47":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"33":{"tf":2.0},"34":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":10,"docs":{"25":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":3.1622776601683795},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":2.0},"43":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"50":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":2.23606797749979}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.0},"37":{"tf":1.4142135623730951},"57":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"33":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"27":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.7320508075688772}}}}},"df":2,"docs":{"21":{"tf":1.7320508075688772},"25":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{",":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":7,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.4142135623730951},"50":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"+":{"=":{"1":{";":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.4142135623730951},"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"25":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"24":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"i":{"df":1,"docs":{"33":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"13":{"tf":1.0},"58":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"25":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}},"l":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{",":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"31":{"tf":1.0},"47":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"53":{"tf":1.0}}}}}}}}},"df":3,"docs":{"50":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"53":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"37":{"tf":1.7320508075688772},"43":{"tf":1.0}}}}}}}},"m":{"b":{"df":0,"docs":{},"e":{"d":{"d":{"df":2,"docs":{"25":{"tf":1.0},"52":{"tf":1.7320508075688772}}},"df":1,"docs":{"51":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"56":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"d":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":6,"docs":{"17":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":2.23606797749979},"48":{"tf":1.4142135623730951},"57":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"19":{"tf":1.0},"22":{"tf":2.8284271247461903},"37":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"(":{"'":{"a":{"b":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"11":{"tf":1.0},"31":{"tf":2.449489742783178},"33":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"(":{"'":{"1":{"+":{"1":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":2,"docs":{"25":{"tf":1.0},"46":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":18,"docs":{"25":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":3.0},"38":{"tf":2.0},"39":{"tf":2.449489742783178},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":2.8284271247461903},"46":{"tf":1.4142135623730951},"47":{"tf":4.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"31":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"52":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}}}},"p":{"(":{"0":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":2.23606797749979},"31":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"25":{"tf":1.0},"46":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"43":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"58":{"tf":2.449489742783178}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"s":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"15":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":1,"docs":{"25":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}},"l":{"df":1,"docs":{"37":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"38":{"tf":1.0}}}}},"x":{"df":1,"docs":{"58":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"34":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"47":{"tf":3.872983346207417},"48":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"1":{".":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"41":{"tf":1.0},"47":{"tf":1.0}}}},"w":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}},"n":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":2.0}}}}}}},"df":3,"docs":{"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"43":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"55":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}}},"m":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"23":{"tf":1.0},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":2.0},"55":{"tf":1.4142135623730951}},"s":{"/":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"1":{",":{"df":0,"docs":{},"t":{"2":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"25":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"t":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}},"o":{"df":1,"docs":{"30":{"tf":1.0}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"13":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}}},"x":{"df":1,"docs":{"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"f":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{".":{"/":{"a":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"'":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{")":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"25":{"tf":2.23606797749979},"31":{"tf":1.0}}}}}}},"n":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.7320508075688772}}}}}}}}},"i":{"c":{"df":3,"docs":{"31":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"9":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":14,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"47":{"tf":3.872983346207417},"48":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":4,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951}}},"r":{"df":1,"docs":{"43":{"tf":1.0}},"n":{"df":2,"docs":{"16":{"tf":1.0},"54":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":3.3166247903554}}},"r":{"df":11,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":3.7416573867739413}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"33":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":1,"docs":{"58":{"tf":2.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"39":{"tf":2.6457513110645907},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":2,"docs":{"30":{"tf":1.0},"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"33":{"tf":2.23606797749979},"44":{"tf":2.6457513110645907},"46":{"tf":1.7320508075688772}},"e":{"d":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"51":{"tf":1.0},"58":{"tf":1.0}}}}}}},"l":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"27":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"27":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"56":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"n":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":2.6457513110645907}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"1":{"tf":2.0},"7":{"tf":1.0}}},"k":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"2":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"33":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"56":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"30":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}}}},"n":{"1":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"(":{"1":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"1":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"2":{"(":{"1":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"47":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":4,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"43":{"tf":1.0},"57":{"tf":2.0}}}}}},"m":{"[":{"\"":{"a":{"b":{"c":{"\"":{"]":{"=":{"1":{".":{"5":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":4,"docs":{"25":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"8":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":4,"docs":{"15":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":4.242640687119285}},"{":{"1":{":":{"2":{",":{"2":{":":{"3":{"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"3":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"@":{"a":{":":{"1":{",":{"2":{":":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":2,"docs":{"34":{"tf":1.0},"47":{"tf":1.0}}}}},"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"1":{"df":1,"docs":{"32":{"tf":1.0}}},"df":10,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":2.0},"43":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":11,"docs":{"20":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":3.3166247903554},"34":{"tf":2.0},"46":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"33":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"43":{"tf":1.0}}}}},"s":{"df":1,"docs":{"49":{"tf":1.0}},"g":{"df":1,"docs":{"45":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"16":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"7":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"25":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{"'":{"a":{"b":{"c":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"16":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.4142135623730951},"44":{"tf":2.0},"7":{"tf":1.0}}}},"n":{"df":4,"docs":{"11":{"tf":1.0},"22":{"tf":1.4142135623730951},"41":{"tf":1.0},"47":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"50":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"37":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"27":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"w":{"df":13,"docs":{"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":3,"docs":{"43":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{")":{",":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"18":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0}}}},"w":{"df":1,"docs":{"49":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":5.385164807134504},"49":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"16":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":2.449489742783178},"36":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":2.0}}}}}}},"n":{"c":{"df":2,"docs":{"33":{"tf":1.0},"57":{"tf":1.0}}},"df":3,"docs":{"25":{"tf":1.0},"33":{"tf":1.7320508075688772},"46":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":4,"docs":{"50":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"41":{"tf":1.0}}}}}}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"f":{",":{"@":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"+":{"=":{"1":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"@":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"[":{"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"]":{"=":{"@":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"32":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"21":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"p":{"df":3,"docs":{"14":{"tf":1.0},"37":{"tf":1.0},"52":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":2.449489742783178},"38":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"(":{"2":{",":{"2":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{",":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"58":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"25":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"39":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"(":{"'":{"1":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"a":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"28":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"46":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"16":{"tf":1.0},"32":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"14":{"tf":1.0},"52":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"50":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.0},"47":{"tf":1.4142135623730951}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"25":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.7320508075688772},"34":{"tf":1.0},"40":{"tf":2.0},"48":{"tf":1.4142135623730951},"56":{"tf":1.0}},"e":{"(":{"1":{",":{"1":{"0":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"df":2,"docs":{"33":{"tf":1.0},"45":{"tf":1.0}}}},"d":{"df":1,"docs":{"16":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"c":{"df":2,"docs":{"55":{"tf":1.0},"58":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":2.0}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"37":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"32":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"58":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"25":{"tf":1.0},"58":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"53":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"52":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":19,"docs":{"13":{"tf":1.0},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":2.0},"38":{"tf":2.23606797749979},"39":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":2.6457513110645907},"44":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":4.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"d":{"(":{"1":{".":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"44":{"tf":1.0},"50":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{",":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"53":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"22":{"tf":1.0},"32":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":2.449489742783178}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"12":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"52":{"tf":1.0},"8":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"d":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":3,"docs":{"33":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"32":{"tf":1.0},"44":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"h":{"a":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}},"e":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"57":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"37":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"46":{"tf":2.23606797749979}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{",":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"33":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"55":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"1":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"1":{"_":{"2":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{".":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":7,"docs":{"17":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":2.23606797749979},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":2.0}}}}}}},"u":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"16":{"tf":1.0},"58":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":1,"docs":{"38":{"tf":1.4142135623730951}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":9,"docs":{"13":{"tf":2.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"7":{"tf":1.0}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"32":{"tf":1.0},"36":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"30":{"tf":2.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.7320508075688772},"50":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{",":{"\\":{"df":0,"docs":{},"n":{",":{"\\":{"df":0,"docs":{},"r":{",":{"\\":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"n":{"(":{"0":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}},"2":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}},"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":6,"docs":{"33":{"tf":4.123105625617661},"34":{"tf":1.0},"44":{"tf":3.0},"46":{"tf":3.3166247903554},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"[":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"]":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"f":{",":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"f":{",":{"@":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"x":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"28":{"tf":1.0},"51":{"tf":1.0}}}}},"w":{"df":11,"docs":{"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"37":{"tf":2.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":3.7416573867739413},"48":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"52":{"tf":1.0}},"n":{"df":3,"docs":{"10":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"49":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}}}},"p":{"df":1,"docs":{"20":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"35":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"31":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"43":{"tf":1.7320508075688772}}}}}}},"w":{"df":0,"docs":{},"o":{"df":9,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"43":{"tf":1.4142135623730951},"57":{"tf":1.0},"9":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":6,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"31":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":3.872983346207417},"48":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772}}}}}}}}}}},"u":{"+":{"1":{"df":0,"docs":{},"f":{"4":{"9":{"6":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.0}},"n":{"c":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}},"x":{"df":1,"docs":{"49":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":2,"docs":{"11":{"tf":1.0},"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.0}}},"s":{"df":25,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":2.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":2.0},"31":{"tf":1.7320508075688772},"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"4":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"58":{"tf":2.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}},"{":{"1":{"df":0,"docs":{},"f":{"4":{"9":{"6":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"8":{"df":2,"docs":{"55":{"tf":1.0},"58":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":12,"docs":{"12":{"tf":1.7320508075688772},"14":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":2.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"46":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.0}}}}},"m":{"df":4,"docs":{"34":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":2.23606797749979}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"46":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":2.449489742783178}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"x":{"!":{"=":{"=":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},",":{"c":{",":{"df":0,"docs":{},"f":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}},"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"1":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"=":{"0":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"17":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.4142135623730951},"9":{"tf":1.0}},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":2.23606797749979}}}}}},"y":{":":{"2":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}}}},"breadcrumbs":{"root":{"0":{",":{"0":{",":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{".":{"1":{"0":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"47":{"tf":2.8284271247461903},"48":{"tf":1.0}}},"7":{"1":{"1":{"8":{"9":{"2":{"0":{"3":{"4":{"1":{"2":{"8":{"4":{"9":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"df":1,"docs":{"56":{"tf":4.0}}},"1":{"df":1,"docs":{"56":{"tf":1.0}}},"2":{"df":1,"docs":{"56":{"tf":1.0}}},"3":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"24":{"tf":1.0},"42":{"tf":1.4142135623730951}},"o":{"df":1,"docs":{"5":{"tf":1.0}}},"x":{",":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":2.23606797749979}}},"1":{"df":1,"docs":{"56":{"tf":1.0}}},"2":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"8":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}}},"1":{"+":{"1":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},",":{"'":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"'":{",":{"2":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"2":{",":{"3":{",":{"4":{",":{"5":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"]":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"%":{"2":{"=":{"=":{"1":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"<":{"1":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"=":{"=":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"a":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{",":{"df":0,"docs":{},"y":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"+":{"df":0,"docs":{},"y":{",":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"+":{"1":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"37":{"tf":2.449489742783178},"39":{"tf":1.0}}},"3":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},".":{".":{"2":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"0":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}},"df":0,"docs":{}},".":{"0":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"22":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":2.0},"48":{"tf":1.0}}},"2":{"df":0,"docs":{},"e":{"9":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"0":{"_":{"0":{"0":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":1,"docs":{"58":{"tf":1.0}}},"df":10,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0}}},"2":{",":{"3":{",":{"4":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"0":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"<":{"<":{"4":{"8":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":11,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772}}},"3":{",":{"1":{",":{"2":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"1":{"4":{"1":{"5":{"9":{"2":{"6":{"5":{"3":{"5":{"8":{"9":{"8":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":2,"docs":{"10":{"tf":1.0},"58":{"tf":1.0}}},"df":3,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"43":{"tf":1.0}}},"4":{",":{"1":{",":{"3":{",":{"2":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{",":{"1":{",":{"5":{",":{"3":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"]":{"[":{"1":{".":{".":{"3":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}},"5":{"df":2,"docs":{"27":{"tf":1.0},"58":{"tf":1.0}}},"6":{"df":2,"docs":{"43":{"tf":1.0},"48":{"tf":1.0}}},"7":{".":{".":{"1":{"0":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"4":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":2,"docs":{"13":{"tf":1.0},"58":{"tf":1.0}}},"_":{"df":2,"docs":{"2":{"tf":1.0},"32":{"tf":1.0}}},"a":{"'":{",":{"'":{"b":{"'":{",":{"'":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"+":{"b":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}},",":{"b":{"df":0,"docs":{},"|":{"a":{"+":{"b":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},".":{".":{"b":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"c":{"'":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"(":{"'":{"b":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"(":{"'":{"b":{"c":{"'":{",":{"'":{"df":0,"docs":{},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.0}}},"df":1,"docs":{"47":{"tf":1.0}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"56":{"tf":1.0}}}},"s":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.4142135623730951},"32":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"(":{"1":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"d":{"(":{"a":{",":{"b":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.4142135623730951},"50":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}}},"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{":":{"2":{"9":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"a":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}},"l":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"y":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"51":{"tf":1.0}}},"df":1,"docs":{"43":{"tf":1.0}}}}}},"r":{"c":{"df":1,"docs":{"47":{"tf":1.7320508075688772}}},"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"43":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":2.449489742783178}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}}}}}}}},"r":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"0":{",":{"3":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"3":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{",":{"df":0,"docs":{},"y":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"[":{"1":{",":{"2":{",":{"3":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"y":{"(":{"3":{",":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"14":{"tf":1.7320508075688772},"34":{"tf":1.0},"37":{"tf":2.8284271247461903},"43":{"tf":1.0},"48":{"tf":1.7320508075688772}}}},"df":2,"docs":{"37":{"tf":3.3166247903554},"48":{"tf":1.4142135623730951}}}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"58":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"n":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"b":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"32":{"tf":1.0},"47":{"tf":1.7320508075688772},"55":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"2":{"tf":1.0},"32":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"30":{"tf":1.0},"33":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"10":{"tf":1.0},"58":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"20":{"tf":2.0},"31":{"tf":1.0},"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"33":{"tf":1.0},"8":{"tf":1.0}}},"l":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"52":{"tf":1.0},"57":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"50":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"df":1,"docs":{"58":{"tf":1.0}}}}}},"c":{"(":{"7":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"25":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"12":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"(":{"1":{".":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"47":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"33":{"tf":2.449489742783178},"34":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":2.23606797749979}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":10,"docs":{"25":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":3.4641016151377544},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":2.449489742783178},"43":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"50":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":2.449489742783178}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.0},"37":{"tf":1.4142135623730951},"57":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"33":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"27":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.7320508075688772}}}}},"df":2,"docs":{"21":{"tf":1.7320508075688772},"25":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{",":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":7,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.4142135623730951},"50":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":6,"docs":{"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"+":{"=":{"1":{";":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.4142135623730951},"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"25":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":2.449489742783178},"24":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"31":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"i":{"df":1,"docs":{"33":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"13":{"tf":1.0},"58":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":22,"docs":{"25":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}},"l":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{",":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"31":{"tf":1.0},"47":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"53":{"tf":1.0}}}}}}}}},"df":3,"docs":{"50":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"53":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"37":{"tf":1.7320508075688772},"43":{"tf":1.0}}}}}}}},"m":{"b":{"df":0,"docs":{},"e":{"d":{"d":{"df":2,"docs":{"25":{"tf":1.0},"52":{"tf":2.0}}},"df":3,"docs":{"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"56":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"d":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":6,"docs":{"17":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":2.23606797749979},"48":{"tf":1.4142135623730951},"57":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":3.3166247903554},"37":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"(":{"'":{"a":{"b":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"11":{"tf":1.0},"31":{"tf":2.449489742783178},"33":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"(":{"'":{"1":{"+":{"1":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":2,"docs":{"25":{"tf":1.0},"46":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":18,"docs":{"25":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":3.0},"38":{"tf":2.0},"39":{"tf":2.449489742783178},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":2.8284271247461903},"46":{"tf":1.4142135623730951},"47":{"tf":4.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"52":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.4142135623730951}}}},"t":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951}}}},"p":{"(":{"0":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":2.23606797749979},"31":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"25":{"tf":1.0},"46":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"43":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"58":{"tf":2.6457513110645907}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"s":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"15":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":1,"docs":{"25":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}},"l":{"df":1,"docs":{"37":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"38":{"tf":1.0}}}}},"x":{"df":1,"docs":{"58":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.7320508075688772},"34":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0},"47":{"tf":3.872983346207417},"48":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"1":{".":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"41":{"tf":1.0},"47":{"tf":1.0}}}},"w":{"df":6,"docs":{"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0}}}}},"n":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":2.0}}}}}}},"df":3,"docs":{"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"43":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"55":{"tf":1.0},"57":{"tf":1.7320508075688772}}}}}},"m":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":2.6457513110645907},"25":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951}},"s":{"/":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"1":{",":{"df":0,"docs":{},"t":{"2":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"25":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"t":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}},"o":{"df":1,"docs":{"30":{"tf":1.0}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"13":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}}},"x":{"df":1,"docs":{"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"f":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{".":{"/":{"a":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"'":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{")":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"25":{"tf":2.23606797749979},"31":{"tf":1.0}}}}}}},"n":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.7320508075688772}}}}}}}}},"i":{"c":{"df":3,"docs":{"31":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"9":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":14,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":2.0},"47":{"tf":3.872983346207417},"48":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":4,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951}}},"r":{"df":1,"docs":{"43":{"tf":1.0}},"n":{"df":6,"docs":{"16":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":3.3166247903554}}},"r":{"df":11,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":4.0}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"33":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":1,"docs":{"58":{"tf":2.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"39":{"tf":2.6457513110645907},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}},"df":2,"docs":{"30":{"tf":1.0},"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"33":{"tf":2.23606797749979},"44":{"tf":2.6457513110645907},"46":{"tf":1.7320508075688772}},"e":{"d":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"51":{"tf":1.0},"58":{"tf":1.0}}}}}}},"l":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"27":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"27":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"56":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"n":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":2.6457513110645907}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"1":{"tf":2.0},"7":{"tf":1.0}}},"k":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"2":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"33":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"56":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"30":{"tf":1.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"n":{"1":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"(":{"1":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"1":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"2":{"(":{"1":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"47":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":4,"docs":{"28":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"43":{"tf":1.0},"57":{"tf":2.0}}}}}},"m":{"[":{"\"":{"a":{"b":{"c":{"\"":{"]":{"=":{"1":{".":{"5":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":4,"docs":{"25":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"8":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"2":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":4,"docs":{"15":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":4.47213595499958}},"{":{"1":{":":{"2":{",":{"2":{":":{"3":{"df":1,"docs":{"39":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"3":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"@":{"a":{":":{"1":{",":{"2":{":":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":2,"docs":{"34":{"tf":1.0},"47":{"tf":1.7320508075688772}}}}},"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"1":{"df":1,"docs":{"32":{"tf":1.0}}},"df":10,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":2.0},"43":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"57":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":12,"docs":{"20":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":3.605551275463989},"34":{"tf":2.0},"46":{"tf":2.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":1.7320508075688772},"52":{"tf":1.0},"55":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"33":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"43":{"tf":1.0}}}}},"s":{"df":1,"docs":{"49":{"tf":1.0}},"g":{"df":1,"docs":{"45":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"16":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"7":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"25":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{"'":{"a":{"b":{"c":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"16":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.4142135623730951},"44":{"tf":2.0},"7":{"tf":1.0}}}},"n":{"df":4,"docs":{"11":{"tf":1.0},"22":{"tf":1.4142135623730951},"41":{"tf":1.0},"47":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"50":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"37":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":8,"docs":{"27":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"w":{"df":13,"docs":{"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":3,"docs":{"43":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{")":{",":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"18":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0}}}},"w":{"df":1,"docs":{"49":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"12":{"tf":1.0},"18":{"tf":1.4142135623730951},"36":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":5.385164807134504},"49":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":7,"docs":{"16":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"34":{"tf":1.0},"35":{"tf":2.8284271247461903},"36":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":2.0}}}}}}},"n":{"c":{"df":2,"docs":{"33":{"tf":1.0},"57":{"tf":1.0}}},"df":3,"docs":{"25":{"tf":1.0},"33":{"tf":1.7320508075688772},"46":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":4,"docs":{"50":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"58":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"41":{"tf":1.0}}}}}}}}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"f":{",":{"@":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"+":{"=":{"1":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"=":{"@":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"[":{"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"]":{"=":{"@":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"32":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"21":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"p":{"df":3,"docs":{"14":{"tf":1.0},"37":{"tf":1.0},"52":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":2.449489742783178},"38":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"(":{"2":{",":{"2":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{",":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"58":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"25":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"39":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"(":{"'":{"1":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"a":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"28":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"46":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"16":{"tf":1.0},"32":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"14":{"tf":1.0},"52":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"50":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.0},"47":{"tf":1.4142135623730951}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"25":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":2.0},"34":{"tf":1.0},"40":{"tf":2.449489742783178},"48":{"tf":1.4142135623730951},"56":{"tf":1.0}},"e":{"(":{"1":{",":{"1":{"0":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"df":2,"docs":{"33":{"tf":1.0},"45":{"tf":1.0}}}},"d":{"df":1,"docs":{"16":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"c":{"df":2,"docs":{"55":{"tf":1.0},"58":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":2.0}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"37":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{",":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"32":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"58":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"25":{"tf":1.0},"58":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"53":{"tf":2.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"52":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":19,"docs":{"13":{"tf":1.0},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":2.0},"38":{"tf":2.23606797749979},"39":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":2.6457513110645907},"44":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772},"47":{"tf":4.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"d":{"(":{"1":{".":{"5":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"44":{"tf":1.0},"50":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{",":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"51":{"tf":1.0},"53":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"22":{"tf":1.0},"32":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"12":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"52":{"tf":1.0},"8":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"d":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":3,"docs":{"33":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"32":{"tf":1.0},"44":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"h":{"a":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}},"e":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"(":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"57":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"37":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"46":{"tf":2.23606797749979}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{",":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"33":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"55":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"1":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"1":{"_":{"2":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"31":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{".":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":7,"docs":{"17":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":2.23606797749979},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":2.0}}}}}}},"u":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"16":{"tf":1.0},"58":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":1,"docs":{"38":{"tf":1.4142135623730951}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":9,"docs":{"13":{"tf":2.23606797749979},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":2.6457513110645907},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"32":{"tf":1.0},"36":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"30":{"tf":2.23606797749979},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":2.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":8,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{",":{"\\":{"df":0,"docs":{},"n":{",":{"\\":{"df":0,"docs":{},"r":{",":{"\\":{"0":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"n":{"(":{"0":{".":{"0":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}},"2":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}},"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":6,"docs":{"33":{"tf":4.358898943540674},"34":{"tf":1.0},"44":{"tf":3.3166247903554},"46":{"tf":3.3166247903554},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"[":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"]":{"=":{"df":0,"docs":{},"{":{"df":0,"docs":{},"f":{",":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"f":{",":{"@":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"x":{"=":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"28":{"tf":1.0},"51":{"tf":1.0}}}}},"w":{"df":11,"docs":{"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"37":{"tf":2.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":3.7416573867739413},"48":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"52":{"tf":1.0}},"n":{"df":3,"docs":{"10":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"49":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}}}},"p":{"df":1,"docs":{"20":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"35":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"31":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"43":{"tf":1.7320508075688772}}}}}}},"w":{"df":0,"docs":{},"o":{"df":9,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"43":{"tf":1.4142135623730951},"57":{"tf":1.0},"9":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":14,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":2.449489742783178},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"31":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":3.872983346207417},"48":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772}}}}}}}}}}},"u":{"+":{"1":{"df":0,"docs":{},"f":{"4":{"9":{"6":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"7":{"tf":1.0}},"n":{"c":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}},"x":{"df":1,"docs":{"49":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":2,"docs":{"11":{"tf":1.0},"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.0}}},"s":{"df":25,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":2.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":2.0},"31":{"tf":1.7320508075688772},"32":{"tf":2.0},"33":{"tf":1.7320508075688772},"4":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"58":{"tf":2.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}},"{":{"1":{"df":0,"docs":{},"f":{"4":{"9":{"6":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"8":{"df":2,"docs":{"55":{"tf":1.0},"58":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":12,"docs":{"12":{"tf":1.7320508075688772},"14":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":2.0},"21":{"tf":2.449489742783178},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"46":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"33":{"tf":1.0},"55":{"tf":1.0}}}}},"m":{"df":4,"docs":{"34":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.0},"55":{"tf":2.449489742783178}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"46":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"10":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"39":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"x":{"!":{"=":{"=":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},",":{"c":{",":{"df":0,"docs":{},"f":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}},"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"1":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"=":{"0":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"17":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.4142135623730951},"9":{"tf":1.0}},"x":{"df":0,"docs":{},"x":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":2.23606797749979}}}}}},"y":{":":{"2":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}}}},"title":{"root":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"14":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"0":{"tf":1.0},"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"45":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"32":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"d":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"22":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"41":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"52":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"15":{"tf":1.0},"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"23":{"tf":1.0},"25":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"57":{"tf":1.0}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"17":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"13":{"tf":1.0},"38":{"tf":1.0},"7":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"33":{"tf":1.0},"44":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":2,"docs":{"50":{"tf":1.0},"55":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});