use neli::consts::genl::Cmd;
use neli_proc_macros::neli_enum;

/// nl80211Commands
///
/// https://github.com/mdlayher/wifi/blob/b1436901ddee2ea3ee8782a440a084e457615766/internal/nl80211/const.go
///
/// Enumeration from nl80211/nl80211.h:880
#[neli_enum(serialized_type = "u8")]
pub enum Nl80211Cmd {
    CmdUnspec = 0,
    CmdGetWiphy = 1,
    CmdSetWiphy = 2,
    CmdNewWiphy = 3,
    CmdDelWiphy = 4,
    CmdGetInterface = 5,
    CmdSetInterface = 6,
    CmdNewInterface = 7,
    CmdDelInterface = 8,
    CmdGetKey = 9,
    CmdSetKey = 10,
    CmdNewKey = 11,
    CmdDelKey = 12,
    CmdGetBeacon = 13,
    CmdSetBeacon = 14,
    CmdStartAp = 15,
    CmdNewBeacon = 15, //CmdStartAp,
    CmdStopAp = 16,
    CmdDelBeacon = 16, //CmdStopAp,
    CmdGetStation = 17,
    CmdSetStation = 18,
    CmdNewStation = 19,
    CmdDelStation = 20,
    CmdGetMpath = 21,
    CmdSetMpath = 22,
    CmdNewMpath = 23,
    CmdDelMpath = 24,
    CmdSetBss = 25,
    CmdSetReg = 26,
    CmdReqSetReg = 27,
    CmdGetMeshConfig = 28,
    CmdSetMeshConfig = 29,
    CmdSetMgmtExtraIe = 30,
    CmdGetReg = 31,
    CmdGetScan = 32,
    CmdTriggerScan = 33,
    CmdNewScanResults = 34,
    CmdScanAborted = 35,
    CmdRegChange = 36,
    CmdAuthenticate = 37,
    CmdAssociate = 38,
    CmdDeauthenticate = 39,
    CmdDisassociate = 40,
    CmdMichaelMicFailure = 41,
    CmdRegBeaconHint = 42,
    CmdJoinIbss = 43,
    CmdLeaveIbss = 44,
    CmdTestmode = 45,
    CmdConnect = 46,
    CmdRoam = 47,
    CmdDisconnect = 48,
    CmdSetWiphyNetns = 49,
    CmdGetSurvey = 50,
    CmdNewSurveyResults = 51,
    CmdSetPmksa = 52,
    CmdDelPmksa = 53,
    CmdFlushPmksa = 54,
    CmdRemainOnChannel = 55,
    CmdCancelRemainOnChannel = 56,
    CmdSetTxBitrateMask = 57,
    CmdRegisterFrame = 58,
    CmdRegisterAction = 58, //CmdRegisterFrame,
    CmdFrame = 59,
    CmdAction = 59, //CmdFrame,
    CmdFrameTxStatus = 60,
    CmdActionTxStatus = 60, //CmdFrameTxStatus,
    CmdSetPowerSave = 61,
    CmdGetPowerSave = 62,
    CmdSetCqm = 63,
    CmdNotifyCqm = 64,
    CmdSetChannel = 65,
    CmdSetWdsPeer = 66,
    CmdFrameWaitCancel = 67,
    CmdJoinMesh = 68,
    CmdLeaveMesh = 69,
    CmdUnprotDeauthenticate = 70,
    CmdUnprotDisassociate = 71,
    CmdNewPeerCandidate = 72,
    CmdGetWowlan = 73,
    CmdSetWowlan = 74,
    CmdStartSchedScan = 75,
    CmdStopSchedScan = 76,
    CmdSchedScanResults = 77,
    CmdSchedScanStopped = 78,
    CmdSetRekeyOffload = 79,
    CmdPmksaCandidate = 80,
    CmdTdlsOper = 81,
    CmdTdlsMgmt = 82,
    CmdUnexpectedFrame = 83,
    CmdProbeClient = 84,
    CmdRegisterBeacons = 85,
    CmdUnexpected4addrFrame = 86,
    CmdSetNoackMap = 87,
    CmdChSwitchNotify = 88,
    CmdStartP2pDevice = 89,
    CmdStopP2pDevice = 90,
    CmdConnFailed = 91,
    CmdSetMcastRate = 92,
    CmdSetMacAcl = 93,
    CmdRadarDetect = 94,
    CmdGetProtocolFeatures = 95,
    CmdUpdateFtIes = 96,
    CmdFtEvent = 97,
    CmdCritProtocolStart = 98,
    CmdCritProtocolStop = 99,
    CmdGetCoalesce = 100,
    CmdSetCoalesce = 101,
    CmdChannelSwitch = 102,
    CmdVendor = 103,
    CmdSetQosMap = 104,
    CmdAddTxTs = 105,
    CmdDelTxTs = 106,
    CmdGetMpp = 107,
    CmdJoinOcb = 108,
    CmdLeaveOcb = 109,
    CmdChSwitchStartedNotify = 110,
    CmdTdlsChannelSwitch = 111,
    CmdTdlsCancelChannelSwitch = 112,
    CmdWiphyRegChange = 113,
    CmdAbortScan = 114,
    CmdStartNan = 115,
    CmdStopNan = 116,
    CmdAddNanFunction = 117,
    CmdDelNanFunction = 118,
    CmdChangeNanConfig = 119,
    CmdNanMatch = 120,
    CmdAfterLast = 121,
    CmdMax = 120,
}

impl Cmd for Nl80211Cmd {}
