use std::fmt::Display;
use std::process::Command;
use std::{io, fs};
use std::io::Write;
use std::path::PathBuf;

pub fn wasm_files()->Vec<String>{
    let dir = std::env::current_dir().unwrap().join("../target/wasm32-unknown-unknown/release");
    let files = fs::read_dir(dir)
        .unwrap()
        .map(|x|x.unwrap().path().display().to_string())
        .filter(|x|x.contains(".wasm"))
        .collect::<Vec<_>>();
    files
}

pub fn near_credentials_dir_testnet()->String{
    let near_cred_dir = std::path::PathBuf::from(std::env::var("HOME")
        .unwrap_or("C:\\Users\\lilse".to_string()))
        .join(".near-credentials")
        .join("testnet");
    near_cred_dir.display().to_string()
}



pub fn near_command(near_cmd:impl AsRef<str>+Display, near_arg:impl AsRef<str>+Display){
    println!("running near {} {}", near_cmd, near_arg);
    let output = if cfg!(target_os = "windows") {
        Command::new("cmd")
            .args(&["/C",format!("near {} {}", near_cmd, near_arg).as_str()])
            .output()
            .expect("ls command failed to start")
    } else {
        Command::new("sh")
            .arg("-c")
            .arg(format!("near {} {}", near_cmd, near_arg))
            .output()
            .expect("ls command failed to start")
    };
    io::stdout().write_all(&output.stdout).unwrap();
    io::stderr().write_all(&output.stderr).unwrap();
}

