//! All builtin network types and traits.
//!
//! Currently the builtin network types are [`Mainnet`], [`Testnet`], and [`Sandbox`].

mod info;
mod mainnet;
mod sandbox;
mod server;
mod testnet;
pub(crate) mod variants;

pub(crate) use variants::DEV_ACCOUNT_SEED;

pub use self::info::Info;
pub use self::mainnet::Mainnet;
pub use self::sandbox::Sandbox;
pub use self::testnet::Testnet;
pub use self::variants::{
    AllowDevAccountCreation, DevAccountDeployer, NetworkClient, NetworkInfo, TopLevelAccountCreator,
};
