use ndate::Config;
use std::env;
use std::process;

fn main() {
  let args: Vec<String> = env::args().collect();

  let config = Config::new(&args).unwrap_or_else(|err| {
    eprintln!("problem parsing arguments, {}", err);
    process::exit(1);
  });

  if let Err(e) = ndate::execute(config) {
    eprintln!("Application error: {}", e);
    process::exit(1);
  }
}
