use serde::{
    Serialize,
    Deserialize
};


#[derive(Debug,Serialize,Deserialize)]
pub struct Continent {
    pub(crate) updated: u64,
    pub(crate) cases: u64,
    pub(crate) todayCases: u64,
    pub(crate) deaths: f64,
    pub(crate) todayDeaths: u64,
    pub(crate) recovered: f64,
    pub(crate) todayRecovered: u64,
    active: u64,
    critical: u64,
    casesPerOneMillion: f32,
    deathsPerOneMillion: f32,
    tests: u64,
    testsPerOneMillion: f64,
    population: u64,
    continent: String,
    activePerOneMillion: f32,
    recoveredPerOneMillion: f32,
    criticalPerOneMillion: f32,
    countries: Vec<String>
}

#[derive(Debug,Serialize,Deserialize)]
pub struct CountryInfo {
    _id: i32,
    iso2: String,
    iso3: String,
    lat: f32,
    long: f32,
    flag: String
}


#[derive(Debug,Serialize,Deserialize)]
pub struct Country {
    pub(crate) updated: u64,
    country: String,
    countryInfo: CountryInfo,
    pub(crate) cases: u32,
    pub(crate) todayCases: u32,
    pub(crate) deaths: f32,
    pub(crate) todayDeaths: u32,
    pub(crate) recovered: f32,
    pub(crate) todayRecovered:u32,
    active: u32,
    critical: u32,
    casesPerOneMillion: u32,
    deathsPerOneMillion: u32,
    tests: u64,
    testsPerOneMillion: u64
}

pub static SELECT_COUNTRIES: [&str; 221] = [
    "Afghanistan",
    "Armenia",
    "Azerbaijan",
    "Bahrain",
    "Bangladesh",
    "Bhutan",
    "Brunei",
    "Cambodia",
    "China",
    "Cyprus",
    "Georgia",
    "Hong Kong",
    "India",
    "Indonesia",
    "Iran",
    "Iraq",
    "Israel",
    "Japan",
    "Jordan",
    "Kazakhstan",
    "Kuwait",
    "Kyrgyzstan",
    "Lao People's Democratic Republic",
    "Lebanon",
    "Macao",
    "Malaysia",
    "Maldives",
    "Mongolia",
    "Myanmar",
    "Nepal",
    "Oman",
    "Pakistan",
    "Palestine",
    "Philippines",
    "Qatar",
    "S. Korea",
    "Saudi Arabia",
    "Singapore",
    "Sri Lanka",
    "Syrian Arab Republic",
    "Taiwan",
    "Tajikistan",
    "Thailand",
    "Timor-Leste",
    "Turkey",
    "UAE",
    "Uzbekistan",
    "Vietnam",
    "Yemen",
    "Anguilla",
    "Antigua and Barbuda",
    "Aruba",
    "Bahamas",
    "Barbados",
    "Belize",
    "Bermuda",
    "British Virgin Islands",
    "Canada",
    "Caribbean Netherlands",
    "Cayman Islands",
    "Costa Rica",
    "Cuba",
    "Curaçao",
    "Dominica",
    "Dominican Republic",
    "El Salvador",
    "Greenland",
    "Grenada",
    "Guadeloupe",
    "Guatemala",
    "Haiti",
    "Honduras",
    "Jamaica",
    "Martinique",
    "Mexico",
    "Montserrat",
    "Nicaragua",
    "Panama",
    "Saint Kitts and Nevis",
    "Saint Lucia",
    "Saint Martin",
    "Saint Pierre Miquelon",
    "Saint Vincent and the Grenadines",
    "Sint Maarten",
    "St. Barth",
    "Trinidad and Tobago",
    "Turks and Caicos Islands",
    "USA",
    "Argentina",
    "Bolivia",
    "Brazil",
    "Chile",
    "Colombia",
    "Ecuador",
    "Falkland Islands (Malvinas)",
    "French Guiana",
    "Guyana",
    "Paraguay",
    "Peru",
    "Suriname",
    "Uruguay",
    "Venezuela",
    "Albania",
    "Andorra",
    "Austria",
    "Belarus",
    "Belgium",
    "Bosnia",
    "Bulgaria",
    "Channel Islands",
    "Croatia",
    "Czechia",
    "Denmark",
    "Estonia",
    "Faroe Islands",
    "Finland",
    "France",
    "Germany",
    "Gibraltar",
    "Greece",
    "Holy See (Vatican City State)",
    "Hungary",
    "Iceland",
    "Ireland",
    "Isle of Man",
    "Italy",
    "Latvia",
    "Liechtenstein",
    "Lithuania",
    "Luxembourg",
    "Macedonia",
    "Malta",
    "Moldova",
    "Monaco",
    "Montenegro",
    "Netherlands",
    "Norway",
    "Poland",
    "Portugal",
    "Romania",
    "Russia",
    "San Marino",
    "Serbia",
    "Slovakia",
    "Slovenia",
    "Spain",
    "Sweden",
    "Switzerland",
    "UK",
    "Ukraine",
    "Algeria",
    "Angola",
    "Benin",
    "Botswana",
    "Burkina Faso",
    "Burundi",
    "Cabo Verde",
    "Cameroon",
    "Central African Republic",
    "Chad",
    "Comoros",
    "Congo",
    "Côte d'Ivoire",
    "DRC",
    "Djibouti",
    "Egypt",
    "Equatorial Guinea",
    "Eritrea",
    "Ethiopia",
    "Gabon",
    "Gambia",
    "Ghana",
    "Guinea",
    "Guinea-Bissau",
    "Kenya",
    "Lesotho",
    "Liberia",
    "Libyan Arab Jamahiriya",
    "Madagascar",
    "Malawi",
    "Mali",
    "Mauritania",
    "Mauritius",
    "Mayotte",
    "Morocco",
    "Mozambique",
    "Namibia",
    "Niger",
    "Nigeria",
    "Rwanda",
    "Réunion",
    "Saint Helena",
    "Sao Tome and Principe",
    "Senegal",
    "Seychelles",
    "Sierra Leone",
    "Somalia",
    "South Africa",
    "South Sudan",
    "Sudan",
    "Swaziland",
    "Tanzania",
    "Togo",
    "Tunisia",
    "Uganda",
    "Western Sahara",
    "Zambia",
    "Zimbabwe",
    "Australia",
    "Fiji",
    "French Polynesia",
    "Marshall Islands",
    "Micronesia",
    "New Caledonia",
    "New Zealand",
    "Palau",
    "Papua New Guinea",
    "Samoa",
    "Solomon Islands",
    "Vanuatu",
    "Wallis and Futuna"
];

pub static SELECTED_CONTINENT: [&str; 6] =["Asia", "North America", "South America", "Europe", "Africa", "Australia-Oceania"];

