use num::BigUint;

/// All base-11 Narcissistic Number store as base-10
///
/// Download from: http://oeis.org/A161948/b161948.txt
pub fn base11() -> Vec<BigUint> {
    vec![
        BigUint::from_bytes_le(&[1]),
        BigUint::from_bytes_le(&[2]),
        BigUint::from_bytes_le(&[3]),
        BigUint::from_bytes_le(&[4]),
        BigUint::from_bytes_le(&[5]),
        BigUint::from_bytes_le(&[6]),
        BigUint::from_bytes_le(&[7]),
        BigUint::from_bytes_le(&[8]),
        BigUint::from_bytes_le(&[9]),
        BigUint::from_bytes_le(&[10]),
        BigUint::from_bytes_le(&[61]),
        BigUint::from_bytes_le(&[72]),
        BigUint::from_bytes_le(&[126]),
        BigUint::from_bytes_le(&[114, 1]),
        BigUint::from_bytes_le(&[87, 3]),
        BigUint::from_bytes_le(&[137, 4]),
        BigUint::from_bytes_le(&[192, 4]),
        BigUint::from_bytes_le(&[0, 5]),
        BigUint::from_bytes_le(&[161, 41]),
        BigUint::from_bytes_le(&[201, 65]),
        BigUint::from_bytes_le(&[202, 65]),
        BigUint::from_bytes_le(&[200, 69]),
        BigUint::from_bytes_le(&[201, 69]),
        BigUint::from_bytes_le(&[85, 144]),
        BigUint::from_bytes_le(&[86, 144]),
        BigUint::from_bytes_le(&[196, 248]),
        BigUint::from_bytes_le(&[20, 3, 1]),
        BigUint::from_bytes_le(&[49, 22, 1]),
        BigUint::from_bytes_le(&[8, 96, 1]),
        BigUint::from_bytes_le(&[10, 133, 1]),
        BigUint::from_bytes_le(&[11, 133, 1]),
        BigUint::from_bytes_le(&[112, 40, 2]),
        BigUint::from_bytes_le(&[199, 102, 2]),
        BigUint::from_bytes_le(&[42, 199, 17]),
        BigUint::from_bytes_le(&[43, 199, 17]),
        BigUint::from_bytes_le(&[7, 158, 85]),
        BigUint::from_bytes_le(&[243, 124, 182]),
        BigUint::from_bytes_le(&[226, 52, 197, 2]),
        BigUint::from_bytes_le(&[130, 19, 38, 12]),
        BigUint::from_bytes_le(&[67, 40, 137, 12]),
        BigUint::from_bytes_le(&[16, 243, 181, 23]),
        BigUint::from_bytes_le(&[159, 65, 61, 49]),
        BigUint::from_bytes_le(&[66, 71, 2, 78]),
        BigUint::from_bytes_le(&[176, 242, 109, 83]),
        BigUint::from_bytes_le(&[174, 180, 15, 84]),
        BigUint::from_bytes_le(&[215, 105, 185, 88]),
        BigUint::from_bytes_le(&[32, 21, 240, 93]),
        BigUint::from_bytes_le(&[28, 145, 216, 136]),
        BigUint::from_bytes_le(&[156, 188, 38, 96, 2]),
        BigUint::from_bytes_le(&[228, 108, 65, 45, 3]),
        BigUint::from_bytes_le(&[44, 148, 197, 104, 3]),
        BigUint::from_bytes_le(&[59, 114, 167, 187, 5]),
        BigUint::from_bytes_le(&[139, 138, 43, 188, 5]),
        BigUint::from_bytes_le(&[138, 50, 182, 191, 5]),
        BigUint::from_bytes_le(&[35, 164, 232, 16, 42]),
        BigUint::from_bytes_le(&[246, 19, 150, 20, 164]),
        BigUint::from_bytes_le(&[247, 19, 150, 20, 164]),
        BigUint::from_bytes_le(&[118, 138, 28, 94, 167]),
        BigUint::from_bytes_le(&[228, 233, 184, 194, 183]),
        BigUint::from_bytes_le(&[86, 130, 62, 251, 109, 1]),
        BigUint::from_bytes_le(&[0, 91, 127, 255, 33, 9]),
        BigUint::from_bytes_le(&[141, 0, 39, 236, 177, 9]),
        BigUint::from_bytes_le(&[10, 13, 242, 203, 200, 9]),
        BigUint::from_bytes_le(&[115, 229, 150, 47, 235, 13]),
        BigUint::from_bytes_le(&[227, 223, 5, 25, 207, 14]),
        BigUint::from_bytes_le(&[119, 64, 22, 28, 157, 20]),
        BigUint::from_bytes_le(&[56, 160, 203, 79, 23, 21]),
        BigUint::from_bytes_le(&[57, 160, 203, 79, 23, 21]),
        BigUint::from_bytes_le(&[246, 208, 57, 28, 103, 96]),
        BigUint::from_bytes_le(&[68, 69, 130, 136, 168, 190]),
        BigUint::from_bytes_le(&[242, 119, 62, 1, 12, 27, 7]),
        BigUint::from_bytes_le(&[31, 70, 66, 196, 111, 253, 100, 1]),
        BigUint::from_bytes_le(&[155, 128, 47, 243, 79, 73, 108, 1]),
        BigUint::from_bytes_le(&[214, 207, 154, 164, 44, 151, 159, 1]),
        BigUint::from_bytes_le(&[91, 149, 167, 117, 64, 75, 176, 1]),
        BigUint::from_bytes_le(&[198, 46, 92, 105, 27, 155, 214, 2]),
        BigUint::from_bytes_le(&[232, 182, 11, 125, 246, 238, 69, 3]),
        BigUint::from_bytes_le(&[253, 239, 157, 80, 206, 48, 129, 3]),
        BigUint::from_bytes_le(&[232, 182, 153, 218, 106, 52, 161, 4]),
        BigUint::from_bytes_le(&[113, 165, 205, 208, 166, 129, 151, 18]),
        BigUint::from_bytes_le(&[46, 69, 210, 217, 164, 202, 71, 22]),
        BigUint::from_bytes_le(&[88, 77, 136, 213, 3, 250, 98, 30]),
        BigUint::from_bytes_le(&[183, 124, 41, 133, 142, 6, 136, 34]),
        BigUint::from_bytes_le(&[144, 102, 58, 90, 154, 192, 40, 48]),
        BigUint::from_bytes_le(&[152, 43, 17, 134, 99, 251, 27, 122, 12]),
        BigUint::from_bytes_le(&[252, 211, 40, 45, 82, 248, 99, 147, 67]),
        BigUint::from_bytes_le(&[234, 166, 17, 146, 8, 53, 198, 142, 78]),
        BigUint::from_bytes_le(&[243, 121, 106, 69, 79, 116, 213, 225, 114]),
        BigUint::from_bytes_le(&[92, 213, 108, 43, 87, 195, 244, 80, 121]),
        BigUint::from_bytes_le(&[2, 70, 72, 139, 88, 195, 33, 63, 126]),
        BigUint::from_bytes_le(&[188, 216, 55, 54, 252, 102, 122, 175, 169]),
        BigUint::from_bytes_le(&[113, 61, 237, 64, 198, 47, 129, 211, 141, 1]),
        BigUint::from_bytes_le(&[109, 163, 221, 88, 57, 225, 127, 131, 153, 2]),
        BigUint::from_bytes_le(&[15, 148, 188, 224, 142, 141, 254, 29, 195, 2]),
        BigUint::from_bytes_le(&[91, 250, 20, 184, 220, 207, 111, 6, 118, 4]),
        BigUint::from_bytes_le(&[180, 128, 9, 212, 139, 79, 130, 65, 52, 142, 9]),
        BigUint::from_bytes_le(&[196, 206, 154, 185, 37, 60, 65, 229, 62, 166, 10]),
        BigUint::from_bytes_le(&[14, 191, 222, 192, 124, 254, 44, 240, 86, 52, 17]),
        BigUint::from_bytes_le(&[211, 107, 229, 209, 63, 128, 152, 242, 161, 204, 17]),
        BigUint::from_bytes_le(&[82, 20, 139, 195, 79, 252, 162, 102, 231, 129, 25]),
        BigUint::from_bytes_le(&[124, 100, 167, 250, 246, 128, 10, 55, 98, 153, 26]),
        BigUint::from_bytes_le(&[35, 73, 113, 163, 33, 153, 223, 17, 244, 187, 174, 6]),
        BigUint::from_bytes_le(&[61, 160, 237, 163, 145, 66, 76, 92, 11, 242, 0, 97]),
        BigUint::from_bytes_le(&[74, 235, 11, 192, 77, 59, 129, 25, 191, 203, 177, 166, 2]),
        BigUint::from_bytes_le(&[221, 226, 113, 180, 240, 16, 14, 7, 16, 94, 180, 166, 2]),
        BigUint::from_bytes_le(&[222, 226, 113, 180, 240, 16, 14, 7, 16, 94, 180, 166, 2]),
        BigUint::from_bytes_le(&[144, 47, 220, 131, 210, 16, 152, 162, 252, 170, 146, 247, 3]),
        BigUint::from_bytes_le(&[224, 80, 119, 130, 89, 251, 19, 56, 93, 40, 51, 29, 5]),
        BigUint::from_bytes_le(&[100, 151, 95, 84, 194, 112, 75, 131, 32, 48, 51, 29, 5]),
        BigUint::from_bytes_le(&[53, 251, 78, 198, 222, 56, 18, 78, 119, 29, 184, 146, 51]),
        BigUint::from_bytes_le(&[237, 212, 188, 227, 136, 177, 81, 223, 135, 120, 251, 39, 52]),
        BigUint::from_bytes_le(&[11, 120, 50, 13, 127, 221, 175, 25, 26, 67, 3, 56, 128, 1]),
        BigUint::from_bytes_le(&[16, 9, 90, 193, 177, 87, 158, 149, 158, 100, 48, 113, 96, 10]),
        BigUint::from_bytes_le(&[17, 9, 90, 193, 177, 87, 158, 149, 158, 100, 48, 113, 96, 10]),
        BigUint::from_bytes_le(&[14, 46, 79, 124, 233, 58, 86, 211, 105, 248, 235, 188, 185, 19]),
        BigUint::from_bytes_le(&[13, 2, 225, 69, 254, 232, 242, 213, 1, 6, 13, 112, 22, 21]),
        BigUint::from_bytes_le(&[163, 66, 19, 225, 118, 144, 203, 41, 114, 205, 97, 133, 233, 147]),
        BigUint::from_bytes_le(&[167, 41, 191, 243, 62, 69, 165, 68, 164, 53, 254, 171, 151, 149]),
        BigUint::from_bytes_le(&[185, 207, 116, 245, 118, 0, 85, 244, 178, 208, 51, 135, 5, 151]),
        BigUint::from_bytes_le(&[186, 207, 116, 245, 118, 0, 85, 244, 178, 208, 51, 135, 5, 151]),
        BigUint::from_bytes_le(&[209, 160, 224, 60, 39, 249, 62, 226, 218, 139, 5, 83, 39, 251]),
        BigUint::from_bytes_le(&[194, 32, 153, 3, 159, 172, 218, 34, 123, 147, 77, 85, 83, 254]),
        BigUint::from_bytes_le(&[194, 97, 19, 24, 244, 138, 21, 20, 57, 196, 181, 223, 226, 93, 1]),
        BigUint::from_bytes_le(&[128, 41, 232, 2, 224, 206, 199, 73, 51, 106, 112, 40, 202, 74, 97]),
        BigUint::from_bytes_le(&[207, 115, 187, 139, 87, 141, 94, 6, 121, 71, 217, 178, 247, 223, 142, 30]),
        BigUint::from_bytes_le(&[236, 214, 138, 33, 14, 129, 202, 0, 60, 170, 111, 202, 147, 219, 58, 38]),
        BigUint::from_bytes_le(&[218, 59, 160, 55, 33, 1, 79, 125, 51, 43, 195, 217, 197, 236, 97, 38]),
        BigUint::from_bytes_le(&[198, 98, 21, 121, 145, 114, 15, 102, 128, 138, 253, 38, 26, 188, 153, 45]),
        BigUint::from_bytes_le(&[105, 38, 92, 82, 218, 154, 251, 77, 0, 162, 21, 144, 202, 29, 156, 121, 1]),
        BigUint::from_bytes_le(&[142, 81, 93, 220, 67, 245, 15, 30, 133, 192, 160, 128, 114, 141, 209, 18, 2]),
        BigUint::from_bytes_le(&[97, 144, 17, 14, 67, 82, 249, 163, 244, 140, 207, 126, 238, 125, 122, 218, 11]),
        BigUint::from_bytes_le(&[255, 68, 4, 53, 38, 236, 96, 36, 113, 153, 111, 231, 4, 183, 187, 48, 201, 5]),
        BigUint::from_bytes_le(&[228, 171, 3, 158, 115, 100, 228, 175, 173, 34, 121, 101, 222, 1, 117, 41, 205, 5]),
        BigUint::from_bytes_le(&[51, 79, 162, 14, 82, 184, 26, 21, 54, 10, 140, 247, 75, 132, 4, 177, 97, 134, 103, 1]),
    ]
}
/// All base-12 Narcissistic Number store as base-10
///
/// Download from: http://oeis.org/A161949/b161949.txt
pub fn base12() -> Vec<BigUint> {
    vec![
        BigUint::from_bytes_le(&[1]),
        BigUint::from_bytes_le(&[2]),
        BigUint::from_bytes_le(&[3]),
        BigUint::from_bytes_le(&[4]),
        BigUint::from_bytes_le(&[5]),
        BigUint::from_bytes_le(&[6]),
        BigUint::from_bytes_le(&[7]),
        BigUint::from_bytes_le(&[8]),
        BigUint::from_bytes_le(&[9]),
        BigUint::from_bytes_le(&[10]),
        BigUint::from_bytes_le(&[11]),
        BigUint::from_bytes_le(&[29]),
        BigUint::from_bytes_le(&[125]),
        BigUint::from_bytes_le(&[43, 3]),
        BigUint::from_bytes_le(&[176, 3]),
        BigUint::from_bytes_le(&[3, 6]),
        BigUint::from_bytes_le(&[61, 112]),
        BigUint::from_bytes_le(&[60, 242, 2]),
        BigUint::from_bytes_le(&[138, 139, 13]),
        BigUint::from_bytes_le(&[138, 179, 38]),
        BigUint::from_bytes_le(&[143, 13, 105]),
        BigUint::from_bytes_le(&[11, 46, 5, 1]),
        BigUint::from_bytes_le(&[17, 150, 180, 50, 1]),
        BigUint::from_bytes_le(&[69, 86, 124, 211, 5]),
        BigUint::from_bytes_le(&[158, 243, 139, 79, 9]),
        BigUint::from_bytes_le(&[1, 138, 97, 130, 68]),
        BigUint::from_bytes_le(&[222, 78, 237, 29, 70]),
        BigUint::from_bytes_le(&[43, 44, 41, 207, 91]),
        BigUint::from_bytes_le(&[114, 93, 21, 9, 100]),
        BigUint::from_bytes_le(&[154, 146, 41, 6, 104]),
        BigUint::from_bytes_le(&[121, 224, 10, 164, 165]),
        BigUint::from_bytes_le(&[71, 211, 156, 232, 167]),
        BigUint::from_bytes_le(&[106, 51, 172, 76, 171]),
        BigUint::from_bytes_le(&[224, 220, 59, 87, 171]),
        BigUint::from_bytes_le(&[3, 81, 43, 140, 104, 64]),
        BigUint::from_bytes_le(&[103, 36, 34, 202, 34, 135, 1]),
        BigUint::from_bytes_le(&[135, 53, 177, 3, 38, 188, 2]),
        BigUint::from_bytes_le(&[38, 124, 44, 196, 54, 32, 34]),
        BigUint::from_bytes_le(&[222, 224, 58, 66, 188, 173, 37]),
        BigUint::from_bytes_le(&[75, 18, 42, 200, 74, 229, 51]),
        BigUint::from_bytes_le(&[11, 136, 132, 226, 9, 223, 61]),
        BigUint::from_bytes_le(&[135, 29, 229, 130, 124, 222, 115, 1]),
        BigUint::from_bytes_le(&[35, 249, 223, 41, 73, 33, 146, 63, 10]),
        BigUint::from_bytes_le(&[11, 138, 5, 226, 158, 153, 71, 238, 43]),
        BigUint::from_bytes_le(&[172, 208, 81, 176, 8, 121, 224, 34, 110]),
        BigUint::from_bytes_le(&[173, 208, 81, 176, 8, 121, 224, 34, 110]),
        BigUint::from_bytes_le(&[110, 41, 110, 212, 161, 230, 42, 181, 158]),
        BigUint::from_bytes_le(&[69, 174, 185, 45, 230, 162, 99, 132, 169, 1]),
        BigUint::from_bytes_le(&[227, 32, 92, 112, 65, 24, 85, 124, 10, 2]),
        BigUint::from_bytes_le(&[250, 74, 226, 83, 109, 44, 228, 92, 52, 2]),
        BigUint::from_bytes_le(&[138, 213, 97, 17, 242, 206, 86, 78, 125, 2]),
        BigUint::from_bytes_le(&[31, 123, 107, 211, 83, 212, 18, 29, 161, 3]),
        BigUint::from_bytes_le(&[206, 177, 191, 157, 165, 65, 3, 182, 240, 4]),
        BigUint::from_bytes_le(&[141, 94, 186, 174, 151, 70, 59, 210, 44, 5]),
        BigUint::from_bytes_le(&[156, 245, 46, 223, 83, 204, 209, 140, 189, 6]),
        BigUint::from_bytes_le(&[64, 81, 188, 212, 18, 100, 23, 252, 19, 8]),
        BigUint::from_bytes_le(&[207, 92, 234, 180, 199, 51, 244, 8, 109, 9]),
        BigUint::from_bytes_le(&[161, 94, 88, 120, 61, 155, 172, 183, 64, 20]),
        BigUint::from_bytes_le(&[115, 15, 101, 175, 64, 222, 181, 187, 121, 21]),
        BigUint::from_bytes_le(&[108, 111, 113, 101, 255, 130, 91, 125, 124, 12, 19]),
        BigUint::from_bytes_le(&[228, 34, 161, 71, 169, 48, 204, 125, 111, 244, 180, 7]),
        BigUint::from_bytes_le(&[17, 212, 22, 234, 76, 23, 110, 22, 167, 85, 177, 199, 3]),
        BigUint::from_bytes_le(&[142, 157, 50, 134, 126, 62, 101, 102, 127, 204, 72, 186, 5]),
        BigUint::from_bytes_le(&[223, 178, 73, 195, 98, 189, 127, 7, 88, 17, 131, 138, 231, 28]),
        BigUint::from_bytes_le(&[218, 57, 2, 155, 3, 12, 191, 119, 86, 142, 78, 94, 255, 28]),
        BigUint::from_bytes_le(&[125, 8, 26, 45, 109, 133, 73, 95, 22, 72, 60, 137, 232, 29]),
        BigUint::from_bytes_le(&[171, 89, 166, 43, 174, 166, 222, 212, 5, 223, 102, 140, 229, 38]),
        BigUint::from_bytes_le(&[227, 169, 136, 73, 207, 165, 230, 107, 82, 38, 161, 107, 221, 39]),
        BigUint::from_bytes_le(&[100, 232, 244, 245, 129, 93, 90, 114, 230, 122, 119, 90, 81, 58]),
        BigUint::from_bytes_le(&[101, 232, 244, 245, 129, 93, 90, 114, 230, 122, 119, 90, 81, 58]),
        BigUint::from_bytes_le(&[152, 1, 239, 142, 164, 219, 162, 225, 211, 44, 235, 62, 76, 89, 157]),
        BigUint::from_bytes_le(&[153, 1, 239, 142, 164, 219, 162, 225, 211, 44, 235, 62, 76, 89, 157]),
        BigUint::from_bytes_le(&[89, 116, 97, 101, 60, 140, 194, 65, 99, 169, 188, 122, 255, 203, 116, 4]),
        BigUint::from_bytes_le(&[244, 124, 76, 35, 15, 249, 117, 101, 163, 147, 20, 237, 140, 6, 83, 71]),
        BigUint::from_bytes_le(&[172, 179, 15, 104, 150, 102, 68, 151, 158, 246, 237, 215, 51, 174, 166, 47, 93, 3]),
        BigUint::from_bytes_le(&[173, 179, 15, 104, 150, 102, 68, 151, 158, 246, 237, 215, 51, 174, 166, 47, 93, 3]),
        BigUint::from_bytes_le(&[112, 152, 103, 121, 104, 58, 30, 98, 225, 166, 100, 0, 141, 107, 253, 135, 123, 171]),
        BigUint::from_bytes_le(&[113, 152, 103, 121, 104, 58, 30, 98, 225, 166, 100, 0, 141, 107, 253, 135, 123, 171]),
        BigUint::from_bytes_le(&[9, 137, 30, 98, 120, 209, 126, 213, 47, 30, 34, 101, 82, 11, 122, 22, 19, 176]),
        BigUint::from_bytes_le(&[245, 216, 93, 192, 119, 151, 14, 152, 171, 188, 135, 252, 58, 63, 157, 198, 211, 229]),
        BigUint::from_bytes_le(&[28, 25, 68, 190, 239, 124, 81, 253, 143, 5, 203, 212, 110, 82, 158, 203, 19, 232]),
        BigUint::from_bytes_le(&[244, 229, 22, 22, 239, 100, 246, 197, 50, 207, 112, 232, 18, 161, 25, 125, 27, 232]),
        BigUint::from_bytes_le(&[68, 204, 89, 23, 139, 21, 154, 188, 95, 106, 139, 83, 151, 20, 104, 245, 58, 89, 1]),
        BigUint::from_bytes_le(&[69, 204, 89, 23, 139, 21, 154, 188, 95, 106, 139, 83, 151, 20, 104, 245, 58, 89, 1]),
        BigUint::from_bytes_le(&[11, 67, 46, 164, 180, 221, 251, 78, 190, 112, 248, 126, 78, 74, 163, 110, 44, 112, 190]),
        BigUint::from_bytes_le(&[47, 176, 54, 150, 42, 139, 224, 19, 64, 166, 162, 122, 11, 242, 170, 81, 123, 217, 52, 159, 209, 203, 10]),
        BigUint::from_bytes_le(&[11, 116, 130, 131, 124, 254, 36, 88, 152, 188, 207, 54, 117, 47, 66, 194, 44, 113, 12, 61, 191, 128, 13]),
    ]
}
/// All base-13 Narcissistic Number store as base-10
///
/// Download from: http://oeis.org/A161950/b161950.txt
pub fn base13() -> Vec<BigUint> {
    vec![
        BigUint::from_bytes_le(&[1]),
        BigUint::from_bytes_le(&[2]),
        BigUint::from_bytes_le(&[3]),
        BigUint::from_bytes_le(&[4]),
        BigUint::from_bytes_le(&[5]),
        BigUint::from_bytes_le(&[6]),
        BigUint::from_bytes_le(&[7]),
        BigUint::from_bytes_le(&[8]),
        BigUint::from_bytes_le(&[9]),
        BigUint::from_bytes_le(&[10]),
        BigUint::from_bytes_le(&[11]),
        BigUint::from_bytes_le(&[12]),
        BigUint::from_bytes_le(&[17]),
        BigUint::from_bytes_le(&[45]),
        BigUint::from_bytes_le(&[85]),
        BigUint::from_bytes_le(&[98]),
        BigUint::from_bytes_le(&[136]),
        BigUint::from_bytes_le(&[160]),
        BigUint::from_bytes_le(&[25, 3]),
        BigUint::from_bytes_le(&[26, 3]),
        BigUint::from_bytes_le(&[86, 3]),
        BigUint::from_bytes_le(&[176, 7]),
        BigUint::from_bytes_le(&[2, 32]),
        BigUint::from_bytes_le(&[17, 244]),
        BigUint::from_bytes_le(&[120, 142, 2]),
        BigUint::from_bytes_le(&[121, 142, 2]),
        BigUint::from_bytes_le(&[206, 124, 4]),
        BigUint::from_bytes_le(&[119, 227, 4]),
        BigUint::from_bytes_le(&[28, 240, 4]),
        BigUint::from_bytes_le(&[95, 247, 4]),
        BigUint::from_bytes_le(&[81, 248, 4]),
        BigUint::from_bytes_le(&[179, 87, 5]),
        BigUint::from_bytes_le(&[90, 149, 5]),
        BigUint::from_bytes_le(&[227, 205, 36]),
        BigUint::from_bytes_le(&[168, 45, 74]),
        BigUint::from_bytes_le(&[178, 70, 75, 1]),
        BigUint::from_bytes_le(&[255, 174, 155, 2]),
        BigUint::from_bytes_le(&[0, 175, 155, 2]),
        BigUint::from_bytes_le(&[22, 121, 194, 2]),
        BigUint::from_bytes_le(&[40, 98, 22, 3]),
        BigUint::from_bytes_le(&[5, 160, 40, 3]),
        BigUint::from_bytes_le(&[163, 83, 115, 17]),
        BigUint::from_bytes_le(&[194, 143, 239, 17]),
        BigUint::from_bytes_le(&[149, 234, 204, 54]),
        BigUint::from_bytes_le(&[190, 70, 17, 151]),
        BigUint::from_bytes_le(&[42, 48, 94, 233, 1]),
        BigUint::from_bytes_le(&[34, 41, 255, 57, 2]),
        BigUint::from_bytes_le(&[44, 109, 236, 187, 3]),
        BigUint::from_bytes_le(&[140, 110, 62, 66, 15]),
        BigUint::from_bytes_le(&[28, 38, 236, 127, 2, 1]),
        BigUint::from_bytes_le(&[127, 51, 178, 200, 186, 109]),
        BigUint::from_bytes_le(&[42, 231, 94, 151, 6, 117]),
        BigUint::from_bytes_le(&[147, 238, 49, 28, 156, 125]),
        BigUint::from_bytes_le(&[117, 162, 199, 232, 68, 199]),
        BigUint::from_bytes_le(&[205, 243, 122, 129, 209, 224]),
        BigUint::from_bytes_le(&[27, 138, 131, 101, 121, 245]),
        BigUint::from_bytes_le(&[180, 241, 58, 13, 128, 215, 11]),
        BigUint::from_bytes_le(&[167, 60, 135, 3, 127, 27, 34]),
        BigUint::from_bytes_le(&[171, 103, 37, 120, 35, 211, 48]),
        BigUint::from_bytes_le(&[149, 195, 177, 28, 11, 198, 71]),
        BigUint::from_bytes_le(&[203, 103, 158, 182, 202, 202, 71]),
        BigUint::from_bytes_le(&[90, 74, 236, 229, 63, 93, 115]),
        BigUint::from_bytes_le(&[89, 118, 158, 124, 6, 144, 125]),
        BigUint::from_bytes_le(&[201, 154, 243, 73, 218, 166, 219]),
        BigUint::from_bytes_le(&[75, 87, 220, 106, 188, 155, 65, 3]),
        BigUint::from_bytes_le(&[124, 189, 37, 132, 68, 146, 151, 14]),
        BigUint::from_bytes_le(&[246, 174, 178, 250, 54, 211, 224, 32]),
        BigUint::from_bytes_le(&[111, 224, 92, 137, 150, 17, 72, 45]),
        BigUint::from_bytes_le(&[253, 64, 55, 191, 70, 247, 182, 75]),
        BigUint::from_bytes_le(&[228, 173, 212, 161, 48, 248, 246, 75]),
        BigUint::from_bytes_le(&[111, 174, 67, 201, 92, 217, 175, 102]),
        BigUint::from_bytes_le(&[169, 234, 75, 122, 219, 112, 142, 170]),
        BigUint::from_bytes_le(&[177, 29, 69, 169, 229, 88, 73, 198]),
        BigUint::from_bytes_le(&[97, 141, 186, 188, 76, 163, 229, 59, 5]),
        BigUint::from_bytes_le(&[50, 101, 125, 52, 229, 207, 115, 181, 10]),
        BigUint::from_bytes_le(&[217, 164, 196, 251, 41, 137, 129, 161, 18]),
        BigUint::from_bytes_le(&[108, 77, 137, 210, 219, 71, 51, 190, 24]),
        BigUint::from_bytes_le(&[170, 13, 235, 145, 52, 205, 166, 114, 153, 2]),
        BigUint::from_bytes_le(&[107, 64, 88, 41, 191, 174, 154, 22, 85, 8]),
        BigUint::from_bytes_le(&[200, 228, 188, 20, 143, 125, 155, 203, 160, 12]),
        BigUint::from_bytes_le(&[12, 183, 223, 160, 55, 214, 226, 218, 35, 13]),
        BigUint::from_bytes_le(&[71, 221, 205, 41, 55, 94, 110, 88, 156, 24]),
        BigUint::from_bytes_le(&[73, 112, 9, 254, 228, 141, 219, 93, 153, 32]),
        BigUint::from_bytes_le(&[22, 79, 46, 250, 99, 118, 223, 122, 25, 41]),
        BigUint::from_bytes_le(&[81, 79, 71, 3, 52, 105, 139, 157, 52, 171, 5]),
        BigUint::from_bytes_le(&[78, 154, 5, 52, 181, 160, 238, 151, 60, 53, 11]),
        BigUint::from_bytes_le(&[49, 12, 26, 30, 36, 6, 247, 199, 219, 202, 11]),
        BigUint::from_bytes_le(&[42, 122, 231, 86, 240, 221, 179, 61, 201, 79, 99]),
        BigUint::from_bytes_le(&[196, 44, 55, 80, 112, 179, 161, 41, 125, 131, 83, 1]),
        BigUint::from_bytes_le(&[102, 51, 128, 40, 228, 32, 96, 207, 108, 96, 200, 3]),
        BigUint::from_bytes_le(&[133, 95, 244, 189, 238, 113, 80, 171, 250, 115, 75, 4]),
        BigUint::from_bytes_le(&[211, 101, 162, 235, 3, 57, 209, 246, 32, 18, 133, 6]),
        BigUint::from_bytes_le(&[181, 201, 61, 121, 116, 20, 226, 118, 80, 69, 150, 6]),
        BigUint::from_bytes_le(&[190, 159, 132, 69, 200, 210, 57, 114, 84, 199, 229, 6]),
        BigUint::from_bytes_le(&[46, 54, 102, 117, 17, 122, 64, 41, 227, 80, 56, 7]),
        BigUint::from_bytes_le(&[42, 159, 145, 236, 15, 43, 251, 237, 154, 60, 72, 7]),
        BigUint::from_bytes_le(&[147, 160, 125, 253, 170, 235, 209, 32, 150, 246, 8, 11]),
        BigUint::from_bytes_le(&[223, 73, 135, 201, 16, 6, 229, 145, 204, 37, 120, 16]),
        BigUint::from_bytes_le(&[251, 203, 3, 224, 126, 159, 25, 116, 160, 41, 78, 38]),
        BigUint::from_bytes_le(&[222, 3, 206, 73, 4, 19, 211, 60, 194, 89, 146, 41]),
        BigUint::from_bytes_le(&[213, 107, 164, 23, 69, 48, 75, 43, 34, 51, 0, 148]),
        BigUint::from_bytes_le(&[20, 204, 23, 230, 158, 28, 73, 251, 116, 121, 11, 156]),
        BigUint::from_bytes_le(&[50, 71, 20, 208, 235, 20, 136, 245, 30, 171, 178, 26, 2]),
        BigUint::from_bytes_le(&[89, 69, 52, 119, 42, 137, 23, 83, 252, 236, 114, 208, 3]),
        BigUint::from_bytes_le(&[80, 232, 114, 132, 192, 128, 25, 23, 103, 183, 227, 42, 4]),
        BigUint::from_bytes_le(&[190, 195, 46, 209, 46, 224, 181, 233, 187, 1, 147, 82, 4]),
        BigUint::from_bytes_le(&[6, 176, 62, 22, 78, 64, 238, 143, 20, 61, 47, 52, 5]),
        BigUint::from_bytes_le(&[226, 110, 37, 125, 1, 125, 96, 249, 125, 139, 238, 113, 5]),
        BigUint::from_bytes_le(&[107, 80, 202, 188, 214, 144, 44, 147, 158, 229, 81, 165, 26]),
        BigUint::from_bytes_le(&[16, 170, 188, 93, 93, 187, 163, 208, 61, 187, 103, 163, 45]),
        BigUint::from_bytes_le(&[107, 203, 128, 77, 7, 41, 105, 82, 110, 90, 234, 193, 64]),
        BigUint::from_bytes_le(&[173, 175, 12, 110, 207, 103, 77, 77, 156, 171, 138, 11, 72]),
        BigUint::from_bytes_le(&[67, 83, 21, 31, 203, 207, 126, 174, 179, 174, 68, 79, 36, 1]),
        BigUint::from_bytes_le(&[189, 141, 43, 87, 9, 68, 70, 211, 121, 130, 55, 205, 53, 1]),
        BigUint::from_bytes_le(&[108, 203, 149, 74, 95, 119, 240, 114, 251, 141, 134, 228, 73, 1]),
        BigUint::from_bytes_le(&[109, 203, 149, 74, 95, 119, 240, 114, 251, 141, 134, 228, 73, 1]),
        BigUint::from_bytes_le(&[178, 13, 36, 117, 223, 116, 192, 134, 11, 146, 18, 91, 76, 1]),
        BigUint::from_bytes_le(&[176, 142, 197, 55, 199, 20, 102, 160, 254, 27, 224, 5, 10, 2]),
        BigUint::from_bytes_le(&[244, 155, 2, 215, 247, 5, 55, 226, 70, 67, 211, 216, 88, 2]),
        BigUint::from_bytes_le(&[132, 107, 237, 238, 70, 96, 201, 54, 86, 56, 105, 42, 6, 3]),
        BigUint::from_bytes_le(&[149, 8, 32, 154, 21, 190, 133, 20, 38, 38, 242, 236, 24, 3]),
        BigUint::from_bytes_le(&[217, 64, 254, 186, 199, 162, 216, 68, 207, 234, 13, 74, 233, 3]),
        BigUint::from_bytes_le(&[7, 111, 126, 185, 32, 239, 111, 140, 250, 26, 211, 91, 81, 171]),
        BigUint::from_bytes_le(&[23, 21, 214, 229, 246, 39, 38, 209, 169, 176, 131, 188, 210, 45, 1]),
        BigUint::from_bytes_le(&[160, 216, 124, 92, 194, 189, 254, 131, 185, 42, 246, 224, 206, 53, 1]),
        BigUint::from_bytes_le(&[168, 137, 177, 199, 205, 105, 89, 27, 13, 90, 94, 180, 208, 62, 1]),
        BigUint::from_bytes_le(&[88, 128, 221, 221, 206, 213, 105, 164, 141, 93, 201, 144, 49, 88, 2]),
        BigUint::from_bytes_le(&[89, 128, 221, 221, 206, 213, 105, 164, 141, 93, 201, 144, 49, 88, 2]),
        BigUint::from_bytes_le(&[43, 168, 239, 115, 122, 180, 135, 29, 231, 200, 240, 206, 152, 220, 2]),
        BigUint::from_bytes_le(&[16, 228, 170, 136, 113, 62, 21, 201, 87, 28, 150, 231, 227, 7, 21]),
        BigUint::from_bytes_le(&[144, 68, 164, 252, 104, 142, 136, 129, 192, 199, 11, 24, 41, 147, 27]),
        BigUint::from_bytes_le(&[196, 65, 46, 228, 65, 130, 111, 95, 117, 158, 150, 138, 13, 134, 88]),
        BigUint::from_bytes_le(&[209, 211, 247, 21, 209, 130, 185, 115, 111, 158, 205, 84, 67, 189, 88]),
        BigUint::from_bytes_le(&[251, 21, 11, 61, 165, 194, 95, 145, 228, 32, 43, 209, 246, 163, 92]),
        BigUint::from_bytes_le(&[32, 54, 194, 76, 211, 118, 96, 166, 239, 1, 80, 247, 96, 32, 124]),
        BigUint::from_bytes_le(&[232, 244, 4, 146, 116, 228, 212, 234, 246, 104, 125, 85, 125, 211, 171]),
        BigUint::from_bytes_le(&[115, 53, 127, 236, 138, 41, 69, 121, 102, 210, 15, 94, 69, 25, 78, 1]),
        BigUint::from_bytes_le(&[42, 214, 36, 36, 171, 193, 199, 54, 17, 251, 193, 34, 65, 154, 255, 7]),
        BigUint::from_bytes_le(&[158, 10, 8, 185, 164, 19, 148, 152, 200, 15, 65, 221, 199, 84, 106, 97]),
        BigUint::from_bytes_le(&[47, 194, 40, 32, 109, 233, 152, 201, 222, 238, 242, 176, 246, 214, 185, 135]),
        BigUint::from_bytes_le(&[243, 9, 50, 46, 71, 78, 119, 69, 22, 126, 244, 37, 247, 240, 38, 146]),
        BigUint::from_bytes_le(&[53, 182, 141, 197, 21, 44, 169, 47, 89, 218, 217, 199, 126, 76, 183, 226]),
        BigUint::from_bytes_le(&[239, 227, 5, 202, 138, 221, 179, 88, 66, 210, 151, 225, 163, 109, 19, 133, 8]),
        BigUint::from_bytes_le(&[35, 186, 69, 134, 133, 133, 201, 72, 61, 164, 12, 105, 234, 48, 148, 203, 8]),
        BigUint::from_bytes_le(&[10, 250, 222, 169, 62, 213, 154, 174, 251, 111, 200, 154, 251, 216, 213, 19, 54]),
        BigUint::from_bytes_le(&[191, 34, 227, 32, 99, 157, 27, 80, 238, 117, 100, 85, 195, 28, 213, 3, 80]),
        BigUint::from_bytes_le(&[189, 124, 89, 122, 177, 55, 71, 16, 96, 30, 174, 109, 13, 153, 186, 10, 100]),
        BigUint::from_bytes_le(&[190, 124, 89, 122, 177, 55, 71, 16, 96, 30, 174, 109, 13, 153, 186, 10, 100]),
        BigUint::from_bytes_le(&[202, 238, 221, 150, 79, 181, 120, 230, 199, 206, 231, 43, 193, 90, 201, 24, 127]),
        BigUint::from_bytes_le(&[123, 105, 83, 5, 127, 232, 58, 28, 39, 235, 68, 160, 121, 103, 7, 44, 132, 2]),
        BigUint::from_bytes_le(&[173, 18, 71, 151, 54, 199, 231, 145, 126, 29, 204, 226, 90, 190, 57, 68, 40, 29]),
        BigUint::from_bytes_le(&[163, 254, 19, 26, 45, 153, 113, 188, 141, 24, 194, 234, 170, 81, 115, 90, 173, 42]),
        BigUint::from_bytes_le(&[176, 212, 188, 57, 103, 6, 120, 20, 155, 135, 85, 205, 199, 59, 10, 35, 42, 58]),
        BigUint::from_bytes_le(&[206, 208, 99, 171, 49, 77, 27, 31, 5, 112, 7, 7, 128, 17, 53, 151, 54, 72]),
        BigUint::from_bytes_le(&[209, 185, 242, 6, 201, 101, 4, 162, 237, 163, 224, 228, 223, 243, 149, 127, 173, 81, 1]),
        BigUint::from_bytes_le(&[17, 78, 231, 28, 141, 114, 219, 218, 90, 1, 152, 85, 229, 201, 104, 159, 180, 178, 2]),
        BigUint::from_bytes_le(&[18, 78, 231, 28, 141, 114, 219, 218, 90, 1, 152, 85, 229, 201, 104, 159, 180, 178, 2]),
        BigUint::from_bytes_le(&[20, 42, 116, 119, 62, 65, 122, 44, 138, 208, 0, 223, 112, 100, 218, 37, 218, 96, 3]),
        BigUint::from_bytes_le(&[15, 61, 71, 217, 31, 158, 51, 137, 182, 138, 220, 83, 118, 113, 199, 24, 250, 125, 16]),
        BigUint::from_bytes_le(&[147, 30, 199, 108, 27, 170, 173, 81, 197, 201, 81, 175, 82, 223, 129, 22, 62, 128, 16]),
        BigUint::from_bytes_le(&[166, 221, 119, 60, 249, 23, 197, 70, 18, 218, 67, 205, 157, 206, 6, 245, 133, 130, 16]),
        BigUint::from_bytes_le(&[167, 221, 119, 60, 249, 23, 197, 70, 18, 218, 67, 205, 157, 206, 6, 245, 133, 130, 16]),
        BigUint::from_bytes_le(&[104, 46, 156, 237, 92, 227, 197, 45, 111, 127, 185, 104, 253, 36, 149, 241, 146, 242, 16]),
        BigUint::from_bytes_le(&[94, 227, 149, 149, 254, 13, 177, 116, 241, 249, 51, 50, 5, 40, 210, 252, 187, 47, 24]),
        BigUint::from_bytes_le(&[22, 246, 155, 142, 36, 151, 194, 228, 238, 148, 3, 247, 150, 188, 183, 143, 177, 233, 47]),
        BigUint::from_bytes_le(&[236, 131, 34, 232, 154, 20, 245, 181, 197, 159, 154, 100, 238, 203, 173, 54, 84, 101, 64]),
        BigUint::from_bytes_le(&[89, 109, 245, 9, 187, 54, 221, 193, 239, 253, 215, 10, 15, 78, 144, 44, 172, 89, 126, 1]),
        BigUint::from_bytes_le(&[207, 145, 133, 107, 211, 187, 75, 170, 156, 59, 245, 91, 206, 229, 38, 31, 112, 99, 157, 2]),
        BigUint::from_bytes_le(&[188, 38, 87, 92, 243, 50, 76, 147, 213, 53, 226, 207, 57, 197, 107, 127, 40, 195, 3, 18]),
        BigUint::from_bytes_le(&[209, 189, 56, 49, 205, 201, 88, 182, 62, 194, 81, 189, 78, 210, 132, 245, 6, 110, 29, 18]),
        BigUint::from_bytes_le(&[195, 27, 228, 138, 147, 191, 245, 69, 179, 222, 26, 0, 181, 250, 24, 200, 168, 255, 55, 18]),
        BigUint::from_bytes_le(&[246, 200, 21, 87, 45, 29, 24, 52, 238, 26, 26, 44, 240, 160, 232, 12, 204, 88, 84, 18]),
        BigUint::from_bytes_le(&[221, 91, 31, 67, 230, 22, 223, 63, 185, 26, 159, 18, 177, 127, 25, 239, 207, 206, 111, 18]),
        BigUint::from_bytes_le(&[1, 138, 45, 34, 67, 62, 179, 24, 63, 32, 245, 159, 174, 127, 104, 71, 129, 43, 3, 27]),
        BigUint::from_bytes_le(&[194, 196, 213, 238, 71, 118, 65, 115, 159, 255, 222, 93, 29, 208, 217, 142, 48, 141, 127, 168, 7]),
        BigUint::from_bytes_le(&[6, 23, 71, 107, 224, 161, 1, 95, 129, 208, 104, 95, 87, 146, 6, 91, 252, 22, 120, 41, 10]),
        BigUint::from_bytes_le(&[182, 157, 200, 245, 80, 218, 32, 23, 234, 81, 223, 243, 31, 185, 99, 102, 177, 188, 22, 195, 12]),
        BigUint::from_bytes_le(&[183, 157, 200, 245, 80, 218, 32, 23, 234, 81, 223, 243, 31, 185, 99, 102, 177, 188, 22, 195, 12]),
        BigUint::from_bytes_le(&[89, 220, 43, 186, 42, 208, 22, 104, 112, 54, 139, 230, 179, 66, 248, 62, 255, 229, 69, 30, 15]),
        BigUint::from_bytes_le(&[238, 182, 0, 58, 185, 47, 31, 195, 18, 45, 161, 91, 196, 75, 215, 29, 83, 138, 46, 63, 121]),
        BigUint::from_bytes_le(&[147, 138, 49, 121, 245, 185, 130, 247, 217, 250, 169, 8, 112, 72, 87, 255, 159, 185, 141, 84, 122]),
        BigUint::from_bytes_le(&[148, 138, 49, 121, 245, 185, 130, 247, 217, 250, 169, 8, 112, 72, 87, 255, 159, 185, 141, 84, 122]),
        BigUint::from_bytes_le(&[193, 91, 50, 160, 161, 226, 123, 69, 100, 133, 0, 131, 51, 144, 140, 221, 192, 239, 116, 193, 180]),
        BigUint::from_bytes_le(&[174, 228, 69, 52, 237, 192, 99, 115, 121, 38, 178, 222, 12, 150, 206, 106, 242, 102, 124, 168, 161, 5]),
        BigUint::from_bytes_le(&[175, 228, 69, 52, 237, 192, 99, 115, 121, 38, 178, 222, 12, 150, 206, 106, 242, 102, 124, 168, 161, 5]),
        BigUint::from_bytes_le(&[62, 218, 8, 85, 193, 198, 152, 121, 7, 164, 33, 213, 15, 12, 251, 237, 214, 227, 180, 89, 126, 8]),
        BigUint::from_bytes_le(&[95, 192, 171, 176, 173, 121, 211, 242, 166, 224, 57, 184, 123, 114, 14, 206, 169, 186, 111, 169, 236, 9]),
        BigUint::from_bytes_le(&[151, 44, 173, 103, 115, 5, 210, 81, 92, 33, 40, 197, 172, 53, 157, 57, 183, 75, 85, 206, 89, 68]),
        BigUint::from_bytes_le(&[62, 117, 147, 202, 78, 113, 29, 184, 117, 47, 18, 183, 87, 95, 211, 71, 151, 66, 113, 169, 79, 251, 3]),
        BigUint::from_bytes_le(&[9, 188, 48, 25, 149, 129, 43, 39, 34, 46, 245, 240, 179, 166, 253, 21, 154, 37, 249, 96, 246, 0, 4]),
        BigUint::from_bytes_le(&[24, 85, 244, 88, 178, 100, 205, 222, 55, 127, 240, 14, 128, 7, 92, 228, 122, 38, 239, 250, 178, 222, 57]),
        BigUint::from_bytes_le(&[58, 180, 230, 119, 135, 145, 39, 238, 159, 1, 182, 239, 239, 211, 80, 240, 79, 171, 228, 23, 28, 42, 62, 2]),
        BigUint::from_bytes_le(&[59, 180, 230, 119, 135, 145, 39, 238, 159, 1, 182, 239, 239, 211, 80, 240, 79, 171, 228, 23, 28, 42, 62, 2]),
        BigUint::from_bytes_le(&[198, 117, 231, 141, 168, 89, 130, 195, 59, 45, 87, 158, 182, 126, 106, 216, 78, 175, 162, 117, 125, 134, 145, 3]),
        BigUint::from_bytes_le(&[50, 118, 177, 233, 116, 87, 224, 2, 247, 132, 12, 195, 77, 191, 240, 131, 195, 103, 110, 244, 236, 242, 229, 26]),
        BigUint::from_bytes_le(&[193, 32, 89, 155, 89, 12, 78, 90, 5, 113, 69, 170, 39, 189, 40, 113, 187, 127, 47, 95, 84, 5, 90, 131, 1]),
        BigUint::from_bytes_le(&[0, 113, 145, 60, 149, 117, 108, 13, 3, 149, 185, 146, 13, 18, 210, 163, 89, 125, 109, 254, 80, 1, 203, 37, 18]),
        BigUint::from_bytes_le(&[81, 91, 63, 74, 161, 108, 121, 160, 150, 85, 45, 186, 15, 237, 248, 168, 226, 221, 11, 210, 228, 91, 207, 163, 254]),
        BigUint::from_bytes_le(&[50, 105, 47, 165, 122, 51, 144, 106, 250, 237, 251, 155, 213, 190, 57, 148, 190, 128, 232, 32, 221, 215, 247, 10, 221, 11]),
        BigUint::from_bytes_le(&[132, 142, 66, 191, 95, 204, 104, 231, 185, 30, 61, 8, 149, 105, 108, 108, 42, 57, 215, 140, 114, 33, 107, 57, 88, 183]),
        BigUint::from_bytes_le(&[67, 113, 222, 100, 187, 79, 19, 91, 1, 39, 162, 184, 183, 221, 5, 25, 54, 44, 55, 65, 81, 179, 12, 151, 234, 56, 201, 70]),
    ]
}
/// All base-14 Narcissistic Number store as base-10
///
/// Download from: http://oeis.org/A161951/b161951.txt
pub fn base14() -> Vec<BigUint> {
    vec![
        BigUint::from_bytes_le(&[1]),
        BigUint::from_bytes_le(&[2]),
        BigUint::from_bytes_le(&[3]),
        BigUint::from_bytes_le(&[4]),
        BigUint::from_bytes_le(&[5]),
        BigUint::from_bytes_le(&[6]),
        BigUint::from_bytes_le(&[7]),
        BigUint::from_bytes_le(&[8]),
        BigUint::from_bytes_le(&[9]),
        BigUint::from_bytes_le(&[10]),
        BigUint::from_bytes_le(&[11]),
        BigUint::from_bytes_le(&[12]),
        BigUint::from_bytes_le(&[13]),
        BigUint::from_bytes_le(&[244]),
        BigUint::from_bytes_le(&[25, 3]),
        BigUint::from_bytes_le(&[151, 77, 4]),
        BigUint::from_bytes_le(&[196, 30, 158]),
        BigUint::from_bytes_le(&[36, 210, 43, 86]),
        BigUint::from_bytes_le(&[21, 251, 23, 225, 6]),
        BigUint::from_bytes_le(&[47, 34, 171, 56, 38]),
        BigUint::from_bytes_le(&[70, 92, 135, 191, 79]),
        BigUint::from_bytes_le(&[245, 200, 119, 153, 83]),
        BigUint::from_bytes_le(&[83, 119, 48, 100, 164, 196]),
        BigUint::from_bytes_le(&[164, 121, 89, 165, 190, 38, 1]),
        BigUint::from_bytes_le(&[202, 204, 118, 128, 227, 51, 1]),
        BigUint::from_bytes_le(&[195, 153, 115, 184, 246, 51, 1]),
        BigUint::from_bytes_le(&[83, 232, 39, 33, 37, 92, 1]),
        BigUint::from_bytes_le(&[112, 203, 33, 114, 207, 139, 1]),
        BigUint::from_bytes_le(&[82, 27, 48, 124, 121, 222, 1]),
        BigUint::from_bytes_le(&[162, 249, 133, 29, 25, 255, 1]),
        BigUint::from_bytes_le(&[135, 1, 117, 246, 77, 153, 2]),
        BigUint::from_bytes_le(&[142, 196, 184, 98, 37, 217, 10]),
        BigUint::from_bytes_le(&[182, 165, 14, 222, 232, 76, 3, 1]),
        BigUint::from_bytes_le(&[72, 96, 99, 207, 239, 154, 182, 2]),
        BigUint::from_bytes_le(&[91, 3, 113, 222, 191, 44, 166, 40]),
        BigUint::from_bytes_le(&[50, 23, 57, 86, 12, 254, 249, 128]),
        BigUint::from_bytes_le(&[51, 23, 57, 86, 12, 254, 249, 128]),
        BigUint::from_bytes_le(&[32, 9, 161, 247, 255, 217, 7, 190]),
        BigUint::from_bytes_le(&[24, 40, 222, 101, 109, 97, 121, 209, 1]),
        BigUint::from_bytes_le(&[194, 89, 211, 184, 222, 41, 138, 77, 14]),
        BigUint::from_bytes_le(&[186, 9, 103, 16, 32, 101, 221, 246, 82]),
        BigUint::from_bytes_le(&[83, 43, 206, 104, 220, 89, 250, 155, 97]),
        BigUint::from_bytes_le(&[123, 245, 146, 202, 149, 9, 45, 237, 0, 14]),
        BigUint::from_bytes_le(&[65, 113, 123, 183, 217, 249, 132, 0, 33, 85]),
        BigUint::from_bytes_le(&[6, 93, 210, 141, 207, 112, 222, 152, 30, 107]),
        BigUint::from_bytes_le(&[12, 126, 240, 43, 71, 181, 141, 16, 103, 104, 79, 2]),
        BigUint::from_bytes_le(&[13, 126, 240, 43, 71, 181, 141, 16, 103, 104, 79, 2]),
        BigUint::from_bytes_le(&[155, 1, 228, 143, 196, 64, 102, 197, 77, 119, 114, 13]),
        BigUint::from_bytes_le(&[68, 112, 43, 203, 214, 137, 105, 196, 40, 233, 127, 32]),
        BigUint::from_bytes_le(&[234, 213, 207, 39, 255, 96, 78, 159, 196, 164, 4, 46]),
        BigUint::from_bytes_le(&[193, 15, 127, 86, 60, 244, 238, 46, 101, 86, 26, 49]),
        BigUint::from_bytes_le(&[10, 114, 52, 130, 44, 41, 154, 213, 211, 9, 38, 52]),
        BigUint::from_bytes_le(&[176, 79, 7, 173, 235, 87, 131, 174, 160, 70, 183, 77]),
        BigUint::from_bytes_le(&[158, 80, 78, 219, 129, 54, 135, 26, 67, 158, 40, 85, 17]),
        BigUint::from_bytes_le(&[74, 16, 54, 172, 60, 200, 201, 36, 194, 0, 7, 34, 62]),
        BigUint::from_bytes_le(&[122, 15, 215, 219, 80, 206, 223, 198, 37, 20, 71, 141, 4, 1]),
        BigUint::from_bytes_le(&[230, 207, 248, 138, 82, 60, 52, 11, 193, 81, 196, 142, 253, 141]),
        BigUint::from_bytes_le(&[245, 15, 107, 148, 102, 83, 94, 139, 174, 35, 187, 26, 6, 213, 160, 13]),
        BigUint::from_bytes_le(&[152, 124, 50, 46, 77, 64, 93, 165, 119, 74, 152, 62, 235, 142, 17, 86, 1]),
        BigUint::from_bytes_le(&[38, 77, 17, 213, 35, 181, 97, 136, 133, 100, 119, 252, 44, 66, 138, 40, 227]),
        BigUint::from_bytes_le(&[110, 131, 106, 69, 242, 75, 142, 20, 158, 190, 197, 135, 227, 122, 68, 44, 73, 2]),
        BigUint::from_bytes_le(&[134, 40, 59, 23, 97, 44, 23, 38, 252, 148, 98, 217, 1, 77, 226, 28, 74, 2]),
        BigUint::from_bytes_le(&[64, 205, 236, 63, 249, 152, 108, 155, 154, 9, 131, 124, 62, 128, 201, 42, 101, 2]),
        BigUint::from_bytes_le(&[55, 207, 182, 0, 167, 229, 205, 239, 86, 11, 108, 92, 155, 57, 90, 72, 250, 3]),
        BigUint::from_bytes_le(&[180, 135, 160, 129, 238, 214, 248, 9, 217, 61, 156, 142, 107, 226, 22, 101, 18, 4]),
        BigUint::from_bytes_le(&[228, 235, 204, 165, 78, 112, 154, 62, 126, 239, 253, 19, 250, 129, 3, 108, 42, 4]),
        BigUint::from_bytes_le(&[80, 255, 21, 211, 1, 29, 46, 235, 193, 216, 208, 203, 97, 23, 140, 128, 220, 5]),
        BigUint::from_bytes_le(&[57, 20, 101, 106, 195, 129, 82, 229, 111, 211, 185, 230, 138, 206, 100, 112, 246, 5]),
        BigUint::from_bytes_le(&[176, 244, 226, 42, 117, 9, 57, 27, 82, 94, 174, 252, 158, 64, 7, 112, 248, 5]),
        BigUint::from_bytes_le(&[208, 111, 93, 230, 50, 244, 143, 96, 50, 86, 182, 192, 132, 241, 80, 118, 17, 6]),
        BigUint::from_bytes_le(&[91, 117, 75, 78, 37, 19, 4, 48, 52, 50, 167, 123, 109, 15, 219, 101, 43, 6]),
        BigUint::from_bytes_le(&[143, 251, 233, 109, 179, 188, 75, 161, 29, 47, 34, 250, 18, 183, 205, 134, 35, 8]),
        BigUint::from_bytes_le(&[41, 153, 205, 99, 159, 142, 247, 203, 250, 216, 192, 110, 83, 165, 204, 13, 129, 51]),
        BigUint::from_bytes_le(&[158, 251, 114, 95, 50, 95, 242, 40, 36, 5, 173, 83, 39, 123, 155, 67, 231, 38, 5]),
        BigUint::from_bytes_le(&[48, 9, 128, 251, 150, 241, 186, 197, 205, 173, 183, 226, 255, 56, 105, 22, 113, 176, 35]),
        BigUint::from_bytes_le(&[49, 9, 128, 251, 150, 241, 186, 197, 205, 173, 183, 226, 255, 56, 105, 22, 113, 176, 35]),
        BigUint::from_bytes_le(&[22, 45, 1, 197, 27, 2, 133, 8, 117, 51, 50, 204, 87, 243, 89, 60, 139, 47, 66]),
        BigUint::from_bytes_le(&[23, 45, 1, 197, 27, 2, 133, 8, 117, 51, 50, 204, 87, 243, 89, 60, 139, 47, 66]),
        BigUint::from_bytes_le(&[61, 141, 100, 91, 73, 251, 215, 130, 140, 201, 225, 26, 89, 192, 34, 108, 70, 96, 181, 1]),
        BigUint::from_bytes_le(&[220, 132, 37, 220, 49, 191, 97, 11, 93, 177, 30, 248, 49, 69, 152, 138, 207, 19, 144, 2]),
        BigUint::from_bytes_le(&[166, 34, 41, 89, 224, 242, 28, 4, 216, 252, 110, 63, 69, 253, 221, 247, 217, 221, 45, 155, 21]),
        BigUint::from_bytes_le(&[229, 14, 137, 234, 210, 151, 97, 13, 142, 100, 224, 82, 157, 149, 167, 232, 252, 205, 251, 5, 22]),
        BigUint::from_bytes_le(&[186, 205, 90, 83, 79, 141, 190, 119, 35, 216, 162, 208, 119, 170, 116, 74, 3, 131, 95, 248, 146, 14]),
        BigUint::from_bytes_le(&[34, 187, 84, 178, 125, 27, 240, 165, 65, 70, 176, 210, 231, 8, 138, 155, 84, 169, 118, 153, 42, 245]),
        BigUint::from_bytes_le(&[184, 169, 69, 1, 233, 227, 215, 251, 185, 139, 170, 220, 55, 101, 92, 8, 90, 83, 36, 163, 87, 249]),
        BigUint::from_bytes_le(&[2, 105, 183, 143, 87, 79, 33, 173, 10, 234, 133, 175, 135, 22, 159, 229, 36, 29, 253, 166, 226, 90, 122]),
        BigUint::from_bytes_le(&[62, 155, 26, 189, 143, 186, 64, 38, 215, 99, 161, 36, 147, 82, 38, 197, 72, 80, 133, 15, 66, 43, 123]),
        BigUint::from_bytes_le(&[222, 174, 102, 219, 75, 58, 221, 197, 157, 195, 84, 36, 163, 221, 14, 148, 142, 166, 250, 223, 205, 248, 123]),
        BigUint::from_bytes_le(&[80, 121, 34, 165, 183, 58, 118, 71, 49, 231, 212, 205, 106, 61, 35, 251, 126, 240, 163, 25, 63, 142, 125]),
        BigUint::from_bytes_le(&[169, 141, 48, 218, 254, 48, 253, 50, 235, 245, 56, 33, 155, 193, 177, 58, 188, 104, 23, 70, 85, 144, 161]),
        BigUint::from_bytes_le(&[224, 162, 176, 180, 49, 124, 52, 200, 31, 76, 129, 197, 146, 189, 42, 149, 200, 111, 31, 126, 27, 91, 162]),
        BigUint::from_bytes_le(&[109, 169, 114, 144, 93, 160, 183, 42, 11, 103, 62, 166, 232, 142, 250, 41, 242, 79, 60, 238, 231, 93, 162]),
        BigUint::from_bytes_le(&[235, 214, 44, 130, 9, 95, 195, 57, 30, 10, 9, 200, 100, 82, 89, 37, 205, 6, 57, 178, 191, 37, 163]),
        BigUint::from_bytes_le(&[28, 106, 172, 195, 99, 9, 68, 147, 156, 35, 123, 214, 68, 140, 117, 110, 201, 185, 98, 89, 113, 240, 163]),
        BigUint::from_bytes_le(&[224, 45, 10, 134, 75, 39, 125, 11, 82, 130, 16, 25, 86, 207, 23, 231, 34, 93, 140, 147, 241, 37, 203]),
        BigUint::from_bytes_le(&[230, 169, 218, 145, 157, 139, 82, 77, 185, 191, 235, 166, 151, 213, 178, 109, 205, 97, 234, 87, 194, 237, 203]),
        BigUint::from_bytes_le(&[149, 187, 250, 102, 70, 16, 247, 80, 223, 19, 206, 164, 127, 120, 245, 136, 223, 31, 53, 125, 126, 83, 206]),
        BigUint::from_bytes_le(&[94, 141, 248, 163, 190, 66, 229, 118, 211, 249, 107, 192, 218, 99, 211, 45, 28, 107, 159, 14, 167, 29, 67, 1]),
        BigUint::from_bytes_le(&[128, 249, 118, 38, 18, 122, 31, 224, 189, 111, 77, 133, 71, 248, 83, 31, 210, 194, 176, 213, 134, 133, 87, 230, 87]),
        BigUint::from_bytes_le(&[253, 219, 99, 144, 148, 10, 182, 187, 122, 104, 196, 66, 183, 89, 161, 246, 199, 215, 98, 161, 225, 128, 21, 99, 144, 3]),
        BigUint::from_bytes_le(&[31, 176, 91, 98, 54, 56, 202, 22, 31, 185, 18, 16, 228, 29, 69, 229, 27, 18, 166, 217, 58, 38, 33, 171, 254, 245, 2]),
        BigUint::from_bytes_le(&[90, 46, 80, 144, 105, 136, 29, 165, 33, 68, 202, 222, 145, 151, 201, 139, 77, 169, 252, 26, 84, 82, 53, 140, 70, 205, 215, 62, 23]),
        BigUint::from_bytes_le(&[34, 208, 145, 113, 5, 74, 67, 162, 241, 116, 242, 172, 254, 158, 175, 218, 203, 137, 191, 65, 70, 0, 76, 61, 222, 1, 229, 237, 42, 0, 1]),
    ]
}
/// All base-14 Narcissistic Number store as base-10
///
/// Download from: http://oeis.org/A161952/b161952.txt
pub fn base15() -> Vec<BigUint> {
    vec![
        BigUint::from_bytes_le(&[1]),
        BigUint::from_bytes_le(&[2]),
        BigUint::from_bytes_le(&[3]),
        BigUint::from_bytes_le(&[4]),
        BigUint::from_bytes_le(&[5]),
        BigUint::from_bytes_le(&[6]),
        BigUint::from_bytes_le(&[7]),
        BigUint::from_bytes_le(&[8]),
        BigUint::from_bytes_le(&[9]),
        BigUint::from_bytes_le(&[10]),
        BigUint::from_bytes_le(&[11]),
        BigUint::from_bytes_le(&[12]),
        BigUint::from_bytes_le(&[13]),
        BigUint::from_bytes_le(&[14]),
        BigUint::from_bytes_le(&[113]),
        BigUint::from_bytes_le(&[128]),
        BigUint::from_bytes_le(&[195, 10]),
        BigUint::from_bytes_le(&[236, 11]),
        BigUint::from_bytes_le(&[195, 19]),
        BigUint::from_bytes_le(&[178, 191]),
        BigUint::from_bytes_le(&[193, 191]),
        BigUint::from_bytes_le(&[46, 231, 5]),
        BigUint::from_bytes_le(&[255, 80, 6]),
        BigUint::from_bytes_le(&[14, 231, 7]),
        BigUint::from_bytes_le(&[212, 57, 232]),
        BigUint::from_bytes_le(&[21, 229, 27, 1]),
        BigUint::from_bytes_le(&[185, 249, 67, 2]),
        BigUint::from_bytes_le(&[20, 155, 99, 2]),
        BigUint::from_bytes_le(&[151, 22, 103, 2]),
        BigUint::from_bytes_le(&[131, 153, 111, 2]),
        BigUint::from_bytes_le(&[114, 55, 213, 2]),
        BigUint::from_bytes_le(&[60, 213, 247, 5]),
        BigUint::from_bytes_le(&[61, 213, 247, 5]),
        BigUint::from_bytes_le(&[188, 213, 247, 5]),
        BigUint::from_bytes_le(&[224, 204, 53, 6]),
        BigUint::from_bytes_le(&[244, 67, 73, 6]),
        BigUint::from_bytes_le(&[245, 67, 73, 6]),
        BigUint::from_bytes_le(&[164, 212, 14, 7]),
        BigUint::from_bytes_le(&[226, 246, 148, 8]),
        BigUint::from_bytes_le(&[2, 100, 6, 12]),
        BigUint::from_bytes_le(&[3, 100, 6, 12]),
        BigUint::from_bytes_le(&[69, 235, 78, 75]),
        BigUint::from_bytes_le(&[161, 94, 207, 111]),
        BigUint::from_bytes_le(&[73, 23, 198, 114, 1]),
        BigUint::from_bytes_le(&[229, 164, 165, 78, 6]),
        BigUint::from_bytes_le(&[6, 10, 146, 145, 47]),
        BigUint::from_bytes_le(&[188, 118, 9, 29, 61, 4]),
        BigUint::from_bytes_le(&[85, 124, 17, 118, 52, 7]),
        BigUint::from_bytes_le(&[202, 184, 151, 116, 127, 147]),
        BigUint::from_bytes_le(&[226, 25, 202, 15, 93, 118, 1]),
        BigUint::from_bytes_le(&[87, 23, 132, 97, 65, 161, 1]),
        BigUint::from_bytes_le(&[208, 112, 131, 158, 137, 49, 3]),
        BigUint::from_bytes_le(&[90, 192, 153, 173, 113, 75, 3]),
        BigUint::from_bytes_le(&[72, 217, 204, 115, 51, 24, 6]),
        BigUint::from_bytes_le(&[48, 18, 225, 237, 67, 24, 6]),
        BigUint::from_bytes_le(&[156, 136, 210, 241, 111, 223, 98]),
        BigUint::from_bytes_le(&[135, 115, 223, 57, 192, 139, 217, 9]),
        BigUint::from_bytes_le(&[5, 25, 148, 91, 0, 98, 7, 66]),
        BigUint::from_bytes_le(&[207, 114, 42, 182, 134, 97, 93, 199, 56]),
        BigUint::from_bytes_le(&[2, 100, 125, 46, 113, 197, 248, 54, 83]),
        BigUint::from_bytes_le(&[133, 126, 185, 241, 111, 63, 103, 97, 71, 1]),
        BigUint::from_bytes_le(&[209, 188, 147, 218, 20, 0, 218, 85, 96, 1]),
        BigUint::from_bytes_le(&[179, 146, 235, 236, 77, 151, 65, 3, 154, 1]),
        BigUint::from_bytes_le(&[187, 166, 79, 217, 2, 244, 212, 202, 165, 1]),
        BigUint::from_bytes_le(&[246, 45, 198, 138, 79, 75, 123, 194, 234, 1]),
        BigUint::from_bytes_le(&[106, 83, 12, 192, 88, 138, 130, 47, 247, 1]),
        BigUint::from_bytes_le(&[105, 158, 21, 231, 122, 132, 172, 111, 250, 1]),
        BigUint::from_bytes_le(&[124, 177, 41, 74, 200, 107, 234, 48, 5, 2]),
        BigUint::from_bytes_le(&[84, 139, 246, 172, 211, 210, 157, 54, 5, 2]),
        BigUint::from_bytes_le(&[48, 255, 254, 209, 54, 185, 12, 43, 136, 2]),
        BigUint::from_bytes_le(&[188, 131, 246, 212, 44, 155, 53, 230, 139, 2]),
        BigUint::from_bytes_le(&[56, 199, 197, 171, 50, 138, 210, 180, 15, 3]),
        BigUint::from_bytes_le(&[204, 191, 56, 77, 251, 43, 16, 148, 229, 3]),
        BigUint::from_bytes_le(&[198, 2, 216, 149, 250, 212, 241, 34, 249, 3]),
        BigUint::from_bytes_le(&[106, 83, 124, 40, 218, 30, 182, 3, 145, 4]),
        BigUint::from_bytes_le(&[107, 229, 114, 200, 16, 91, 89, 159, 89, 45]),
        BigUint::from_bytes_le(&[206, 29, 231, 227, 68, 38, 81, 69, 16, 105]),
        BigUint::from_bytes_le(&[1, 120, 95, 23, 253, 48, 254, 239, 198, 3, 1]),
        BigUint::from_bytes_le(&[184, 76, 37, 9, 220, 108, 252, 254, 129, 98, 1]),
        BigUint::from_bytes_le(&[145, 151, 201, 130, 100, 144, 47, 241, 180, 60, 4]),
        BigUint::from_bytes_le(&[124, 80, 144, 149, 59, 143, 125, 45, 224, 200, 30]),
        BigUint::from_bytes_le(&[164, 206, 189, 180, 81, 126, 99, 253, 247, 198, 200, 1]),
        BigUint::from_bytes_le(&[205, 255, 44, 56, 192, 227, 152, 37, 184, 29, 212, 3]),
        BigUint::from_bytes_le(&[105, 2, 143, 199, 86, 181, 102, 93, 24, 82, 68, 168]),
        BigUint::from_bytes_le(&[4, 82, 113, 39, 208, 154, 114, 162, 166, 128, 16, 175]),
        BigUint::from_bytes_le(&[188, 227, 180, 16, 122, 46, 93, 230, 191, 144, 187, 191]),
        BigUint::from_bytes_le(&[189, 227, 180, 16, 122, 46, 93, 230, 191, 144, 187, 191]),
        BigUint::from_bytes_le(&[171, 151, 192, 119, 117, 12, 107, 12, 158, 111, 73, 198]),
        BigUint::from_bytes_le(&[252, 213, 19, 157, 108, 13, 90, 142, 185, 69, 250, 37, 1]),
        BigUint::from_bytes_le(&[170, 195, 28, 205, 181, 16, 23, 238, 125, 93, 85, 58, 1]),
        BigUint::from_bytes_le(&[95, 129, 177, 197, 36, 183, 5, 114, 159, 54, 157, 87, 1]),
        BigUint::from_bytes_le(&[225, 31, 74, 108, 99, 208, 77, 247, 139, 222, 239, 103, 1]),
        BigUint::from_bytes_le(&[140, 230, 37, 123, 190, 210, 86, 104, 21, 158, 214, 189, 1]),
        BigUint::from_bytes_le(&[86, 105, 251, 47, 50, 103, 87, 211, 188, 102, 191, 7, 3]),
        BigUint::from_bytes_le(&[20, 150, 223, 167, 112, 253, 56, 238, 202, 128, 114, 28, 8]),
        BigUint::from_bytes_le(&[122, 135, 110, 41, 46, 75, 149, 42, 64, 201, 80, 119, 25]),
        BigUint::from_bytes_le(&[239, 237, 169, 173, 89, 213, 131, 114, 45, 202, 237, 120, 249, 86, 1]),
        BigUint::from_bytes_le(&[218, 220, 71, 178, 198, 106, 60, 15, 143, 87, 144, 140, 140, 32, 14]),
        BigUint::from_bytes_le(&[23, 109, 115, 127, 201, 177, 55, 48, 78, 204, 255, 2, 203, 23, 47]),
        BigUint::from_bytes_le(&[24, 59, 50, 49, 192, 117, 108, 245, 85, 44, 71, 196, 147, 139, 79]),
        BigUint::from_bytes_le(&[25, 59, 50, 49, 192, 117, 108, 245, 85, 44, 71, 196, 147, 139, 79]),
        BigUint::from_bytes_le(&[144, 91, 86, 90, 52, 145, 41, 95, 171, 72, 226, 110, 121, 24, 80]),
        BigUint::from_bytes_le(&[41, 164, 175, 186, 194, 248, 44, 252, 179, 220, 160, 155, 155, 183, 91]),
        BigUint::from_bytes_le(&[35, 28, 184, 236, 50, 38, 35, 138, 5, 139, 102, 41, 0, 65, 93]),
        BigUint::from_bytes_le(&[202, 246, 95, 248, 0, 77, 193, 184, 181, 138, 218, 210, 185, 96, 139]),
        BigUint::from_bytes_le(&[20, 27, 125, 166, 145, 220, 80, 41, 221, 96, 134, 137, 248, 82, 151]),
        BigUint::from_bytes_le(&[94, 125, 245, 74, 121, 233, 45, 241, 143, 35, 240, 100, 106, 92, 151]),
        BigUint::from_bytes_le(&[253, 77, 16, 15, 91, 17, 168, 131, 228, 247, 169, 78, 63, 136, 152]),
        BigUint::from_bytes_le(&[40, 40, 144, 134, 51, 123, 131, 62, 138, 10, 223, 17, 134, 18, 198]),
        BigUint::from_bytes_le(&[57, 42, 60, 198, 148, 58, 249, 154, 66, 192, 132, 46, 57, 155, 210]),
        BigUint::from_bytes_le(&[130, 248, 26, 209, 114, 110, 162, 23, 143, 165, 251, 127, 208, 54, 223]),
        BigUint::from_bytes_le(&[152, 66, 122, 235, 13, 15, 219, 47, 50, 46, 28, 46, 117, 150, 83, 1]),
        BigUint::from_bytes_le(&[142, 253, 142, 22, 84, 126, 184, 83, 13, 57, 18, 187, 182, 151, 14, 5]),
        BigUint::from_bytes_le(&[13, 253, 113, 84, 125, 211, 146, 194, 93, 244, 114, 132, 214, 218, 127, 7]),
        BigUint::from_bytes_le(&[13, 115, 62, 169, 155, 59, 59, 172, 242, 70, 109, 61, 147, 224, 133, 8]),
        BigUint::from_bytes_le(&[144, 141, 32, 243, 241, 255, 96, 87, 80, 154, 102, 165, 152, 111, 103, 15]),
        BigUint::from_bytes_le(&[153, 70, 40, 92, 244, 191, 105, 227, 191, 140, 121, 14, 248, 110, 170, 179, 5]),
        BigUint::from_bytes_le(&[57, 2, 132, 210, 123, 105, 245, 71, 6, 74, 166, 148, 113, 142, 124, 148, 6]),
        BigUint::from_bytes_le(&[24, 216, 6, 77, 32, 81, 144, 44, 60, 58, 96, 251, 103, 84, 101, 171, 120]),
        BigUint::from_bytes_le(&[51, 148, 212, 7, 71, 162, 58, 72, 32, 27, 113, 6, 109, 122, 113, 48, 135, 2]),
        BigUint::from_bytes_le(&[225, 68, 112, 194, 39, 25, 165, 195, 57, 254, 76, 245, 54, 85, 72, 185, 123, 4]),
        BigUint::from_bytes_le(&[144, 113, 237, 81, 148, 30, 11, 143, 64, 31, 196, 23, 113, 175, 93, 203, 6, 7]),
        BigUint::from_bytes_le(&[96, 40, 100, 88, 169, 182, 174, 147, 174, 146, 251, 103, 114, 164, 97, 155, 178, 12]),
        BigUint::from_bytes_le(&[36, 59, 118, 128, 213, 117, 186, 91, 248, 49, 180, 252, 239, 201, 201, 65, 127, 29]),
        BigUint::from_bytes_le(&[217, 196, 241, 58, 39, 67, 63, 184, 51, 135, 59, 63, 16, 91, 253, 141, 41, 33]),
        BigUint::from_bytes_le(&[167, 162, 143, 227, 19, 251, 228, 0, 22, 106, 37, 213, 196, 56, 97, 138, 118, 33]),
        BigUint::from_bytes_le(&[199, 172, 35, 208, 247, 0, 91, 60, 41, 35, 169, 240, 157, 85, 250, 185, 240, 36]),
        BigUint::from_bytes_le(&[100, 221, 240, 120, 198, 225, 46, 63, 181, 108, 197, 28, 110, 58, 245, 151, 240, 62]),
        BigUint::from_bytes_le(&[126, 66, 119, 155, 29, 59, 213, 114, 162, 254, 240, 254, 56, 129, 228, 236, 110, 66]),
        BigUint::from_bytes_le(&[128, 33, 223, 23, 59, 46, 168, 111, 154, 216, 203, 55, 142, 248, 148, 243, 132, 66]),
        BigUint::from_bytes_le(&[189, 14, 236, 38, 132, 225, 174, 168, 82, 70, 27, 229, 42, 146, 101, 184, 219, 89]),
        BigUint::from_bytes_le(&[13, 91, 16, 115, 53, 13, 58, 166, 154, 72, 44, 60, 81, 138, 2, 167, 14, 90]),
        BigUint::from_bytes_le(&[169, 24, 214, 159, 87, 87, 17, 174, 9, 45, 53, 171, 220, 124, 165, 234, 188, 93]),
        BigUint::from_bytes_le(&[246, 22, 60, 195, 136, 150, 73, 50, 161, 242, 3, 222, 118, 173, 214, 24, 229, 95]),
        BigUint::from_bytes_le(&[241, 160, 144, 111, 152, 140, 86, 24, 62, 188, 235, 43, 192, 214, 143, 249, 140, 146]),
        BigUint::from_bytes_le(&[242, 160, 144, 111, 152, 140, 86, 24, 62, 188, 235, 43, 192, 214, 143, 249, 140, 146]),
        BigUint::from_bytes_le(&[53, 191, 41, 210, 53, 158, 158, 227, 237, 165, 208, 40, 241, 163, 240, 40, 206, 20, 2]),
        BigUint::from_bytes_le(&[240, 80, 133, 74, 18, 198, 116, 145, 3, 46, 156, 114, 208, 193, 60, 248, 148, 102, 8]),
        BigUint::from_bytes_le(&[145, 69, 208, 124, 111, 48, 23, 63, 195, 166, 80, 58, 39, 235, 160, 62, 125, 224, 107, 1]),
        BigUint::from_bytes_le(&[98, 83, 26, 209, 199, 74, 164, 250, 182, 255, 42, 125, 219, 51, 139, 226, 26, 172, 160, 51]),
        BigUint::from_bytes_le(&[154, 26, 100, 92, 171, 54, 186, 9, 50, 54, 38, 173, 178, 156, 200, 167, 131, 92, 120, 105]),
        BigUint::from_bytes_le(&[71, 210, 57, 183, 90, 191, 175, 236, 88, 201, 175, 149, 228, 132, 224, 18, 81, 5, 128, 243, 27]),
        BigUint::from_bytes_le(&[162, 57, 138, 146, 78, 142, 117, 1, 213, 47, 21, 141, 214, 207, 106, 78, 1, 98, 52, 11, 40]),
        BigUint::from_bytes_le(&[163, 57, 138, 146, 78, 142, 117, 1, 213, 47, 21, 141, 214, 207, 106, 78, 1, 98, 52, 11, 40]),
        BigUint::from_bytes_le(&[58, 22, 101, 61, 78, 101, 15, 151, 81, 232, 46, 145, 184, 213, 236, 42, 171, 149, 23, 46, 42]),
        BigUint::from_bytes_le(&[231, 237, 209, 104, 20, 121, 211, 140, 212, 73, 52, 230, 216, 152, 207, 170, 210, 197, 144, 43, 53]),
        BigUint::from_bytes_le(&[131, 160, 51, 140, 153, 10, 44, 193, 17, 194, 51, 97, 186, 232, 116, 124, 30, 114, 35, 182, 53]),
        BigUint::from_bytes_le(&[191, 241, 187, 168, 0, 151, 111, 188, 246, 5, 141, 129, 162, 213, 44, 199, 66, 153, 180, 97, 67]),
        BigUint::from_bytes_le(&[0, 247, 151, 179, 22, 112, 131, 183, 98, 83, 11, 47, 42, 45, 157, 109, 159, 34, 187, 34, 48, 2]),
        BigUint::from_bytes_le(&[128, 66, 170, 8, 220, 91, 86, 246, 96, 131, 26, 188, 187, 155, 143, 208, 52, 114, 229, 26, 253, 2]),
        BigUint::from_bytes_le(&[47, 128, 213, 104, 112, 88, 147, 74, 55, 163, 183, 76, 224, 11, 146, 49, 163, 87, 205, 247, 85, 22]),
        BigUint::from_bytes_le(&[254, 255, 237, 183, 241, 42, 165, 185, 115, 254, 250, 146, 237, 152, 43, 96, 35, 71, 5, 32, 70, 31]),
        BigUint::from_bytes_le(&[228, 222, 166, 166, 40, 70, 222, 62, 1, 222, 44, 131, 47, 72, 39, 52, 167, 203, 80, 61, 219, 206, 2]),
        BigUint::from_bytes_le(&[229, 78, 240, 89, 86, 50, 76, 40, 133, 171, 28, 228, 180, 90, 130, 51, 10, 254, 78, 225, 94, 112, 4]),
        BigUint::from_bytes_le(&[135, 1, 0, 0, 148, 140, 161, 54, 52, 248, 151, 25, 247, 90, 204, 85, 216, 243, 128, 18, 219, 31, 16]),
        BigUint::from_bytes_le(&[248, 235, 59, 47, 200, 24, 91, 99, 93, 220, 116, 23, 245, 141, 1, 169, 242, 33, 65, 185, 214, 93, 16]),
        BigUint::from_bytes_le(&[150, 101, 46, 2, 225, 83, 203, 42, 91, 95, 240, 194, 78, 194, 75, 22, 42, 207, 12, 246, 103, 56, 225]),
        BigUint::from_bytes_le(&[75, 52, 248, 249, 172, 55, 200, 253, 242, 160, 165, 121, 237, 100, 181, 55, 47, 215, 223, 100, 142, 88, 247, 11]),
        BigUint::from_bytes_le(&[66, 68, 172, 251, 235, 10, 200, 60, 223, 82, 164, 195, 78, 92, 148, 36, 80, 126, 191, 121, 246, 20, 248, 11]),
        BigUint::from_bytes_le(&[71, 120, 225, 76, 52, 101, 140, 231, 211, 221, 107, 108, 6, 12, 85, 37, 202, 185, 96, 122, 1, 125, 70, 12]),
        BigUint::from_bytes_le(&[249, 172, 90, 158, 157, 60, 175, 146, 107, 17, 239, 50, 252, 188, 247, 175, 215, 56, 102, 147, 230, 68, 71, 12]),
        BigUint::from_bytes_le(&[66, 21, 134, 81, 255, 51, 39, 160, 195, 36, 3, 175, 12, 214, 32, 220, 205, 220, 59, 73, 8, 173, 189, 12]),
        BigUint::from_bytes_le(&[6, 213, 162, 104, 14, 250, 10, 20, 197, 224, 193, 171, 157, 144, 205, 84, 137, 9, 24, 199, 65, 128, 190, 12]),
        BigUint::from_bytes_le(&[27, 32, 2, 122, 250, 92, 138, 149, 160, 232, 227, 83, 191, 180, 1, 185, 96, 153, 57, 249, 146, 98, 5, 18]),
        BigUint::from_bytes_le(&[75, 181, 117, 85, 29, 223, 56, 174, 54, 221, 0, 41, 237, 138, 254, 169, 184, 98, 122, 222, 164, 39, 6, 18]),
        BigUint::from_bytes_le(&[111, 76, 225, 76, 200, 11, 215, 226, 46, 35, 199, 7, 157, 112, 37, 197, 246, 127, 1, 91, 39, 93, 85, 18]),
        BigUint::from_bytes_le(&[112, 187, 69, 76, 232, 103, 13, 104, 71, 138, 153, 147, 158, 94, 53, 149, 176, 114, 131, 247, 255, 99, 235, 23]),
        BigUint::from_bytes_le(&[138, 167, 46, 187, 163, 123, 11, 225, 89, 36, 249, 142, 75, 216, 206, 61, 44, 97, 138, 96, 46, 161, 192, 30]),
        BigUint::from_bytes_le(&[185, 36, 15, 77, 13, 173, 33, 231, 64, 213, 2, 147, 72, 12, 5, 154, 245, 250, 247, 207, 10, 139, 244, 251]),
        BigUint::from_bytes_le(&[31, 38, 25, 47, 210, 62, 83, 25, 232, 179, 14, 49, 221, 249, 254, 49, 60, 25, 178, 25, 125, 133, 250, 255]),
        BigUint::from_bytes_le(&[85, 147, 151, 50, 155, 244, 139, 149, 172, 252, 181, 94, 172, 193, 151, 60, 176, 191, 29, 72, 94, 164, 224, 140, 13]),
        BigUint::from_bytes_le(&[253, 60, 36, 251, 43, 6, 24, 118, 145, 193, 173, 62, 43, 82, 102, 172, 62, 201, 157, 72, 203, 0, 46, 44, 14]),
        BigUint::from_bytes_le(&[185, 199, 246, 27, 125, 75, 149, 171, 22, 242, 168, 65, 164, 94, 95, 91, 194, 118, 156, 0, 219, 34, 65, 144, 143, 17]),
        BigUint::from_bytes_le(&[82, 182, 31, 245, 139, 174, 204, 10, 8, 148, 88, 23, 171, 244, 134, 151, 219, 122, 64, 178, 165, 187, 134, 52, 231, 17]),
        BigUint::from_bytes_le(&[86, 40, 173, 126, 26, 142, 40, 222, 238, 35, 19, 148, 65, 133, 116, 171, 191, 236, 118, 207, 164, 153, 182, 35, 197, 200]),
        BigUint::from_bytes_le(&[151, 158, 72, 80, 241, 217, 218, 149, 183, 202, 38, 76, 234, 40, 201, 89, 158, 181, 215, 160, 171, 37, 138, 136, 146, 31, 8]),
        BigUint::from_bytes_le(&[149, 122, 192, 134, 200, 164, 20, 150, 81, 177, 212, 111, 193, 69, 107, 206, 24, 97, 121, 146, 72, 66, 151, 79, 69, 174, 10]),
        BigUint::from_bytes_le(&[17, 138, 149, 150, 116, 188, 98, 162, 174, 95, 239, 170, 69, 167, 16, 207, 248, 4, 117, 7, 111, 24, 118, 52, 50, 186, 10]),
        BigUint::from_bytes_le(&[97, 102, 175, 10, 25, 251, 144, 25, 24, 170, 217, 11, 235, 113, 250, 141, 74, 91, 157, 200, 116, 48, 226, 193, 72, 197, 10]),
        BigUint::from_bytes_le(&[85, 76, 253, 85, 70, 210, 210, 228, 20, 180, 239, 135, 232, 86, 44, 240, 98, 124, 58, 82, 65, 31, 184, 224, 102, 84, 13]),
        BigUint::from_bytes_le(&[27, 185, 253, 7, 65, 106, 231, 151, 206, 52, 168, 230, 241, 75, 176, 12, 52, 162, 139, 191, 53, 78, 113, 113, 46, 171, 18]),
        BigUint::from_bytes_le(&[165, 69, 123, 24, 253, 146, 24, 61, 10, 159, 242, 146, 85, 34, 5, 180, 132, 218, 44, 6, 127, 11, 56, 0, 12, 194, 18]),
        BigUint::from_bytes_le(&[152, 9, 230, 135, 87, 112, 100, 56, 172, 32, 157, 171, 80, 1, 45, 232, 73, 141, 211, 195, 229, 176, 126, 245, 91, 153, 150]),
        BigUint::from_bytes_le(&[236, 25, 151, 158, 212, 59, 164, 40, 123, 1, 231, 74, 186, 107, 170, 126, 9, 241, 146, 79, 112, 7, 209, 236, 180, 71, 79, 12]),
        BigUint::from_bytes_le(&[251, 167, 25, 170, 83, 111, 17, 234, 112, 214, 36, 158, 156, 7, 202, 191, 230, 246, 75, 13, 144, 28, 81, 34, 241, 231, 76, 114]),
        BigUint::from_bytes_le(&[198, 239, 170, 206, 36, 37, 90, 61, 80, 26, 149, 40, 68, 73, 168, 163, 23, 166, 126, 235, 27, 76, 209, 200, 238, 247, 12, 143]),
        BigUint::from_bytes_le(&[2, 34, 95, 231, 190, 79, 179, 63, 219, 27, 221, 184, 245, 28, 35, 125, 225, 8, 51, 90, 179, 13, 165, 113, 133, 249, 81, 73, 6]),
        BigUint::from_bytes_le(&[120, 177, 234, 184, 184, 162, 133, 88, 96, 57, 131, 86, 63, 113, 48, 51, 241, 202, 151, 1, 46, 143, 88, 124, 200, 36, 251, 41, 110]),
        BigUint::from_bytes_le(&[138, 206, 205, 155, 120, 197, 192, 31, 33, 210, 46, 50, 101, 229, 131, 164, 222, 239, 244, 187, 45, 243, 143, 240, 89, 33, 96, 136, 247, 5]),
        BigUint::from_bytes_le(&[130, 63, 123, 99, 49, 182, 71, 196, 211, 221, 197, 87, 194, 161, 225, 84, 149, 80, 20, 86, 72, 189, 65, 90, 141, 85, 146, 228, 250, 5]),
        BigUint::from_bytes_le(&[146, 34, 174, 141, 246, 200, 151, 209, 21, 106, 190, 102, 71, 190, 79, 191, 77, 76, 249, 153, 163, 1, 75, 227, 246, 47, 38, 26, 254, 5]),
        BigUint::from_bytes_le(&[217, 70, 24, 255, 9, 165, 147, 61, 43, 118, 4, 201, 224, 153, 201, 243, 183, 15, 119, 131, 119, 149, 206, 104, 63, 114, 54, 26, 254, 5]),
        BigUint::from_bytes_le(&[82, 61, 132, 235, 144, 36, 79, 51, 189, 252, 52, 93, 181, 133, 11, 180, 27, 104, 204, 126, 149, 225, 28, 211, 202, 133, 61, 159, 4, 6]),
        BigUint::from_bytes_le(&[199, 213, 43, 200, 59, 136, 183, 229, 252, 159, 191, 46, 17, 60, 8, 30, 80, 141, 215, 42, 106, 248, 95, 232, 147, 84, 222, 89, 27, 117]),
        BigUint::from_bytes_le(&[200, 213, 43, 200, 59, 136, 183, 229, 252, 159, 191, 46, 17, 60, 8, 30, 80, 141, 215, 42, 106, 248, 95, 232, 147, 84, 222, 89, 27, 117]),
        BigUint::from_bytes_le(&[200, 205, 115, 193, 241, 117, 140, 212, 238, 96, 54, 74, 227, 76, 146, 145, 138, 102, 227, 138, 184, 69, 15, 250, 201, 150, 194, 44, 63, 134]),
        BigUint::from_bytes_le(&[41, 206, 201, 66, 232, 75, 110, 204, 127, 144, 157, 146, 124, 192, 154, 146, 244, 221, 153, 156, 181, 46, 208, 88, 229, 184, 61, 208, 7, 31, 84, 191, 3]),
        BigUint::from_bytes_le(&[42, 206, 201, 66, 232, 75, 110, 204, 127, 144, 157, 146, 124, 192, 154, 146, 244, 221, 153, 156, 181, 46, 208, 88, 229, 184, 61, 208, 7, 31, 84, 191, 3]),
        BigUint::from_bytes_le(&[163, 130, 112, 209, 24, 159, 180, 101, 121, 146, 209, 85, 53, 100, 227, 189, 102, 155, 67, 222, 48, 248, 224, 208, 164, 244, 88, 218, 152, 50, 74, 192, 3]),
        BigUint::from_bytes_le(&[7, 175, 231, 112, 251, 106, 97, 178, 83, 190, 204, 0, 29, 127, 66, 219, 223, 176, 182, 77, 234, 29, 252, 219, 85, 241, 69, 200, 33, 196, 49, 194, 3]),
        BigUint::from_bytes_le(&[56, 208, 66, 187, 97, 125, 99, 152, 172, 169, 156, 152, 179, 96, 153, 245, 250, 29, 40, 39, 11, 9, 248, 174, 213, 72, 204, 147, 182, 5, 155, 76, 4]),
        BigUint::from_bytes_le(&[57, 208, 66, 187, 97, 125, 99, 152, 172, 169, 156, 152, 179, 96, 153, 245, 250, 29, 40, 39, 11, 9, 248, 174, 213, 72, 204, 147, 182, 5, 155, 76, 4]),
    ]
}
/// All base-16 Narcissistic Number store as base-10
///
/// Download from: http://oeis.org/A161953/b161953.txt
pub fn base16() -> Vec<BigUint> {
    vec![
        BigUint::from_bytes_le(&[1]),
        BigUint::from_bytes_le(&[2]),
        BigUint::from_bytes_le(&[3]),
        BigUint::from_bytes_le(&[4]),
        BigUint::from_bytes_le(&[5]),
        BigUint::from_bytes_le(&[6]),
        BigUint::from_bytes_le(&[7]),
        BigUint::from_bytes_le(&[8]),
        BigUint::from_bytes_le(&[9]),
        BigUint::from_bytes_le(&[10]),
        BigUint::from_bytes_le(&[11]),
        BigUint::from_bytes_le(&[12]),
        BigUint::from_bytes_le(&[13]),
        BigUint::from_bytes_le(&[14]),
        BigUint::from_bytes_le(&[15]),
        BigUint::from_bytes_le(&[86, 1]),
        BigUint::from_bytes_le(&[115, 1]),
        BigUint::from_bytes_le(&[8, 2]),
        BigUint::from_bytes_le(&[72, 2]),
        BigUint::from_bytes_le(&[133, 2]),
        BigUint::from_bytes_le(&[165, 4]),
        BigUint::from_bytes_le(&[176, 5]),
        BigUint::from_bytes_le(&[177, 5]),
        BigUint::from_bytes_le(&[11, 6]),
        BigUint::from_bytes_le(&[75, 6]),
        BigUint::from_bytes_le(&[192, 8]),
        BigUint::from_bytes_le(&[193, 8]),
        BigUint::from_bytes_le(&[154, 9]),
        BigUint::from_bytes_le(&[169, 10]),
        BigUint::from_bytes_le(&[195, 10]),
        BigUint::from_bytes_le(&[168, 12]),
        BigUint::from_bytes_le(&[105, 14]),
        BigUint::from_bytes_le(&[160, 14]),
        BigUint::from_bytes_le(&[161, 14]),
        BigUint::from_bytes_le(&[210, 184]),
        BigUint::from_bytes_le(&[121, 53, 1]),
        BigUint::from_bytes_le(&[2, 183, 2]),
        BigUint::from_bytes_le(&[34, 183, 2]),
        BigUint::from_bytes_le(&[124, 160, 5]),
        BigUint::from_bytes_le(&[124, 164, 5]),
        BigUint::from_bytes_le(&[224, 0, 12]),
        BigUint::from_bytes_le(&[225, 0, 12]),
        BigUint::from_bytes_le(&[224, 4, 12]),
        BigUint::from_bytes_le(&[225, 4, 12]),
        BigUint::from_bytes_le(&[231, 96, 12]),
        BigUint::from_bytes_le(&[231, 100, 12]),
        BigUint::from_bytes_le(&[224, 128, 12]),
        BigUint::from_bytes_le(&[225, 128, 12]),
        BigUint::from_bytes_le(&[224, 132, 12]),
        BigUint::from_bytes_le(&[225, 132, 12]),
        BigUint::from_bytes_le(&[48, 224, 13]),
        BigUint::from_bytes_le(&[49, 224, 13]),
        BigUint::from_bytes_le(&[48, 228, 13]),
        BigUint::from_bytes_le(&[49, 228, 13]),
        BigUint::from_bytes_le(&[194, 183, 14]),
        BigUint::from_bytes_le(&[106, 176, 15]),
        BigUint::from_bytes_le(&[106, 180, 15]),
        BigUint::from_bytes_le(&[118, 194, 15]),
        BigUint::from_bytes_le(&[43, 228, 151]),
        BigUint::from_bytes_le(&[59, 216, 234]),
        BigUint::from_bytes_le(&[0, 194, 34, 2]),
        BigUint::from_bytes_le(&[1, 194, 34, 2]),
        BigUint::from_bytes_le(&[110, 114, 213, 13]),
        BigUint::from_bytes_le(&[180, 27, 229, 14]),
        BigUint::from_bytes_le(&[2, 77, 11, 7, 3]),
        BigUint::from_bytes_le(&[103, 168, 93, 75, 3]),
        BigUint::from_bytes_le(&[216, 8, 202, 139, 4]),
        BigUint::from_bytes_le(&[18, 122, 86, 14, 5]),
        BigUint::from_bytes_le(&[174, 74, 136, 169, 5]),
        BigUint::from_bytes_le(&[227, 104, 66, 12, 6]),
        BigUint::from_bytes_le(&[203, 117, 86, 242, 10]),
        BigUint::from_bytes_le(&[14, 160, 59, 206, 12]),
        BigUint::from_bytes_le(&[14, 162, 59, 206, 12]),
        BigUint::from_bytes_le(&[74, 56, 203, 111, 13]),
        BigUint::from_bytes_le(&[205, 206, 201, 115, 13]),
        BigUint::from_bytes_le(&[137, 45, 189, 27, 15]),
        BigUint::from_bytes_le(&[220, 215, 162, 87, 15]),
        BigUint::from_bytes_le(&[203, 108, 41, 166, 239]),
        BigUint::from_bytes_le(&[100, 139, 204, 193, 156, 35]),
        BigUint::from_bytes_le(&[215, 194, 67, 155, 200, 61]),
        BigUint::from_bytes_le(&[231, 214, 59, 193, 45, 105]),
        BigUint::from_bytes_le(&[182, 74, 77, 24, 167, 69, 1]),
        BigUint::from_bytes_le(&[180, 106, 77, 172, 197, 7, 2]),
        BigUint::from_bytes_le(&[213, 187, 228, 12, 208, 184, 5]),
        BigUint::from_bytes_le(&[219, 106, 231, 144, 35, 226, 6]),
        BigUint::from_bytes_le(&[219, 106, 231, 148, 35, 226, 6]),
        BigUint::from_bytes_le(&[53, 160, 28, 109, 242, 104, 8]),
        BigUint::from_bytes_le(&[147, 62, 191, 218, 200, 208, 12]),
        BigUint::from_bytes_le(&[85, 176, 152, 251, 226, 226, 13]),
        BigUint::from_bytes_le(&[107, 249, 7, 1, 148, 143, 96, 14]),
        BigUint::from_bytes_le(&[107, 249, 7, 65, 148, 143, 96, 14]),
        BigUint::from_bytes_le(&[196, 37, 192, 14, 171, 253, 226, 166]),
        BigUint::from_bytes_le(&[168, 218, 140, 6, 177, 135, 225, 71, 2]),
        BigUint::from_bytes_le(&[120, 82, 46, 218, 195, 59, 59, 108, 2]),
        BigUint::from_bytes_le(&[187, 88, 214, 173, 37, 26, 224, 198, 2]),
        BigUint::from_bytes_le(&[187, 88, 214, 173, 37, 26, 232, 198, 2]),
        BigUint::from_bytes_le(&[52, 78, 184, 228, 81, 5, 149, 85, 3]),
        BigUint::from_bytes_le(&[228, 150, 43, 193, 130, 142, 108, 147, 3]),
        BigUint::from_bytes_le(&[185, 14, 11, 22, 70, 137, 224, 212, 3]),
        BigUint::from_bytes_le(&[185, 14, 11, 22, 70, 137, 232, 212, 3]),
        BigUint::from_bytes_le(&[35, 237, 8, 69, 0, 238, 150, 140, 5]),
        BigUint::from_bytes_le(&[35, 237, 8, 69, 4, 238, 150, 140, 5]),
        BigUint::from_bytes_le(&[63, 194, 74, 189, 166, 77, 1, 112, 6]),
        BigUint::from_bytes_le(&[8, 9, 201, 246, 234, 26, 13, 153, 7]),
        BigUint::from_bytes_le(&[9, 15, 136, 221, 224, 213, 196, 133, 8]),
        BigUint::from_bytes_le(&[9, 15, 136, 221, 228, 213, 196, 133, 8]),
        BigUint::from_bytes_le(&[5, 50, 111, 159, 17, 155, 110, 4, 14]),
        BigUint::from_bytes_le(&[4, 50, 111, 159, 21, 155, 110, 4, 14]),
        BigUint::from_bytes_le(&[60, 83, 236, 138, 79, 252, 195, 121, 14]),
        BigUint::from_bytes_le(&[27, 213, 167, 214, 131, 235, 238, 237, 191]),
        BigUint::from_bytes_le(&[24, 116, 189, 219, 204, 160, 3, 222, 108, 2]),
        BigUint::from_bytes_le(&[99, 78, 177, 185, 108, 89, 126, 6, 228, 3]),
        BigUint::from_bytes_le(&[226, 92, 63, 99, 196, 52, 55, 250, 220, 15]),
        BigUint::from_bytes_le(&[159, 53, 34, 19, 121, 135, 61, 85, 119, 74]),
        BigUint::from_bytes_le(&[125, 181, 249, 145, 74, 7, 246, 233, 190, 180]),
        BigUint::from_bytes_le(&[0, 69, 107, 207, 53, 77, 153, 190, 25, 91, 5]),
        BigUint::from_bytes_le(&[1, 69, 107, 207, 53, 77, 153, 190, 25, 91, 5]),
        BigUint::from_bytes_le(&[21, 221, 90, 57, 16, 105, 125, 245, 93, 235, 5]),
        BigUint::from_bytes_le(&[108, 3, 234, 36, 12, 241, 176, 203, 226, 48, 6]),
        BigUint::from_bytes_le(&[118, 149, 64, 6, 157, 232, 87, 47, 108, 78, 6]),
        BigUint::from_bytes_le(&[226, 3, 138, 100, 145, 221, 234, 185, 223, 176, 6]),
        BigUint::from_bytes_le(&[252, 103, 133, 156, 247, 172, 101, 11, 217, 147, 8]),
        BigUint::from_bytes_le(&[252, 103, 133, 156, 247, 172, 101, 139, 217, 147, 8]),
        BigUint::from_bytes_le(&[100, 103, 177, 134, 168, 240, 225, 243, 131, 58, 9]),
        BigUint::from_bytes_le(&[100, 103, 177, 134, 168, 244, 225, 243, 131, 58, 9]),
        BigUint::from_bytes_le(&[52, 210, 127, 165, 6, 252, 99, 174, 0, 119, 9]),
        BigUint::from_bytes_le(&[184, 162, 12, 175, 7, 248, 106, 93, 235, 123, 9]),
        BigUint::from_bytes_le(&[184, 162, 44, 175, 7, 248, 106, 93, 235, 123, 9]),
        BigUint::from_bytes_le(&[141, 4, 150, 255, 141, 76, 187, 206, 105, 185, 9]),
        BigUint::from_bytes_le(&[20, 159, 159, 90, 229, 97, 89, 163, 62, 49, 10]),
        BigUint::from_bytes_le(&[92, 238, 236, 47, 241, 40, 163, 100, 205, 154, 15]),
        BigUint::from_bytes_le(&[34, 68, 29, 179, 211, 168, 225, 30, 2, 45, 35]),
        BigUint::from_bytes_le(&[215, 73, 133, 151, 115, 239, 59, 105, 39, 214, 80]),
        BigUint::from_bytes_le(&[61, 251, 176, 30, 42, 126, 246, 147, 247, 40, 229]),
        BigUint::from_bytes_le(&[183, 158, 247, 132, 198, 235, 61, 110, 15, 182, 164, 9]),
        BigUint::from_bytes_le(&[133, 21, 152, 105, 70, 65, 26, 222, 25, 162, 222, 225, 1]),
        BigUint::from_bytes_le(&[174, 99, 49, 1, 37, 102, 156, 125, 206, 219, 186, 232, 1]),
        BigUint::from_bytes_le(&[56, 199, 49, 35, 198, 131, 249, 73, 199, 243, 26, 105, 6]),
        BigUint::from_bytes_le(&[82, 131, 156, 81, 1, 124, 197, 139, 165, 15, 234, 250, 6]),
        BigUint::from_bytes_le(&[54, 95, 194, 183, 28, 16, 174, 66, 59, 35, 140, 251, 6]),
        BigUint::from_bytes_le(&[52, 199, 32, 227, 63, 223, 182, 69, 204, 193, 217, 43, 7]),
        BigUint::from_bytes_le(&[63, 149, 233, 246, 5, 210, 230, 110, 77, 70, 167, 65, 8]),
        BigUint::from_bytes_le(&[185, 36, 97, 166, 34, 162, 175, 7, 112, 167, 96, 236, 55]),
        BigUint::from_bytes_le(&[246, 217, 107, 91, 46, 19, 204, 52, 136, 82, 221, 218, 60]),
        BigUint::from_bytes_le(&[5, 224, 171, 8, 140, 69, 173, 152, 185, 212, 111, 215, 107, 3]),
        BigUint::from_bytes_le(&[104, 27, 204, 161, 245, 12, 46, 81, 225, 217, 125, 184, 62, 4]),
        BigUint::from_bytes_le(&[20, 143, 168, 92, 152, 50, 43, 42, 67, 27, 192, 106, 154, 206, 2]),
        BigUint::from_bytes_le(&[141, 205, 145, 200, 20, 120, 150, 138, 136, 154, 157, 71, 63, 236, 2]),
        BigUint::from_bytes_le(&[224, 2, 228, 125, 48, 11, 58, 123, 191, 104, 190, 39, 55, 128, 3]),
        BigUint::from_bytes_le(&[225, 2, 228, 125, 48, 11, 58, 123, 191, 104, 190, 39, 55, 128, 3]),
        BigUint::from_bytes_le(&[230, 162, 151, 219, 190, 75, 29, 207, 229, 17, 11, 180, 72, 139, 3]),
        BigUint::from_bytes_le(&[230, 162, 151, 219, 190, 75, 29, 207, 229, 17, 139, 180, 72, 139, 3]),
        BigUint::from_bytes_le(&[121, 98, 17, 147, 67, 165, 13, 58, 168, 5, 162, 175, 128, 246, 4]),
        BigUint::from_bytes_le(&[231, 222, 160, 61, 79, 219, 70, 2, 202, 91, 65, 240, 27, 182, 5]),
        BigUint::from_bytes_le(&[138, 253, 215, 129, 26, 213, 215, 253, 146, 52, 240, 55, 129, 148, 7]),
        BigUint::from_bytes_le(&[22, 191, 188, 227, 71, 51, 168, 245, 179, 88, 186, 251, 185, 14, 8]),
        BigUint::from_bytes_le(&[128, 126, 226, 177, 156, 250, 75, 120, 31, 254, 36, 64, 236, 185, 8]),
        BigUint::from_bytes_le(&[129, 126, 226, 177, 156, 250, 75, 120, 31, 254, 36, 64, 236, 185, 8]),
        BigUint::from_bytes_le(&[250, 248, 90, 3, 244, 81, 151, 207, 127, 232, 104, 34, 173, 14, 13]),
        BigUint::from_bytes_le(&[250, 248, 90, 35, 244, 81, 151, 207, 127, 232, 104, 34, 173, 14, 13]),
        BigUint::from_bytes_le(&[174, 120, 61, 243, 148, 224, 229, 107, 105, 69, 122, 234, 34, 21, 56]),
        BigUint::from_bytes_le(&[167, 11, 159, 205, 219, 24, 26, 131, 26, 106, 225, 246, 136, 62, 84]),
        BigUint::from_bytes_le(&[115, 221, 254, 254, 23, 239, 29, 42, 72, 127, 185, 219, 209, 228, 168]),
        BigUint::from_bytes_le(&[194, 227, 26, 141, 25, 55, 48, 243, 87, 6, 173, 132, 116, 108, 121, 2]),
        BigUint::from_bytes_le(&[197, 244, 234, 239, 241, 145, 173, 27, 206, 111, 153, 122, 238, 207, 32, 12]),
        BigUint::from_bytes_le(&[196, 244, 234, 239, 241, 145, 173, 91, 206, 111, 153, 122, 238, 207, 32, 12]),
        BigUint::from_bytes_le(&[147, 45, 48, 102, 63, 129, 91, 111, 171, 2, 183, 101, 183, 173, 150, 65]),
        BigUint::from_bytes_le(&[120, 23, 238, 139, 149, 202, 134, 13, 33, 167, 75, 102, 144, 25, 119, 79, 2]),
        BigUint::from_bytes_le(&[120, 23, 238, 139, 149, 202, 134, 13, 33, 167, 75, 102, 152, 25, 119, 79, 2]),
        BigUint::from_bytes_le(&[229, 169, 47, 212, 71, 193, 43, 140, 24, 116, 124, 133, 179, 228, 20, 80, 2]),
        BigUint::from_bytes_le(&[139, 123, 193, 107, 41, 43, 206, 110, 246, 221, 10, 140, 81, 205, 106, 93, 2]),
        BigUint::from_bytes_le(&[146, 200, 139, 79, 157, 232, 55, 153, 62, 14, 14, 80, 211, 91, 177, 233, 2]),
        BigUint::from_bytes_le(&[7, 204, 110, 215, 106, 23, 159, 101, 85, 157, 226, 137, 144, 50, 240, 58, 4]),
        BigUint::from_bytes_le(&[7, 204, 110, 215, 106, 23, 159, 101, 85, 157, 226, 137, 152, 50, 240, 58, 4]),
        BigUint::from_bytes_le(&[147, 199, 195, 30, 164, 222, 13, 189, 60, 71, 95, 248, 134, 127, 118, 38, 6]),
        BigUint::from_bytes_le(&[34, 60, 220, 100, 125, 223, 41, 124, 25, 78, 127, 128, 10, 104, 175, 223, 7]),
        BigUint::from_bytes_le(&[23, 236, 116, 15, 30, 210, 237, 161, 166, 93, 237, 16, 159, 248, 242, 116, 8]),
        BigUint::from_bytes_le(&[232, 41, 253, 160, 106, 80, 109, 3, 32, 117, 145, 49, 22, 16, 99, 155, 221, 1]),
        BigUint::from_bytes_le(&[252, 133, 103, 61, 106, 181, 19, 51, 198, 219, 32, 142, 212, 119, 246, 3, 135, 3]),
        BigUint::from_bytes_le(&[12, 135, 207, 233, 71, 18, 5, 12, 37, 139, 241, 9, 93, 44, 70, 227, 167, 3]),
        BigUint::from_bytes_le(&[212, 161, 160, 190, 217, 253, 240, 126, 202, 134, 244, 36, 226, 105, 163, 238, 203, 5]),
        BigUint::from_bytes_le(&[123, 92, 234, 140, 129, 110, 125, 14, 162, 254, 140, 105, 3, 60, 144, 109, 203, 14, 2]),
        BigUint::from_bytes_le(&[4, 94, 80, 198, 10, 221, 0, 139, 160, 67, 60, 123, 159, 91, 84, 245, 116, 17, 3]),
        BigUint::from_bytes_le(&[4, 94, 80, 198, 42, 221, 0, 139, 160, 67, 60, 123, 159, 91, 84, 245, 116, 17, 3]),
        BigUint::from_bytes_le(&[114, 72, 48, 247, 99, 94, 64, 224, 42, 133, 110, 2, 61, 200, 248, 48, 8, 74, 3]),
        BigUint::from_bytes_le(&[67, 71, 151, 8, 200, 52, 63, 31, 93, 67, 186, 78, 89, 30, 90, 82, 237, 75, 3]),
        BigUint::from_bytes_le(&[12, 180, 58, 136, 196, 21, 94, 228, 119, 189, 236, 240, 235, 105, 194, 83, 159, 103, 3]),
        BigUint::from_bytes_le(&[121, 167, 203, 230, 18, 52, 54, 115, 247, 13, 136, 88, 223, 250, 29, 84, 86, 139, 4]),
        BigUint::from_bytes_le(&[71, 146, 43, 248, 2, 0, 0, 195, 232, 32, 122, 254, 96, 95, 220, 60, 11, 165, 4]),
        BigUint::from_bytes_le(&[71, 146, 43, 248, 34, 0, 0, 195, 232, 32, 122, 254, 96, 95, 220, 60, 11, 165, 4]),
        BigUint::from_bytes_le(&[71, 146, 43, 248, 2, 0, 0, 195, 232, 36, 122, 254, 96, 95, 220, 60, 11, 165, 4]),
        BigUint::from_bytes_le(&[71, 146, 43, 248, 34, 0, 0, 195, 232, 36, 122, 254, 96, 95, 220, 60, 11, 165, 4]),
        BigUint::from_bytes_le(&[125, 24, 227, 154, 225, 245, 52, 243, 142, 163, 246, 74, 173, 17, 32, 164, 28, 196, 4]),
        BigUint::from_bytes_le(&[107, 238, 176, 52, 29, 123, 43, 122, 84, 247, 251, 174, 63, 226, 55, 18, 159, 207, 7]),
        BigUint::from_bytes_le(&[146, 100, 126, 227, 197, 65, 218, 243, 73, 67, 222, 10, 52, 64, 136, 66, 87, 64, 61, 23]),
        BigUint::from_bytes_le(&[48, 54, 103, 169, 120, 224, 174, 190, 47, 3, 252, 242, 226, 110, 166, 203, 48, 223, 172, 83]),
        BigUint::from_bytes_le(&[49, 54, 103, 169, 120, 224, 174, 190, 47, 3, 252, 242, 226, 110, 166, 203, 48, 223, 172, 83]),
        BigUint::from_bytes_le(&[112, 168, 110, 227, 125, 49, 202, 11, 195, 22, 147, 213, 22, 96, 139, 244, 94, 102, 230, 104, 1]),
        BigUint::from_bytes_le(&[113, 168, 110, 227, 125, 49, 202, 11, 195, 22, 147, 213, 22, 96, 139, 244, 94, 102, 230, 104, 1]),
        BigUint::from_bytes_le(&[235, 125, 196, 52, 215, 137, 85, 135, 12, 72, 237, 133, 249, 101, 12, 67, 154, 103, 241, 105, 2]),
        BigUint::from_bytes_le(&[202, 150, 179, 165, 60, 237, 51, 26, 129, 247, 129, 48, 94, 13, 217, 211, 60, 206, 246, 123, 2]),
        BigUint::from_bytes_le(&[194, 57, 253, 42, 222, 88, 44, 231, 10, 116, 134, 115, 245, 232, 124, 160, 46, 48, 124, 139, 2]),
        BigUint::from_bytes_le(&[194, 57, 253, 42, 222, 88, 44, 231, 10, 116, 134, 115, 245, 232, 124, 168, 46, 48, 124, 139, 2]),
        BigUint::from_bytes_le(&[224, 95, 40, 41, 242, 58, 128, 234, 98, 180, 145, 75, 238, 52, 118, 238, 10, 1, 21, 172, 2]),
        BigUint::from_bytes_le(&[225, 95, 40, 41, 242, 58, 128, 234, 98, 180, 145, 75, 238, 52, 118, 238, 10, 1, 21, 172, 2]),
        BigUint::from_bytes_le(&[0, 106, 77, 121, 240, 161, 254, 58, 173, 5, 44, 9, 131, 177, 116, 119, 242, 137, 106, 122, 3]),
        BigUint::from_bytes_le(&[1, 106, 77, 121, 240, 161, 254, 58, 173, 5, 44, 9, 131, 177, 116, 119, 242, 137, 106, 122, 3]),
        BigUint::from_bytes_le(&[247, 55, 20, 208, 4, 29, 134, 230, 137, 145, 250, 49, 5, 16, 6, 79, 158, 141, 103, 140, 3]),
        BigUint::from_bytes_le(&[231, 245, 206, 42, 185, 216, 17, 200, 139, 53, 39, 225, 248, 243, 154, 124, 175, 225, 128, 208, 4]),
        BigUint::from_bytes_le(&[122, 48, 69, 232, 235, 200, 66, 166, 147, 140, 113, 173, 69, 189, 35, 117, 67, 175, 224, 242, 36]),
        BigUint::from_bytes_le(&[10, 102, 149, 41, 186, 165, 141, 22, 23, 25, 55, 93, 180, 145, 12, 117, 57, 114, 179, 253, 0, 1]),
        BigUint::from_bytes_le(&[101, 232, 132, 243, 113, 167, 67, 18, 121, 98, 145, 217, 214, 73, 221, 249, 189, 72, 255, 202, 13, 4]),
        BigUint::from_bytes_le(&[21, 170, 92, 11, 28, 86, 139, 60, 136, 207, 152, 208, 159, 13, 71, 136, 75, 124, 6, 197, 161, 193, 1]),
        BigUint::from_bytes_le(&[21, 170, 92, 11, 28, 86, 139, 60, 136, 207, 152, 212, 159, 13, 71, 136, 75, 124, 6, 197, 161, 193, 1]),
        BigUint::from_bytes_le(&[86, 177, 176, 92, 181, 180, 118, 98, 141, 51, 187, 140, 72, 109, 161, 240, 250, 22, 94, 27, 168, 203, 1]),
        BigUint::from_bytes_le(&[242, 38, 128, 186, 151, 134, 16, 155, 225, 66, 209, 223, 186, 59, 134, 73, 98, 150, 189, 54, 1, 204, 1]),
        BigUint::from_bytes_le(&[156, 121, 48, 226, 215, 7, 108, 21, 48, 153, 254, 101, 170, 55, 4, 137, 81, 153, 42, 231, 199, 223, 1]),
        BigUint::from_bytes_le(&[156, 121, 48, 226, 215, 39, 108, 21, 48, 153, 254, 101, 170, 55, 4, 137, 81, 153, 42, 231, 199, 223, 1]),
        BigUint::from_bytes_le(&[15, 110, 16, 123, 37, 98, 139, 27, 42, 109, 238, 76, 56, 188, 22, 95, 148, 98, 98, 112, 124, 233, 1]),
        BigUint::from_bytes_le(&[47, 138, 100, 72, 231, 81, 123, 238, 196, 173, 50, 62, 183, 112, 29, 168, 152, 0, 139, 203, 229, 243, 1]),
        BigUint::from_bytes_le(&[15, 130, 39, 57, 48, 15, 195, 192, 37, 50, 48, 109, 105, 66, 149, 97, 241, 74, 114, 176, 165, 161, 2]),
        BigUint::from_bytes_le(&[15, 130, 39, 57, 48, 47, 195, 192, 37, 50, 48, 109, 105, 66, 149, 97, 241, 74, 114, 176, 165, 161, 2]),
        BigUint::from_bytes_le(&[42, 245, 239, 108, 66, 20, 51, 164, 138, 79, 116, 69, 151, 69, 28, 69, 10, 54, 166, 7, 90, 171, 2]),
        BigUint::from_bytes_le(&[42, 245, 239, 108, 66, 20, 51, 164, 138, 79, 116, 69, 151, 69, 28, 69, 138, 54, 166, 7, 90, 171, 2]),
        BigUint::from_bytes_le(&[78, 243, 219, 30, 120, 72, 68, 129, 173, 81, 147, 105, 144, 78, 210, 132, 96, 55, 165, 255, 138, 192, 2]),
        BigUint::from_bytes_le(&[201, 221, 186, 159, 22, 142, 126, 15, 198, 172, 150, 76, 101, 249, 218, 118, 105, 238, 9, 156, 167, 202, 2]),
        BigUint::from_bytes_le(&[110, 115, 232, 145, 108, 82, 143, 178, 142, 16, 249, 188, 151, 143, 202, 217, 93, 163, 190, 229, 194, 222, 2]),
        BigUint::from_bytes_le(&[75, 137, 123, 168, 7, 6, 215, 250, 158, 163, 153, 123, 92, 199, 28, 89, 29, 244, 31, 241, 130, 140, 3]),
        BigUint::from_bytes_le(&[75, 137, 123, 168, 7, 38, 215, 250, 158, 163, 153, 123, 92, 199, 28, 89, 29, 244, 31, 241, 130, 140, 3]),
        BigUint::from_bytes_le(&[194, 140, 201, 47, 15, 182, 57, 61, 161, 114, 232, 107, 157, 47, 134, 199, 166, 101, 161, 175, 241, 108, 4]),
        BigUint::from_bytes_le(&[46, 133, 39, 229, 95, 235, 113, 163, 197, 50, 165, 111, 246, 255, 26, 189, 176, 31, 240, 227, 148, 75, 6]),
        BigUint::from_bytes_le(&[131, 200, 109, 147, 192, 213, 32, 115, 182, 92, 134, 127, 67, 178, 81, 1, 253, 18, 75, 115, 95, 129, 39]),
        BigUint::from_bytes_le(&[91, 16, 157, 122, 113, 19, 150, 166, 152, 243, 47, 125, 239, 22, 81, 150, 246, 174, 226, 107, 88, 73, 54]),
        BigUint::from_bytes_le(&[91, 21, 188, 224, 78, 213, 59, 23, 19, 200, 102, 59, 252, 212, 158, 243, 206, 20, 52, 56, 200, 208, 243, 47]),
        BigUint::from_bytes_le(&[86, 152, 144, 155, 35, 102, 25, 194, 252, 32, 9, 132, 16, 84, 236, 65, 217, 129, 106, 205, 124, 16, 243, 96, 1]),
        BigUint::from_bytes_le(&[86, 152, 144, 155, 35, 102, 25, 194, 252, 32, 9, 132, 20, 84, 236, 65, 217, 129, 106, 205, 124, 16, 243, 96, 1]),
        BigUint::from_bytes_le(&[162, 71, 125, 248, 164, 168, 172, 181, 80, 110, 149, 149, 105, 78, 235, 174, 151, 54, 41, 206, 162, 244, 96, 120, 1]),
        BigUint::from_bytes_le(&[234, 13, 228, 13, 70, 109, 149, 12, 228, 108, 49, 168, 218, 151, 243, 236, 161, 218, 143, 231, 162, 177, 1, 121, 1]),
        BigUint::from_bytes_le(&[7, 163, 116, 73, 35, 201, 103, 14, 44, 196, 46, 5, 79, 162, 204, 10, 220, 7, 80, 254, 10, 76, 245, 25, 2]),
        BigUint::from_bytes_le(&[7, 163, 116, 73, 35, 201, 103, 14, 44, 196, 46, 5, 79, 162, 204, 10, 220, 7, 88, 254, 10, 76, 245, 25, 2]),
        BigUint::from_bytes_le(&[39, 51, 114, 25, 128, 62, 164, 242, 71, 131, 28, 144, 223, 25, 215, 73, 238, 250, 57, 78, 104, 168, 228, 37, 2]),
        BigUint::from_bytes_le(&[231, 155, 107, 86, 194, 165, 77, 157, 233, 29, 152, 95, 232, 211, 248, 58, 25, 117, 242, 238, 172, 112, 93, 38, 2]),
        BigUint::from_bytes_le(&[192, 71, 203, 242, 167, 46, 173, 248, 13, 140, 162, 11, 168, 209, 223, 109, 74, 168, 185, 79, 14, 97, 9, 194, 2]),
        BigUint::from_bytes_le(&[193, 71, 203, 242, 167, 46, 173, 248, 13, 140, 162, 11, 168, 209, 223, 109, 74, 168, 185, 79, 14, 97, 9, 194, 2]),
        BigUint::from_bytes_le(&[233, 222, 30, 126, 234, 255, 200, 188, 148, 23, 175, 252, 51, 112, 235, 61, 167, 99, 46, 101, 221, 1, 254, 63, 4]),
        BigUint::from_bytes_le(&[197, 93, 90, 119, 59, 72, 42, 187, 212, 82, 63, 177, 36, 179, 103, 26, 127, 106, 6, 123, 88, 104, 250, 209, 30]),
        BigUint::from_bytes_le(&[160, 170, 89, 181, 3, 254, 233, 93, 114, 234, 216, 237, 57, 45, 56, 114, 45, 24, 1, 30, 151, 131, 239, 89, 76, 1]),
        BigUint::from_bytes_le(&[161, 170, 89, 181, 3, 254, 233, 93, 114, 234, 216, 237, 57, 45, 56, 114, 45, 24, 1, 30, 151, 131, 239, 89, 76, 1]),
        BigUint::from_bytes_le(&[178, 12, 200, 245, 86, 194, 10, 202, 54, 5, 227, 109, 135, 223, 222, 65, 146, 179, 122, 251, 25, 16, 238, 150, 219, 1]),
        BigUint::from_bytes_le(&[227, 43, 3, 169, 159, 100, 157, 43, 104, 247, 1, 94, 205, 183, 52, 23, 18, 225, 201, 237, 223, 145, 113, 176, 219, 1]),
        BigUint::from_bytes_le(&[125, 91, 21, 76, 215, 140, 20, 198, 198, 206, 228, 242, 222, 30, 92, 77, 108, 223, 242, 110, 6, 105, 198, 213, 228, 1]),
        BigUint::from_bytes_le(&[44, 246, 51, 244, 61, 160, 52, 82, 207, 222, 154, 70, 194, 254, 33, 21, 188, 212, 203, 245, 238, 16, 57, 184, 127, 63]),
        BigUint::from_bytes_le(&[130, 1, 33, 43, 71, 71, 171, 151, 189, 236, 210, 83, 168, 219, 18, 246, 126, 91, 126, 50, 191, 169, 96, 28, 106, 22, 1]),
        BigUint::from_bytes_le(&[185, 148, 146, 153, 31, 225, 173, 79, 25, 50, 146, 107, 11, 16, 153, 30, 191, 3, 108, 197, 26, 17, 94, 212, 67, 156, 1]),
        BigUint::from_bytes_le(&[185, 148, 146, 153, 31, 225, 173, 79, 25, 50, 146, 107, 11, 20, 153, 30, 191, 3, 108, 197, 26, 17, 94, 212, 67, 156, 1]),
        BigUint::from_bytes_le(&[249, 110, 73, 207, 242, 97, 122, 154, 250, 152, 29, 95, 4, 190, 0, 51, 53, 78, 16, 120, 29, 176, 178, 32, 25, 168, 2]),
        BigUint::from_bytes_le(&[51, 151, 3, 100, 155, 235, 233, 92, 106, 112, 49, 18, 104, 142, 251, 98, 134, 46, 159, 229, 32, 111, 65, 23, 58, 125, 24]),
        BigUint::from_bytes_le(&[223, 82, 61, 5, 170, 35, 80, 197, 38, 83, 191, 143, 108, 216, 227, 40, 140, 232, 149, 55, 218, 87, 71, 89, 58, 148, 102, 1]),
        BigUint::from_bytes_le(&[198, 130, 32, 176, 96, 60, 210, 35, 12, 32, 74, 240, 68, 175, 94, 10, 89, 214, 19, 105, 47, 89, 252, 140, 43, 226, 222, 1]),
        BigUint::from_bytes_le(&[28, 71, 108, 43, 129, 212, 128, 104, 236, 255, 164, 180, 19, 179, 61, 97, 69, 24, 215, 197, 228, 83, 137, 72, 255, 31, 237, 34]),
        BigUint::from_bytes_le(&[5, 195, 189, 48, 129, 55, 97, 26, 19, 45, 21, 109, 222, 233, 51, 53, 191, 243, 107, 152, 138, 113, 247, 36, 22, 30, 146, 62, 1]),
        BigUint::from_bytes_le(&[86, 99, 192, 138, 189, 92, 9, 106, 205, 16, 37, 37, 97, 31, 23, 23, 221, 157, 95, 116, 1, 4, 85, 249, 183, 201, 248, 157, 1]),
        BigUint::from_bytes_le(&[143, 1, 70, 29, 165, 116, 73, 182, 70, 231, 248, 171, 65, 160, 242, 18, 119, 70, 69, 70, 81, 180, 64, 194, 245, 80, 224, 161, 1]),
        BigUint::from_bytes_le(&[143, 1, 70, 29, 165, 116, 73, 180, 70, 231, 248, 171, 65, 160, 246, 18, 119, 70, 69, 70, 81, 180, 64, 194, 245, 80, 224, 161, 1]),
        BigUint::from_bytes_le(&[253, 231, 183, 167, 209, 126, 101, 241, 121, 74, 113, 207, 13, 210, 105, 138, 130, 63, 237, 61, 116, 13, 210, 199, 155, 130, 28, 164, 1]),
        BigUint::from_bytes_le(&[234, 120, 228, 96, 44, 242, 167, 150, 123, 5, 122, 51, 112, 187, 62, 250, 104, 84, 175, 45, 211, 156, 72, 17, 190, 83, 253, 165, 1]),
        BigUint::from_bytes_le(&[31, 11, 56, 149, 247, 86, 134, 156, 87, 111, 130, 192, 67, 209, 195, 87, 199, 185, 55, 248, 191, 85, 203, 224, 72, 145, 76, 7, 2]),
        BigUint::from_bytes_le(&[250, 107, 7, 20, 96, 106, 179, 12, 22, 121, 72, 229, 24, 185, 136, 47, 43, 6, 20, 254, 35, 75, 246, 56, 191, 114, 75, 9, 2]),
        BigUint::from_bytes_le(&[198, 154, 223, 245, 47, 172, 204, 27, 75, 21, 157, 247, 236, 193, 178, 119, 124, 131, 203, 97, 109, 53, 233, 238, 99, 31, 120, 13, 2]),
        BigUint::from_bytes_le(&[140, 66, 38, 154, 179, 197, 44, 103, 160, 64, 249, 250, 255, 133, 254, 217, 159, 1, 55, 94, 116, 189, 19, 235, 37, 219, 226, 116, 2]),
        BigUint::from_bytes_le(&[39, 4, 172, 12, 198, 232, 50, 228, 15, 255, 86, 250, 33, 165, 169, 155, 206, 246, 242, 212, 103, 32, 240, 6, 171, 36, 78, 220, 2]),
        BigUint::from_bytes_le(&[39, 4, 172, 12, 198, 232, 50, 228, 15, 255, 86, 250, 33, 165, 169, 155, 206, 246, 242, 212, 103, 40, 240, 6, 171, 36, 78, 220, 2]),
        BigUint::from_bytes_le(&[25, 85, 170, 80, 173, 114, 185, 219, 185, 136, 142, 111, 9, 12, 157, 56, 146, 252, 213, 237, 162, 54, 91, 221, 246, 240, 88, 122, 24]),
        BigUint::from_bytes_le(&[143, 147, 9, 30, 83, 179, 67, 73, 239, 49, 249, 209, 28, 155, 20, 180, 16, 42, 92, 83, 184, 110, 168, 160, 141, 249, 61, 102, 112, 1]),
        BigUint::from_bytes_le(&[103, 232, 181, 46, 255, 24, 188, 48, 238, 5, 151, 92, 242, 6, 185, 224, 173, 186, 208, 201, 254, 97, 100, 243, 243, 188, 28, 110, 44, 2]),
        BigUint::from_bytes_le(&[71, 95, 214, 191, 101, 130, 248, 131, 0, 4, 224, 102, 148, 51, 36, 170, 125, 130, 81, 198, 97, 4, 166, 146, 27, 46, 165, 106, 39, 16]),
        BigUint::from_bytes_le(&[6, 151, 91, 199, 123, 44, 35, 192, 163, 34, 239, 196, 189, 175, 208, 85, 194, 68, 207, 51, 70, 169, 83, 51, 145, 47, 225, 50, 12, 66, 1]),
        BigUint::from_bytes_le(&[75, 114, 59, 116, 102, 11, 157, 171, 243, 245, 252, 124, 156, 133, 217, 197, 215, 23, 66, 174, 233, 46, 190, 17, 42, 49, 115, 195, 111, 68, 1]),
        BigUint::from_bytes_le(&[122, 249, 242, 220, 236, 5, 242, 141, 17, 104, 164, 21, 186, 10, 230, 198, 35, 41, 144, 175, 202, 61, 51, 40, 124, 156, 116, 200, 248, 145, 1]),
        BigUint::from_bytes_le(&[67, 164, 55, 202, 10, 129, 42, 70, 142, 63, 154, 56, 13, 35, 144, 158, 114, 61, 139, 151, 155, 232, 244, 75, 178, 97, 133, 31, 23, 175, 27, 1]),
        BigUint::from_bytes_le(&[3, 250, 151, 2, 234, 203, 215, 148, 119, 79, 131, 226, 232, 237, 144, 103, 201, 128, 227, 214, 203, 15, 175, 171, 99, 81, 240, 46, 226, 227, 61, 58, 1]),
        BigUint::from_bytes_le(&[252, 244, 187, 159, 50, 232, 79, 136, 71, 213, 249, 146, 50, 119, 8, 210, 236, 112, 3, 174, 124, 202, 88, 101, 222, 174, 82, 110, 232, 229, 61, 58, 1]),
        BigUint::from_bytes_le(&[34, 13, 37, 82, 192, 0, 127, 145, 54, 91, 252, 252, 207, 45, 203, 193, 94, 89, 210, 112, 4, 21, 127, 75, 86, 106, 235, 69, 76, 79, 241, 239, 1]),
        BigUint::from_bytes_le(&[85, 208, 80, 1, 111, 108, 154, 197, 244, 39, 110, 112, 95, 129, 63, 245, 223, 239, 145, 80, 218, 244, 119, 15, 211, 133, 249, 203, 74, 254, 34, 169, 2]),
        BigUint::from_bytes_le(&[226, 147, 80, 132, 133, 5, 129, 79, 178, 1, 36, 217, 34, 178, 176, 159, 152, 242, 11, 46, 227, 167, 247, 255, 49, 110, 175, 167, 155, 204, 15, 45, 180, 1]),
        BigUint::from_bytes_le(&[39, 160, 123, 57, 61, 166, 95, 75, 77, 183, 46, 184, 245, 85, 184, 151, 47, 223, 201, 24, 20, 130, 67, 115, 96, 241, 69, 219, 251, 104, 143, 96, 72, 22]),
        BigUint::from_bytes_le(&[253, 39, 177, 65, 204, 72, 109, 94, 84, 94, 15, 124, 7, 38, 251, 183, 103, 76, 133, 243, 48, 106, 234, 132, 195, 87, 49, 91, 118, 47, 76, 83, 86, 31, 1]),
        BigUint::from_bytes_le(&[236, 77, 122, 248, 124, 0, 92, 111, 197, 110, 127, 113, 115, 6, 141, 115, 199, 83, 12, 237, 118, 160, 246, 38, 13, 23, 48, 233, 77, 154, 145, 249, 111, 79, 1]),
        BigUint::from_bytes_le(&[175, 248, 240, 107, 40, 200, 143, 14, 207, 183, 92, 215, 198, 59, 5, 152, 71, 46, 247, 48, 251, 71, 82, 142, 2, 97, 169, 174, 235, 182, 99, 121, 62, 80, 1]),
        BigUint::from_bytes_le(&[18, 4, 245, 163, 138, 241, 51, 31, 228, 82, 90, 87, 143, 43, 254, 177, 139, 24, 211, 219, 249, 175, 85, 138, 6, 240, 210, 174, 156, 69, 255, 154, 229, 222, 1]),
        BigUint::from_bytes_le(&[10, 89, 89, 70, 126, 254, 44, 26, 193, 65, 247, 210, 197, 104, 207, 145, 251, 42, 181, 104, 148, 243, 241, 30, 3, 61, 31, 192, 183, 125, 141, 58, 179, 147, 145, 2, 1]),
        BigUint::from_bytes_le(&[10, 89, 89, 70, 126, 254, 44, 26, 193, 65, 247, 210, 197, 104, 207, 145, 251, 42, 181, 104, 148, 243, 241, 30, 3, 61, 31, 200, 183, 125, 141, 58, 179, 147, 145, 2, 1]),
        BigUint::from_bytes_le(&[4, 68, 233, 248, 150, 75, 225, 246, 71, 179, 15, 40, 25, 162, 130, 246, 213, 240, 253, 207, 65, 75, 66, 124, 240, 155, 167, 166, 63, 246, 250, 34, 189, 74, 171, 149, 1]),
    ]
}
