// SPDX-License-Identifier: MPL-2.0

mod alloc;
mod cli;
mod crypto;
mod database;
mod entries;
mod header;
mod random;
mod repl;
mod tempfile;
mod wordlist;

use anyhow::{Context, Result};
use clap::StructOpt;
use nix::sys::resource::{setrlimit, Resource};

use cli::Cli;

fn main() -> Result<()> {
    disable_core_dumps()?;
    crypto::sodium_init()?;
    Cli::parse().run()
}

fn disable_core_dumps() -> Result<()> {
    setrlimit(Resource::RLIMIT_CORE, Some(0), Some(0)).context("Cannot disable core dumps")
}
