// SPDX-License-Identifier: MPL-2.0

pub mod argon2;
pub mod chacha20;
pub mod padding;

use anyhow::{anyhow, Result};
use libsodium_sys as ffi;

pub fn sodium_init() -> Result<()> {
    if unsafe { ffi::sodium_init() } >= 0 {
        Ok(())
    } else {
        Err(anyhow!("Unable to initialize libsodium"))
    }
}
