// SPDX-License-Identifier: MPL-2.0

use std::alloc::{GlobalAlloc, Layout, System};

// TODO: double check that this is working correctly... and use the sanitizer to be sure
#[global_allocator]
static A: ZeroingAllocator = ZeroingAllocator;

struct ZeroingAllocator;

unsafe impl GlobalAlloc for ZeroingAllocator {
    unsafe fn alloc(&self, layout: Layout) -> *mut u8 {
        System.alloc(layout)
    }

    unsafe fn dealloc(&self, ptr: *mut u8, layout: Layout) {
        // TODO perhaps use volatile_set_memory when stabilized
        nix::libc::explicit_bzero(ptr.cast(), layout.size());
        System.dealloc(ptr, layout);
    }
}
