// SPDX-License-Identifier: MPL-2.0

use std::path::Path;

use anyhow::Result;

use crate::crypto::chacha20::Key;
use crate::entries::Entries;
use crate::repl::util;

pub fn list(database_path: &Path, key: &Key) -> Result<()> {
    let (_, entries) = util::read_database(database_path, key)?;
    list_impl(&entries);
    Ok(())
}

fn list_impl(entries: &Entries) {
    for key in entries.keys() {
        println!("{}", key);
    }
}
