// SPDX-License-Identifier: MPL-2.0

use anyhow::{Context, Result};
use napa::cli::Cli;
use napa::crypto;
use structopt::StructOpt;
use rlimit::Resource;

fn main() -> Result<()> {
    Resource::CORE.set(0, 0).context("Cannot disable core dumps")?;
    crypto::sodium_init()?;
    Cli::from_args().run()
}
