// SPDX-License-Identifier: GPL-3.0-or-later

use std::path::Path;

use anyhow::Result;
use sodiumoxide::crypto::aead::xchacha20poly1305_ietf::Key;

use crate::entries::Entries;
use crate::repl::util;

pub fn show(name: &str, database_path: &Path, key: &Key) -> Result<()> {
    let (_, entries) = util::read_database(database_path, key)?;
    show_impl(name, &entries);
    Ok(())
}

fn show_impl(name: &str, entries: &Entries) {
    match entries.get(name) {
        Some(content) => println!("{}", content),
        None => println!("Error: entry for {} does not exist.", name),
    }
}
