// SPDX-License-Identifier: GPL-3.0-or-later

use std::path::Path;

use anyhow::Result;
use sodiumoxide::crypto::aead::xchacha20poly1305_ietf::Key;

use crate::entries::Entries;
use crate::repl::util;

pub fn list(database_path: &Path, key: &Key) -> Result<()> {
    let (_, entries) = util::read_database(database_path, key)?;
    list_impl(&entries);
    Ok(())
}

fn list_impl(entries: &Entries) {
    for key in entries.keys() {
        println!("{}", key);
    }
}
