// SPDX-License-Identifier: GPL-3.0-or-later

use std::io::Write;

use sodiumoxide::crypto::pwhash::argon2id13;
use termion::input::TermRead;

use crate::header::Header;

const NUM_WORDS: u32 = 6;

pub fn new_passphrase(header: &mut Header) -> String {

    let passphrase = (0..NUM_WORDS).map(|_| eff_wordlist::large::random_word()).collect::<Vec<_>>().join("-");
    println!("The new passphrase for this database file is: {}", passphrase);
    println!("Remember this passphrase! It will not be displayed again.");

    // Every new passphrase gets a new salt
    header.salt = argon2id13::gen_salt();

    passphrase
}

pub fn read_passphrase(prompt: &str) -> String {
    let stdout = std::io::stdout();
    let mut stdout = stdout.lock();
    let stdin = std::io::stdin();
    let mut stdin = stdin.lock();

    stdout.write_all(prompt.as_bytes()).unwrap();
    stdout.flush().unwrap();

    let passphrase = stdin.read_passwd(&mut stdout).unwrap().unwrap();

    stdout.write_all(b"\n").unwrap();

    stdout.flush().unwrap();

    passphrase
}
