// SPDX-License-Identifier: GPL-3.0-or-later

use std::path::Path;

use anyhow::Result;

use crate::cli::key;
use crate::cli::passphrase;
use crate::entries::Entries;
use crate::entries;
use crate::header::Header;

pub fn init(database_path: &Path) -> Result<()> {
    let mut header = Header::default();

    let passphrase = passphrase::new_passphrase(&mut header);

    let key = key::derive_key(&passphrase, &header)?;

    // No entries to write when creating a new database
    let entries = Entries::new();
    let database = entries::encrypt(&mut header, &entries, &key);

    database.write_new(database_path)
}
