### Introduction

Napa is a simple command line password manager written in Rust and based on libsodium. Napa should be considered alpha-level: it should not be used to store any actual passwords, and the database format may change in the future. At the moment Napa is Linux-only and requires Wayland for clipboard support. Patches for other FOSS operating systems are welcome.

### Installation

The easiest way to install Napa is through Cargo:

```
cargo install napa
```

Once Napa matures support will be added for other package managers.

### Motivation

The most popular command line password manager today is probably [pass](https://www.passwordstore.org/), which I used happily for several years. However, pass uses GPG to encrypt its secrets, which requires the song-and-dance of maintaining a GPG key just to access your passwords. [GPG is also bad](https://latacora.micro.blog/2019/07/16/the-pgp-problem.html), and its aging cryptography means that pass is vulnerable to the database attacks described [here](https://codeberg.org/jwgarber/napa/src/branch/main/database.md). Pass *also* gives arbitrary programs read/write access to your passwords once your GPG key is unlocked, which made me increasingly nervous in today's age of [typosquatting](https://www.zdnet.com/article/two-malicious-python-libraries-removed-from-pypi/). Thus was born Napa, a much simpler password manager with stronger cryptography for when you don't completely trust your local computer.

### Usage

A new database can be initialized using `napa init`. This will generate a six word passphrase from the [EFF long word list](https://www.eff.org/deeplinks/2016/07/new-wordlists-random-passphrases). Remember this passphrase, since it won't be displayed again.

```
$ napa init my-passwords.napa
The new passphrase for this database file is: creme-customer-squad-persuader-wise-purveyor
Remember this passphrase! It will not be displayed again.
```

After initialization, the database file can be unlocked using `napa open`. This will cache the decryption key in memory and drop you into a REPL-like interface for editing the password entries.

```
$ napa open my-passwords.napa
Enter the passphrase:
> edit example-entry
# this will open the entry in $EDITOR
```

The name of each password entry can be arbitrary text, which allows you to group the passwords however you like. Password entries can also contain arbitrary text and have no pre-defined layout. The only exception is for lines starting with the special `password:` prefix, which are used when generating a new password or copying it to the clipboard. For example, the author likes to organize his entries in the following way:

```
domain: login.example.com
username: my-username
password: my-awesome-password

Any extra information down here.
```

It is possible that special integration for `domain:`, `username:`, and other prefixes may added in the future.

The complete set of available commands can be seen by running `help` in the REPL. Each command also has documentation that can be accessed using `--help`, e.g. `edit --help`.

Finally, the passphrase to the database file can be changed with the `napa pass` command. This will generate a new passphrase.

```
$ napa pass my-passwords.napa
Enter the passphrase:
Your new passphrase for this database file is: penalty-cement-legacy-surface-symphonic-confound
Remember this passphrase! It won't be displayed again.
```

### Security

The Napa database file is designed to be immune to specific attacks described in the [database document](https://codeberg.org/jwgarber/napa/src/branch/main/database.md). Once the database is unlocked, Napa makes a best-effort attempt to avoid exposing secret material to any external process. For example, all memory allocated during the program is zeroed on deallocation. Secret information can only be accessed by the rest of the system when:
- copying to the clipboard (somewhat unavoidable, but the clipboard is cleared after a single paste), and
- editing entries with the `$EDITOR` (which uses temporary files, though file creation follows [best practices](https://wiki.sei.cmu.edu/confluence/display/c/FIO21-C.+Do+not+create+temporary+files+in+shared+directories)).

When possible, Napa should be compiled as a statically-linked binary to prevent [LD_PRELOAD attacks](https://attack.mitre.org/techniques/T1574/006/). Of course, this won't extend to the rest of your system (such as your terminal emulator), so it is recommended to use a sandbox (like [bubblewrap](https://github.com/containers/bubblewrap)) and a mandatory access control system such as [SELinux](https://github.com/SELinuxProject/selinux) or [AppArmor](https://gitlab.com/apparmor/apparmor).

Commits and tags that I author are signed with my [GPG key](https://www.jwgarber.ca/gpg/)[^1]. After importing the key, they can be verified using `git verify-commit` and `git verify-tag`.

### License

The Napa source code is licensed under the GPL3 or later. However, since one of its dependencies is licensed under the AGPL3, the combined work is AGPL3.

### Credits

Napa took inspiration from several other cryptographic programs, including:

- [libsodium](https://doc.libsodium.org/)
- [minisign](https://github.com/jedisct1/minisign)
- [kickpass](https://github.com/kickpass/kickpass)
- [aegis](https://github.com/beemdevelopment/Aegis)
- [age](https://github.com/FiloSottile/age)

[^1]: GPG is still bad, but unfortunately it's the only tool you can use to sign Git commits.
