// SPDX-License-Identifier: GPL-3.0-or-later

use std::path::PathBuf;

use crate::random::CharSet;
use crate::random;

pub struct TestFile {
    pub path: PathBuf
}

impl TestFile {
    pub fn new() -> TestFile {
        let tempdir = "/dev/shm";
        let nchars = 16;

        let file_random = random::random_string(CharSet::Alnum, nchars);

        let path = format!("{}/test-{}.napa", tempdir, file_random);

        TestFile { path: PathBuf::from(path) }
    }

}

impl Drop for TestFile {
    fn drop(&mut self) {
        // Ignore the return value since we shouldn't panic in a destructor
        let _ = std::fs::remove_file(&self.path);
    }
}
