// SPDX-License-Identifier: GPL-3.0-or-later

use anyhow::{anyhow, Result};
use sodiumoxide::crypto::aead::xchacha20poly1305_ietf::{Key, KEYBYTES};
use sodiumoxide::crypto::pwhash::argon2id13;

use crate::header::Header;

pub fn derive_key(passphrase: &str, header: &Header) -> Result<Key> {
    let mut key = [0u8; KEYBYTES];

    argon2id13::derive_key(
        &mut key,
        passphrase.as_bytes(),
        &header.salt,
        header.opslimit,
        header.memlimit,
    ).map_err(|_| anyhow!("Unable to derive key. Do you have enough free memory?"))?;

    Ok(Key(key))
}
