// SPDX-License-Identifier: GPL-3.0-or-later

use std::alloc::{GlobalAlloc, Layout, System};

// TODO: double check that this is working correctly... and use the sanitizer to be sure
#[global_allocator]
static A: SodiumAllocator = SodiumAllocator;

struct SodiumAllocator;

unsafe impl GlobalAlloc for SodiumAllocator {
    unsafe fn alloc(&self, layout: Layout) -> *mut u8 {
        System.alloc(layout)
    }

    unsafe fn dealloc(&self, ptr: *mut u8, layout: Layout) {
        libsodium_sys::sodium_memzero(ptr as _, layout.size());
        System.dealloc(ptr, layout);
    }
}
