use std::env::args;
use std::process::exit;
use std::io::{self, Read, Write};

use nanotemplate::{template, TemplateError};

fn main() {
    let vars = args().skip(1).collect::<Vec<_>>();

    if vars.iter().find(|&v| v == "-h" || v == "--help").is_some() {
        usage();
    }

    let vars = vars.iter().map(|a| {
        let mut kv = a.splitn(2, "=");
        (kv.next().unwrap(), kv.next().unwrap_or(""))
    });

    let mut tpl = String::new();
    io::stdin().read_to_string(&mut tpl).ok();

    let out = template(&tpl, vars).unwrap_or_else(|err| error(err));

    io::stdout().write_all(out.as_bytes()).ok();
}

fn error(err: TemplateError) -> ! {
    eprintln!("Template error: {}", err);
    exit(3);
}

fn usage() -> ! {
    eprintln!("{} {}", env!("CARGO_PKG_NAME"), env!("CARGO_PKG_VERSION"));
    eprintln!("{}", env!("CARGO_PKG_DESCRIPTION"));
    eprintln!();
    eprintln!("USAGE:");
    eprintln!("    {} [placeholder=value]", env!("CARGO_PKG_NAME"));
    eprintln!();
    eprintln!("EXAMPLE:");
    eprintln!(r#"    echo -e "Hello {{who}}!\nThis is {{name}} speaking!" | {} who=world name=me"#, env!("CARGO_PKG_NAME"));
    exit(2);
}
