[![Latest Version]][crates.io] [![Documentation]][docs.rs] ![License]

A minimal templating engine that renders a string from the template, replacing all instances of `{placeholder}` with given values.

The engine is strict:

* all placeholders must have values provided,
* all provided values must have matching placeholder,
* a single placeholder can be used multiple times and will be expanded in all places.

Values are provided as an iterable object that provides placeholder name and value pairs.

```rust
use nanotemplate::template;

assert_eq!(
	template("Hello, my name is {name}!", &[("name", "nanotemplate")]).unwrap(),
	"Hello, my name is nanotemplate!".to_owned());
```

Also comes with simple CLI utility:

```
echo "Hello my name is {name}" | nanotemplate name=nanotemplate
```

[crates.io]: https://crates.io/crates/nanotemplate
[Latest Version]: https://img.shields.io/crates/v/nanotemplate.svg
[Documentation]: https://docs.rs/nanotemplate/badge.svg
[docs.rs]: https://docs.rs/nanotemplate
[License]: https://img.shields.io/crates/l/nanotemplate.svg
