pub static ENTITIES: &'static[(&'static str, char)]  = &[
    ("AElig",        '\u{00C6}',),
    ("AMP",           '\u{000026}'),
    ("Aacute",        '\u{0000C1}'),
    ("Abreve",        '\u{000102}'),
    ("Acirc",         '\u{0000C2}'),
    ("Acy",           '\u{000410}'),
    ("Afr",           '\u{01D504}'),
    ("Agrave",        '\u{0000C0}'),
    ("Alpha",         '\u{000391}'),
    ("Amacr",         '\u{000100}'),
    ("And",           '\u{002A53}'),
    ("Aogon",         '\u{000104}'),
    ("Aopf",          '\u{01D538}'),
    ("ApplyFunction", '\u{002061}'),
    ("Aring",         '\u{0000C5}'),
    ("Ascr",          '\u{01D49C}'),
    ("Assign",        '\u{002254}'),
    ("Atilde",        '\u{0000C3}'),
    ("Auml",          '\u{0000C4}'),
    ("Backslash",     '\u{002216}'),
    ("Barv",          '\u{002AE7}'),
    ("Barwed",        '\u{002306}'),
    ("Bcy",           '\u{000411}'),
    ("Because",       '\u{002235}'),
    ("Bernoullis",    '\u{00212C}'),
    ("Beta",          '\u{000392}'),
    ("Bfr",           '\u{01D505}'),
    ("Bopf",          '\u{01D539}'),
    ("Breve",         '\u{0002D8}'),
    ("Bscr",          '\u{00212C}'),
    ("Bumpeq",        '\u{00224E}'),
    ("CHcy",          '\u{000427}'),
    ("COPY",          '\u{0000A9}'),
    ("Cacute",        '\u{000106}'),
    ("Cap",           '\u{0022D2}'),
    ("CapitalDifferentialD",            '\u{002145}'),
    ("Cayleys",                         '\u{00212D}'),
    ("Ccaron",                          '\u{00010C}'),
    ("Ccedil",                          '\u{0000C7}'),
    ("Ccirc",                           '\u{000108}'),
    ("Cconint",                         '\u{002230}'),
    ("Cdot",                            '\u{00010A}'),
    ("Cedilla",                         '\u{0000B8}'),
    ("CenterDot",                       '\u{0000B7}'),
    ("Cfr",                             '\u{00212D}'),
    ("Chi",                             '\u{0003A7}'),
    ("CircleDot",                       '\u{002299}'),
    ("CircleMinus",                     '\u{002296}'),
    ("CirclePlus",                      '\u{002295}'),
    ("CircleTimes",                     '\u{002297}'),
    ("ClockwiseContourIntegral",        '\u{002232}'),
    ("CloseCurlyDoubleQuote",           '\u{00201D}'),
    ("CloseCurlyQuote",                 '\u{002019}'),
    ("Colon",                           '\u{002237}'),
    ("Colone",                          '\u{002A74}'),
    ("Congruent",                       '\u{002261}'),
    ("Conint",                          '\u{00222F}'),
    ("ContourIntegral",                 '\u{00222E}'),
    ("Copf",                            '\u{002102}'),
    ("Coproduct",                       '\u{002210}'),
    ("CounterClockwiseContourIntegral", '\u{002233}'),
    ("Cross",                    '\u{002A2F}'),
    ("Cscr",                     '\u{01D49E}'),
    ("Cup",                      '\u{0022D3}'),
    ("CupCap",                   '\u{00224D}'),
    ("DD",                       '\u{002145}'),
    ("DDotrahd",                 '\u{002911}'),
    ("DJcy",                     '\u{000402}'),
    ("DScy",                     '\u{000405}'),
    ("DZcy",                     '\u{00040F}'),
    ("Dagger",                   '\u{002021}'),
    ("Darr",                     '\u{0021A1}'),
    ("Dashv",                    '\u{002AE4}'),
    ("Dcaron",                   '\u{00010E}'),
    ("Dcy",                      '\u{000414}'),
    ("Del",                      '\u{002207}'),
    ("Delta",                    '\u{000394}'),
    ("Dfr",                      '\u{01D507}'),
    ("DiacriticalAcute",         '\u{0000B4}'),
    ("DiacriticalDot",           '\u{0002D9}'),
    ("DiacriticalDoubleAcute",   '\u{0002DD}'),
    ("DiacriticalGrave",         '\u{000060}'),
    ("DiacriticalTilde",         '\u{0002DC}'),
    ("Diamond",                  '\u{0022C4}'),
    ("DifferentialD",            '\u{002146}'),
    ("Dopf",                     '\u{01D53B}'),
    ("Dot",                      '\u{0000A8}'),
    ("DotDot",                   '\u{0020DC}'),
    ("DotEqual",                 '\u{002250}'),
    ("DoubleContourIntegral",    '\u{00222F}'),
    ("DoubleDot",                '\u{0000A8}'),
    ("DoubleDownArrow",          '\u{0021D3}'),
    ("DoubleLeftArrow",          '\u{0021D0}'),
    ("DoubleLeftRightArrow",     '\u{0021D4}'),
    ("DoubleLeftTee",            '\u{002AE4}'),
    ("DoubleLongLeftArrow",      '\u{0027F8}'),
    ("DoubleLongLeftRightArrow", '\u{0027FA}'),
    ("DoubleLongRightArrow",     '\u{0027F9}'),
    ("DoubleRightArrow",         '\u{0021D2}'),
    ("DoubleRightTee",           '\u{0022A8}'),
    ("DoubleUpArrow",            '\u{0021D1}'),
    ("DoubleUpDownArrow",        '\u{0021D5}'),
    ("DoubleVerticalBar",        '\u{002225}'),
    ("DownArrow",                '\u{002193}'),
    ("DownArrowBar",             '\u{002913}'),
    ("DownArrowUpArrow",         '\u{0021F5}'),
    ("DownBreve",                '\u{000311}'),
    ("DownLeftRightVector",      '\u{002950}'),
    ("DownLeftTeeVector",        '\u{00295E}'),
    ("DownLeftVector",           '\u{0021BD}'),
    ("DownLeftVectorBar",        '\u{002956}'),
    ("DownRightTeeVector",       '\u{00295F}'),
    ("DownRightVector",          '\u{0021C1}'),
    ("DownRightVectorBar",       '\u{002957}'),
    ("DownTee",                  '\u{0022A4}'),
    ("DownTeeArrow",             '\u{0021A7}'),
    ("Downarrow",                '\u{0021D3}'),
    ("Dscr",                     '\u{01D49F}'),
    ("Dstrok",                   '\u{000110}'),
    ("ENG",                      '\u{00014A}'),
    ("ETH",                      '\u{0000D0}'),
    ("Eacute",                   '\u{0000C9}'),
    ("Ecaron",                   '\u{00011A}'),
    ("Ecirc",                    '\u{0000CA}'),
    ("Ecy",                      '\u{00042D}'),
    ("Edot",                     '\u{000116}'),
    ("Efr",                      '\u{01D508}'),
    ("Egrave",                   '\u{0000C8}'),
    ("Element",                  '\u{002208}'),
    ("Emacr",                    '\u{000112}'),
    ("EmptySmallSquare",         '\u{0025FB}'),
    ("EmptyVerySmallSquare",     '\u{0025AB}'),
    ("Eogon",                    '\u{000118}'),
    ("Eopf",                     '\u{01D53C}'),
    ("Epsilon",                  '\u{000395}'),
    ("Equal",                    '\u{002A75}'),
    ("EqualTilde",               '\u{002242}'),
    ("Equilibrium",              '\u{0021CC}'),
    ("Escr",                     '\u{002130}'),
    ("Esim",                     '\u{002A73}'),
    ("Eta",                      '\u{000397}'),
    ("Euml",                     '\u{0000CB}'),
    ("Exists",                   '\u{002203}'),
    ("ExponentialE",             '\u{002147}'),
    ("Fcy",                      '\u{000424}'),
    ("Ffr",                      '\u{01D509}'),
    ("FilledSmallSquare",        '\u{0025FC}'),
    ("FilledVerySmallSquare",    '\u{0025AA}'),
    ("Fopf",                     '\u{01D53D}'),
    ("ForAll",                   '\u{002200}'),
    ("Fouriertrf",               '\u{002131}'),
    ("Fscr",                     '\u{002131}'),
    ("GJcy",                     '\u{000403}'),
    ("GT",                       '\u{00003E}'),
    ("Gamma",                    '\u{000393}'),
    ("Gammad",                   '\u{0003DC}'),
    ("Gbreve",                   '\u{00011E}'),
    ("Gcedil",                   '\u{000122}'),
    ("Gcirc",                    '\u{00011C}'),
    ("Gcy",                      '\u{000413}'),
    ("Gdot",                     '\u{000120}'),
    ("Gfr",                      '\u{01D50A}'),
    ("Gg",                       '\u{0022D9}'),
    ("Gopf",                     '\u{01D53E}'),
    ("GreaterEqual",             '\u{002265}'),
    ("GreaterEqualLess",         '\u{0022DB}'),
    ("GreaterFullEqual",         '\u{002267}'),
    ("GreaterGreater",           '\u{002AA2}'),
    ("GreaterLess",              '\u{002277}'),
    ("GreaterSlantEqual",        '\u{002A7E}'),
    ("GreaterTilde",             '\u{002273}'),
    ("Gscr",                     '\u{01D4A2}'),
    ("Gt",                       '\u{00226B}'),
    ("HARDcy",                   '\u{00042A}'),
    ("Hacek",                    '\u{0002C7}'),
    ("Hat",                      '\u{00005E}'),
    ("Hcirc",                    '\u{000124}'),
    ("Hfr",                      '\u{00210C}'),
    ("HilbertSpace",             '\u{00210B}'),
    ("Hopf",                     '\u{00210D}'),
    ("HorizontalLine",           '\u{002500}'),
    ("Hscr",                     '\u{00210B}'),
    ("Hstrok",                   '\u{000126}'),
    ("HumpDownHump",             '\u{00224E}'),
    ("HumpEqual",                '\u{00224F}'),
    ("IEcy",                     '\u{000415}'),
    ("IJlig",                    '\u{000132}'),
    ("IOcy",                     '\u{000401}'),
    ("Iacute",                   '\u{0000CD}'),
    ("Icirc",                    '\u{0000CE}'),
    ("Icy",                      '\u{000418}'),
    ("Idot",                     '\u{000130}'),
    ("Ifr",                      '\u{002111}'),
    ("Igrave",                   '\u{0000CC}'),
    ("Im",                       '\u{002111}'),
    ("Imacr",                    '\u{00012A}'),
    ("ImaginaryI",               '\u{002148}'),
    ("Implies",                  '\u{0021D2}'),
    ("Int",                      '\u{00222C}'),
    ("Integral",                 '\u{00222B}'),
    ("Intersection",             '\u{0022C2}'),
    ("InvisibleComma",           '\u{002063}'),
    ("InvisibleTimes",           '\u{002062}'),
    ("Iogon",                    '\u{00012E}'),
    ("Iopf",                     '\u{01D540}'),
    ("Iota",                     '\u{000399}'),
    ("Iscr",                     '\u{002110}'),
    ("Itilde",                   '\u{000128}'),
    ("Iukcy",                    '\u{000406}'),
    ("Iuml",                     '\u{0000CF}'),
    ("Jcirc",                    '\u{000134}'),
    ("Jcy",                      '\u{000419}'),
    ("Jfr",                      '\u{01D50D}'),
    ("Jopf",                     '\u{01D541}'),
    ("Jscr",                     '\u{01D4A5}'),
    ("Jsercy",                   '\u{000408}'),
    ("Jukcy",                    '\u{000404}'),
    ("KHcy",                     '\u{000425}'),
    ("KJcy",                     '\u{00040C}'),
    ("Kappa",                    '\u{00039A}'),
    ("Kcedil",                   '\u{000136}'),
    ("Kcy",                      '\u{00041A}'),
    ("Kfr",                      '\u{01D50E}'),
    ("Kopf",                     '\u{01D542}'),
    ("Kscr",                     '\u{01D4A6}'),
    ("LJcy",                     '\u{000409}'),
    ("LT",                       '\u{00003C}'),
    ("Lacute",                   '\u{000139}'),
    ("Lambda",                   '\u{00039B}'),
    ("Lang",                     '\u{0027EA}'),
    ("Laplacetrf",               '\u{002112}'),
    ("Larr",                     '\u{00219E}'),
    ("Lcaron",                   '\u{00013D}'),
    ("Lcedil",                   '\u{00013B}'),
    ("Lcy",                      '\u{00041B}'),
    ("LeftAngleBracket",         '\u{0027E8}'),
    ("LeftArrow",                '\u{002190}'),
    ("LeftArrowBar",             '\u{0021E4}'),
    ("LeftArrowRightArrow",      '\u{0021C6}'),
    ("LeftCeiling",              '\u{002308}'),
    ("LeftDoubleBracket",        '\u{0027E6}'),
    ("LeftDownTeeVector",        '\u{002961}'),
    ("LeftDownVector",           '\u{0021C3}'),
    ("LeftDownVectorBar",        '\u{002959}'),
    ("LeftFloor",                '\u{00230A}'),
    ("LeftRightArrow",           '\u{002194}'),
    ("LeftRightVector",          '\u{00294E}'),
    ("LeftTee",                  '\u{0022A3}'),
    ("LeftTeeArrow",             '\u{0021A4}'),
    ("LeftTeeVector",            '\u{00295A}'),
    ("LeftTriangle",             '\u{0022B2}'),
    ("LeftTriangleBar",          '\u{0029CF}'),
    ("LeftTriangleEqual",        '\u{0022B4}'),
    ("LeftUpDownVector",         '\u{002951}'),
    ("LeftUpTeeVector",          '\u{002960}'),
    ("LeftUpVector",             '\u{0021BF}'),
    ("LeftUpVectorBar",          '\u{002958}'),
    ("LeftVector",               '\u{0021BC}'),
    ("LeftVectorBar",            '\u{002952}'),
    ("Leftarrow",                '\u{0021D0}'),
    ("Leftrightarrow",           '\u{0021D4}'),
    ("LessEqualGreater",         '\u{0022DA}'),
    ("LessFullEqual",            '\u{002266}'),
    ("LessGreater",              '\u{002276}'),
    ("LessLess",                 '\u{002AA1}'),
    ("LessSlantEqual",           '\u{002A7D}'),
    ("LessTilde",                '\u{002272}'),
    ("Lfr",                      '\u{01D50F}'),
    ("Ll",                       '\u{0022D8}'),
    ("Lleftarrow",               '\u{0021DA}'),
    ("Lmidot",                   '\u{00013F}'),
    ("LongLeftArrow",            '\u{0027F5}'),
    ("LongLeftRightArrow",       '\u{0027F7}'),
    ("LongRightArrow",           '\u{0027F6}'),
    ("Longleftarrow",            '\u{0027F8}'),
    ("Longleftrightarrow",       '\u{0027FA}'),
    ("Longrightarrow",           '\u{0027F9}'),
    ("Lopf",                     '\u{01D543}'),
    ("LowerLeftArrow",           '\u{002199}'),
    ("LowerRightArrow",          '\u{002198}'),
    ("Lscr",                     '\u{002112}'),
    ("Lsh",                      '\u{0021B0}'),
    ("Lstrok",                   '\u{000141}'),
    ("Lt",                       '\u{00226A}'),
    ("Map",                      '\u{002905}'),
    ("Mcy",                      '\u{00041C}'),
    ("MediumSpace",              '\u{00205F}'),
    ("Mellintrf",                '\u{002133}'),
    ("Mfr",                      '\u{01D510}'),
    ("MinusPlus",                '\u{002213}'),
    ("Mopf",                     '\u{01D544}'),
    ("Mscr",                     '\u{002133}'),
    ("Mu",                       '\u{00039C}'),
    ("NJcy",                     '\u{00040A}'),
    ("Nacute",                   '\u{000143}'),
    ("Ncaron",                   '\u{000147}'),
    ("Ncedil",                   '\u{000145}'),
    ("Ncy",                      '\u{00041D}'),
    ("NegativeMediumSpace",    '\u{00200B}'),
    ("NegativeThickSpace",     '\u{00200B}'),
    ("NegativeThinSpace",      '\u{00200B}'),
    ("NegativeVeryThinSpace",  '\u{00200B}'),
    ("NestedGreaterGreater",   '\u{00226B}'),
    ("NestedLessLess",         '\u{00226A}'),
    ("NewLine",                '\u{00000A}'),
    ("Nfr",                    '\u{01D511}'),
    ("NoBreak",                '\u{002060}'),
    ("NonBreakingSpace",       '\u{0000A0}'),
    ("Nopf",                   '\u{002115}'),
    ("Not",                    '\u{002AEC}'),
    ("NotCongruent",           '\u{002262}'),
    ("NotCupCap",              '\u{00226D}'),
    ("NotDoubleVerticalBar",   '\u{002226}'),
    ("NotElement",             '\u{002209}'),
    ("NotEqual",               '\u{002260}'),
    ("NotExists",              '\u{002204}'),
    ("NotGreater",             '\u{00226F}'),
    ("NotGreaterEqual",        '\u{002271}'),
    ("NotGreaterLess",         '\u{002279}'),
    ("NotGreaterTilde",        '\u{002275}'),
    ("NotLeftTriangle",        '\u{0022EA}'),
    ("NotLeftTriangleEqual",   '\u{0022EC}'),
    ("NotLess",                '\u{00226E}'),
    ("NotLessEqual",           '\u{002270}'),
    ("NotLessGreater",         '\u{002278}'),
    ("NotLessTilde",           '\u{002274}'),
    ("NotPrecedes",            '\u{002280}'),
    ("NotPrecedesSlantEqual",  '\u{0022E0}'),
    ("NotReverseElement",      '\u{00220C}'),
    ("NotRightTriangle",       '\u{0022EB}'),
    ("NotRightTriangleEqual",  '\u{0022ED}'),
    ("NotSquareSubsetEqual",   '\u{0022E2}'),
    ("NotSquareSupersetEqual", '\u{0022E3}'),
    ("NotSubsetEqual",         '\u{002288}'),
    ("NotSucceeds",            '\u{002281}'),
    ("NotSucceedsSlantEqual",  '\u{0022E1}'),
    ("NotSupersetEqual",       '\u{002289}'),
    ("NotTilde",               '\u{002241}'),
    ("NotTildeEqual",          '\u{002244}'),
    ("NotTildeFullEqual",      '\u{002247}'),
    ("NotTildeTilde",          '\u{002249}'),
    ("NotVerticalBar",         '\u{002224}'),
    ("Nscr",                   '\u{01D4A9}'),
    ("Ntilde",                 '\u{0000D1}'),
    ("Nu",                     '\u{00039D}'),
    ("OElig",                  '\u{000152}'),
    ("Oacute",                 '\u{0000D3}'),
    ("Ocirc",                  '\u{0000D4}'),
    ("Ocy",                    '\u{00041E}'),
    ("Odblac",                 '\u{000150}'),
    ("Ofr",                    '\u{01D512}'),
    ("Ograve",                 '\u{0000D2}'),
    ("Omacr",                  '\u{00014C}'),
    ("Omega",                  '\u{0003A9}'),
    ("Omicron",                '\u{00039F}'),
    ("Oopf",                   '\u{01D546}'),
    ("OpenCurlyDoubleQuote",   '\u{00201C}'),
    ("OpenCurlyQuote",         '\u{002018}'),
    ("Or",                     '\u{002A54}'),
    ("Oscr",                   '\u{01D4AA}'),
    ("Oslash",                 '\u{0000D8}'),
    ("Otilde",                 '\u{0000D5}'),
    ("Otimes",                 '\u{002A37}'),
    ("Ouml",                   '\u{0000D6}'),
    ("OverBar",                '\u{00203E}'),
    ("OverBrace",              '\u{0023DE}'),
    ("OverBracket",            '\u{0023B4}'),
    ("OverParenthesis",        '\u{0023DC}'),
    ("PartialD",               '\u{002202}'),
    ("Pcy",                    '\u{00041F}'),
    ("Pfr",                    '\u{01D513}'),
    ("Phi",                    '\u{0003A6}'),
    ("Pi",                     '\u{0003A0}'),
    ("PlusMinus",              '\u{0000B1}'),
    ("Poincareplane",          '\u{00210C}'),
    ("Popf",                   '\u{002119}'),
    ("Pr",                     '\u{002ABB}'),
    ("Precedes",               '\u{00227A}'),
    ("PrecedesEqual",          '\u{002AAF}'),
    ("PrecedesSlantEqual",     '\u{00227C}'),
    ("PrecedesTilde",          '\u{00227E}'),
    ("Prime",                  '\u{002033}'),
    ("Product",                '\u{00220F}'),
    ("Proportion",             '\u{002237}'),
    ("Proportional",           '\u{00221D}'),
    ("Pscr",                   '\u{01D4AB}'),
    ("Psi",                    '\u{0003A8}'),
    ("QUOT",                   '\u{000022}'),
    ("Qfr",                    '\u{01D514}'),
    ("Qopf",                   '\u{00211A}'),
    ("Qscr",                   '\u{01D4AC}'),
    ("RBarr",                  '\u{002910}'),
    ("REG",                    '\u{0000AE}'),
    ("Racute",                 '\u{000154}'),
    ("Rang",                   '\u{0027EB}'),
    ("Rarr",                   '\u{0021A0}'),
    ("Rarrtl",                 '\u{002916}'),
    ("Rcaron",                 '\u{000158}'),
    ("Rcedil",                 '\u{000156}'),
    ("Rcy",                    '\u{000420}'),
    ("Re",                     '\u{00211C}'),
    ("ReverseElement",         '\u{00220B}'),
    ("ReverseEquilibrium",     '\u{0021CB}'),
    ("ReverseUpEquilibrium",   '\u{00296F}'),
    ("Rfr",                 '\u{00211C}'),
    ("Rho",                 '\u{0003A1}'),
    ("RightAngleBracket",   '\u{0027E9}'),
    ("RightArrow",          '\u{002192}'),
    ("RightArrowBar",       '\u{0021E5}'),
    ("RightArrowLeftArrow", '\u{0021C4}'),
    ("RightCeiling",        '\u{002309}'),
    ("RightDoubleBracket",  '\u{0027E7}'),
    ("RightDownTeeVector",  '\u{00295D}'),
    ("RightDownVector",     '\u{0021C2}'),
    ("RightDownVectorBar",  '\u{002955}'),
    ("RightFloor",          '\u{00230B}'),
    ("RightTee",            '\u{0022A2}'),
    ("RightTeeArrow",       '\u{0021A6}'),
    ("RightTeeVector",      '\u{00295B}'),
    ("RightTriangle",       '\u{0022B3}'),
    ("RightTriangleBar",    '\u{0029D0}'),
    ("RightTriangleEqual",  '\u{0022B5}'),
    ("RightUpDownVector",   '\u{00294F}'),
    ("RightUpTeeVector",    '\u{00295C}'),
    ("RightUpVector",       '\u{0021BE}'),
    ("RightUpVectorBar",    '\u{002954}'),
    ("RightVector",         '\u{0021C0}'),
    ("RightVectorBar",      '\u{002953}'),
    ("Rightarrow",          '\u{0021D2}'),
    ("Ropf",                '\u{00211D}'),
    ("RoundImplies",        '\u{002970}'),
    ("Rrightarrow",         '\u{0021DB}'),
    ("Rscr",                '\u{00211B}'),
    ("Rsh",                 '\u{0021B1}'),
    ("RuleDelayed",         '\u{0029F4}'),
    ("SHCHcy",              '\u{000429}'),
    ("SHcy",                '\u{000428}'),
    ("SOFTcy",              '\u{00042C}'),
    ("Sacute",              '\u{00015A}'),
    ("Sc",                  '\u{002ABC}'),
    ("Scaron",              '\u{000160}'),
    ("Scedil",              '\u{00015E}'),
    ("Scirc",               '\u{00015C}'),
    ("Scy",                 '\u{000421}'),
    ("Sfr",                 '\u{01D516}'),
    ("ShortDownArrow",      '\u{002193}'),
    ("ShortLeftArrow",      '\u{002190}'),
    ("ShortRightArrow",     '\u{002192}'),
    ("ShortUpArrow",        '\u{002191}'),
    ("Sigma",               '\u{0003A3}'),
    ("SmallCircle",         '\u{002218}'),
    ("Sopf",                '\u{01D54A}'),
    ("Sqrt",                '\u{00221A}'),
    ("Square",              '\u{0025A1}'),
    ("SquareIntersection",  '\u{002293}'),
    ("SquareSubset",        '\u{00228F}'),
    ("SquareSubsetEqual",   '\u{002291}'),
    ("SquareSuperset",      '\u{002290}'),
    ("SquareSupersetEqual", '\u{002292}'),
    ("SquareUnion",         '\u{002294}'),
    ("Sscr",                '\u{01D4AE}'),
    ("Star",                '\u{0022C6}'),
    ("Sub",                 '\u{0022D0}'),
    ("Subset",              '\u{0022D0}'),
    ("SubsetEqual",         '\u{002286}'),
    ("Succeeds",            '\u{00227B}'),
    ("SucceedsEqual",       '\u{002AB0}'),
    ("SucceedsSlantEqual",  '\u{00227D}'),
    ("SucceedsTilde",       '\u{00227F}'),
    ("SuchThat",            '\u{00220B}'),
    ("Sum",                 '\u{002211}'),
    ("Sup",                 '\u{0022D1}'),
    ("Superset",            '\u{002283}'),
    ("SupersetEqual",       '\u{002287}'),
    ("Supset",              '\u{0022D1}'),
    ("THORN",               '\u{0000DE}'),
    ("TRADE",               '\u{002122}'),
    ("TSHcy",               '\u{00040B}'),
    ("TScy",                '\u{000426}'),
    ("Tab",                 '\u{000009}'),
    ("Tau",                 '\u{0003A4}'),
    ("Tcaron",              '\u{000164}'),
    ("Tcedil",              '\u{000162}'),
    ("Tcy",                 '\u{000422}'),
    ("Tfr",                 '\u{01D517}'),
    ("Therefore",           '\u{002234}'),
    ("Theta",               '\u{000398}'),
    ("ThinSpace",           '\u{002009}'),
    ("Tilde",               '\u{00223C}'),
    ("TildeEqual",          '\u{002243}'),
    ("TildeFullEqual",      '\u{002245}'),
    ("TildeTilde",          '\u{002248}'),
    ("Topf",                '\u{01D54B}'),
    ("TripleDot",           '\u{0020DB}'),
    ("Tscr",                '\u{01D4AF}'),
    ("Tstrok",              '\u{000166}'),
    ("Uacute",              '\u{0000DA}'),
    ("Uarr",                '\u{00219F}'),
    ("Uarrocir",            '\u{002949}'),
    ("Ubrcy",               '\u{00040E}'),
    ("Ubreve",              '\u{00016C}'),
    ("Ucirc",               '\u{0000DB}'),
    ("Ucy",                 '\u{000423}'),
    ("Udblac",              '\u{000170}'),
    ("Ufr",                 '\u{01D518}'),
    ("Ugrave",              '\u{0000D9}'),
    ("Umacr",               '\u{00016A}'),
    ("UnderBar",            '\u{00005F}'),
    ("UnderBrace",          '\u{0023DF}'),
    ("UnderBracket",        '\u{0023B5}'),
    ("UnderParenthesis",    '\u{0023DD}'),
    ("Union",               '\u{0022C3}'),
    ("UnionPlus",           '\u{00228E}'),
    ("Uogon",               '\u{000172}'),
    ("Uopf",                '\u{01D54C}'),
    ("UpArrow",             '\u{002191}'),
    ("UpArrowBar",          '\u{002912}'),
    ("UpArrowDownArrow",    '\u{0021C5}'),
    ("UpDownArrow",         '\u{002195}'),
    ("UpEquilibrium",       '\u{00296E}'),
    ("UpTee",               '\u{0022A5}'),
    ("UpTeeArrow",          '\u{0021A5}'),
    ("Uparrow",             '\u{0021D1}'),
    ("Updownarrow",         '\u{0021D5}'),
    ("UpperLeftArrow",      '\u{002196}'),
    ("UpperRightArrow",     '\u{002197}'),
    ("Upsi",                '\u{0003D2}'),
    ("Upsilon",             '\u{0003A5}'),
    ("Uring",               '\u{00016E}'),
    ("Uscr",                '\u{01D4B0}'),
    ("Utilde",              '\u{000168}'),
    ("Uuml",                '\u{0000DC}'),
    ("VDash",               '\u{0022AB}'),
    ("Vbar",                '\u{002AEB}'),
    ("Vcy",                 '\u{000412}'),
    ("Vdash",               '\u{0022A9}'),
    ("Vdashl",              '\u{002AE6}'),
    ("Vee",                 '\u{0022C1}'),
    ("Verbar",              '\u{002016}'),
    ("Vert",                '\u{002016}'),
    ("VerticalBar",         '\u{002223}'),
    ("VerticalLine",        '\u{00007C}'),
    ("VerticalSeparator",   '\u{002758}'),
    ("VerticalTilde",       '\u{002240}'),
    ("VeryThinSpace",       '\u{00200A}'),
    ("Vfr",                 '\u{01D519}'),
    ("Vopf",                '\u{01D54D}'),
    ("Vscr",                '\u{01D4B1}'),
    ("Vvdash",              '\u{0022AA}'),
    ("Wcirc",               '\u{000174}'),
    ("Wedge",               '\u{0022C0}'),
    ("Wfr",                 '\u{01D51A}'),
    ("Wopf",                '\u{01D54E}'),
    ("Wscr",                '\u{01D4B2}'),
    ("Xfr",                 '\u{01D51B}'),
    ("Xi",                  '\u{00039E}'),
    ("Xopf",                '\u{01D54F}'),
    ("Xscr",                '\u{01D4B3}'),
    ("YAcy",                '\u{00042F}'),
    ("YIcy",                '\u{000407}'),
    ("YUcy",                '\u{00042E}'),
    ("Yacute",              '\u{0000DD}'),
    ("Ycirc",               '\u{000176}'),
    ("Ycy",                 '\u{00042B}'),
    ("Yfr",                 '\u{01D51C}'),
    ("Yopf",                '\u{01D550}'),
    ("Yscr",                '\u{01D4B4}'),
    ("Yuml",                '\u{000178}'),
    ("ZHcy",                '\u{000416}'),
    ("Zacute",              '\u{000179}'),
    ("Zcaron",              '\u{00017D}'),
    ("Zcy",                 '\u{000417}'),
    ("Zdot",                '\u{00017B}'),
    ("ZeroWidthSpace",      '\u{00200B}'),
    ("Zeta",                '\u{000396}'),
    ("Zfr",                 '\u{002128}'),
    ("Zopf",                '\u{002124}'),
    ("Zscr",                '\u{01D4B5}'),
    ("aacute",              '\u{0000E1}'),
    ("abreve",              '\u{000103}'),
    ("ac",                  '\u{00223E}'),
    ("acd",                 '\u{00223F}'),
    ("acirc",               '\u{0000E2}'),
    ("acute",               '\u{0000B4}'),
    ("acy",                 '\u{000430}'),
    ("aelig",               '\u{0000E6}'),
    ("af",                  '\u{002061}'),
    ("afr",                 '\u{01D51E}'),
    ("agrave",              '\u{0000E0}'),
    ("alefsym",             '\u{002135}'),
    ("aleph",               '\u{002135}'),
    ("alpha",               '\u{0003B1}'),
    ("amacr",               '\u{000101}'),
    ("amalg",               '\u{002A3F}'),
    ("amp",                 '\u{000026}'),
    ("and",                 '\u{002227}'),
    ("andand",              '\u{002A55}'),
    ("andd",                '\u{002A5C}'),
    ("andslope",            '\u{002A58}'),
    ("andv",                '\u{002A5A}'),
    ("ang",                 '\u{002220}'),
    ("ange",                '\u{0029A4}'),
    ("angle",               '\u{002220}'),
    ("angmsd",              '\u{002221}'),
    ("angmsdaa",            '\u{0029A8}'),
    ("angmsdab",            '\u{0029A9}'),
    ("angmsdac",            '\u{0029AA}'),
    ("angmsdad",            '\u{0029AB}'),
    ("angmsdae",            '\u{0029AC}'),
    ("angmsdaf",            '\u{0029AD}'),
    ("angmsdag",            '\u{0029AE}'),
    ("angmsdah",            '\u{0029AF}'),
    ("angrt",               '\u{00221F}'),
    ("angrtvb",             '\u{0022BE}'),
    ("angrtvbd",            '\u{00299D}'),
    ("angsph",              '\u{002222}'),
    ("angst",               '\u{0000C5}'),
    ("angzarr",             '\u{00237C}'),
    ("aogon",               '\u{000105}'),
    ("aopf",                '\u{01D552}'),
    ("ap",                  '\u{002248}'),
    ("apE",                 '\u{002A70}'),
    ("apacir",              '\u{002A6F}'),
    ("ape",                 '\u{00224A}'),
    ("apid",                '\u{00224B}'),
    ("apos",                '\u{000027}'),
    ("approx",              '\u{002248}'),
    ("approxeq",            '\u{00224A}'),
    ("aring",               '\u{0000E5}'),
    ("ascr",                '\u{01D4B6}'),
    ("ast",                 '\u{00002A}'),
    ("asymp",               '\u{002248}'),
    ("asympeq",             '\u{00224D}'),
    ("atilde",              '\u{0000E3}'),
    ("auml",                '\u{0000E4}'),
    ("awconint",            '\u{002233}'),
    ("awint",               '\u{002A11}'),
    ("bNot",                '\u{002AED}'),
    ("backcong",            '\u{00224C}'),
    ("backepsilon",         '\u{0003F6}'),
    ("backprime",           '\u{002035}'),
    ("backsim",             '\u{00223D}'),
    ("backsimeq",           '\u{0022CD}'),
    ("barvee",              '\u{0022BD}'),
    ("barwed",              '\u{002305}'),
    ("barwedge",            '\u{002305}'),
    ("bbrk",                '\u{0023B5}'),
    ("bbrktbrk",            '\u{0023B6}'),
    ("bcong",               '\u{00224C}'),
    ("bcy",                 '\u{000431}'),
    ("bdquo",               '\u{00201E}'),
    ("becaus",              '\u{002235}'),
    ("because",             '\u{002235}'),
    ("bemptyv",             '\u{0029B0}'),
    ("bepsi",               '\u{0003F6}'),
    ("bernou",              '\u{00212C}'),
    ("beta",                '\u{0003B2}'),
    ("beth",                '\u{002136}'),
    ("between",             '\u{00226C}'),
    ("bfr",                 '\u{01D51F}'),
    ("bigcap",              '\u{0022C2}'),
    ("bigcirc",             '\u{0025EF}'),
    ("bigcup",              '\u{0022C3}'),
    ("bigodot",             '\u{002A00}'),
    ("bigoplus",            '\u{002A01}'),
    ("bigotimes",           '\u{002A02}'),
    ("bigsqcup",            '\u{002A06}'),
    ("bigstar",             '\u{002605}'),
    ("bigtriangledown",     '\u{0025BD}'),
    ("bigtriangleup",       '\u{0025B3}'),
    ("biguplus",            '\u{002A04}'),
    ("bigvee",              '\u{0022C1}'),
    ("bigwedge",            '\u{0022C0}'),
    ("bkarow",              '\u{00290D}'),
    ("blacklozenge",        '\u{0029EB}'),
    ("blacksquare",         '\u{0025AA}'),
    ("blacktriangle",       '\u{0025B4}'),
    ("blacktriangledown",   '\u{0025BE}'),
    ("blacktriangleleft",   '\u{0025C2}'),
    ("blacktriangleright",  '\u{0025B8}'),
    ("blank",               '\u{002423}'),
    ("blk12",               '\u{002592}'),
    ("blk14",               '\u{002591}'),
    ("blk34",               '\u{002593}'),
    ("block",               '\u{002588}'),
    ("bnot",                '\u{002310}'),
    ("bopf",                '\u{01D553}'),
    ("bot",                 '\u{0022A5}'),
    ("bottom",              '\u{0022A5}'),
    ("bowtie",              '\u{0022C8}'),
    ("boxDL",               '\u{002557}'),
    ("boxDR",               '\u{002554}'),
    ("boxDl",               '\u{002556}'),
    ("boxDr",               '\u{002553}'),
    ("boxH",                '\u{002550}'),
    ("boxHD",               '\u{002566}'),
    ("boxHU",               '\u{002569}'),
    ("boxHd",               '\u{002564}'),
    ("boxHu",               '\u{002567}'),
    ("boxUL",               '\u{00255D}'),
    ("boxUR",               '\u{00255A}'),
    ("boxUl",               '\u{00255C}'),
    ("boxUr",               '\u{002559}'),
    ("boxV",                '\u{002551}'),
    ("boxVH",               '\u{00256C}'),
    ("boxVL",               '\u{002563}'),
    ("boxVR",               '\u{002560}'),
    ("boxVh",               '\u{00256B}'),
    ("boxVl",               '\u{002562}'),
    ("boxVr",               '\u{00255F}'),
    ("boxbox",              '\u{0029C9}'),
    ("boxdL",               '\u{002555}'),
    ("boxdR",               '\u{002552}'),
    ("boxdl",               '\u{002510}'),
    ("boxdr",               '\u{00250C}'),
    ("boxh",                '\u{002500}'),
    ("boxhD",               '\u{002565}'),
    ("boxhU",               '\u{002568}'),
    ("boxhd",               '\u{00252C}'),
    ("boxhu",               '\u{002534}'),
    ("boxminus",            '\u{00229F}'),
    ("boxplus",             '\u{00229E}'),
    ("boxtimes",            '\u{0022A0}'),
    ("boxuL",               '\u{00255B}'),
    ("boxuR",               '\u{002558}'),
    ("boxul",               '\u{002518}'),
    ("boxur",               '\u{002514}'),
    ("boxv",                '\u{002502}'),
    ("boxvH",               '\u{00256A}'),
    ("boxvL",               '\u{002561}'),
    ("boxvR",               '\u{00255E}'),
    ("boxvh",               '\u{00253C}'),
    ("boxvl",               '\u{002524}'),
    ("boxvr",               '\u{00251C}'),
    ("bprime",              '\u{002035}'),
    ("breve",               '\u{0002D8}'),
    ("brvbar",              '\u{0000A6}'),
    ("bscr",                '\u{01D4B7}'),
    ("bsemi",               '\u{00204F}'),
    ("bsim",                '\u{00223D}'),
    ("bsime",               '\u{0022CD}'),
    ("bsol",                '\u{00005C}'),
    ("bsolb",               '\u{0029C5}'),
    ("bsolhsub",            '\u{0027C8}'),
    ("bull",                '\u{002022}'),
    ("bullet",              '\u{002022}'),
    ("bump",                '\u{00224E}'),
    ("bumpE",               '\u{002AAE}'),
    ("bumpe",               '\u{00224F}'),
    ("bumpeq",              '\u{00224F}'),
    ("cacute",              '\u{000107}'),
    ("cap",                 '\u{002229}'),
    ("capand",              '\u{002A44}'),
    ("capbrcup",            '\u{002A49}'),
    ("capcap",              '\u{002A4B}'),
    ("capcup",              '\u{002A47}'),
    ("capdot",              '\u{002A40}'),
    ("caret",               '\u{002041}'),
    ("caron",               '\u{0002C7}'),
    ("ccaps",               '\u{002A4D}'),
    ("ccaron",              '\u{00010D}'),
    ("ccedil",              '\u{0000E7}'),
    ("ccirc",               '\u{000109}'),
    ("ccups",               '\u{002A4C}'),
    ("ccupssm",             '\u{002A50}'),
    ("cdot",                '\u{00010B}'),
    ("cedil",               '\u{0000B8}'),
    ("cemptyv",             '\u{0029B2}'),
    ("cent",                '\u{0000A2}'),
    ("centerdot",           '\u{0000B7}'),
    ("cfr",                 '\u{01D520}'),
    ("chcy",                '\u{000447}'),
    ("check",               '\u{002713}'),
    ("checkmark",           '\u{002713}'),
    ("chi",                 '\u{0003C7}'),
    ("cir",                 '\u{0025CB}'),
    ("cirE",                '\u{0029C3}'),
    ("circ",                '\u{0002C6}'),
    ("circeq",              '\u{002257}'),
    ("circlearrowleft",     '\u{0021BA}'),
    ("circlearrowright",    '\u{0021BB}'),
    ("circledR",            '\u{0000AE}'),
    ("circledS",            '\u{0024C8}'),
    ("circledast",          '\u{00229B}'),
    ("circledcirc",         '\u{00229A}'),
    ("circleddash",         '\u{00229D}'),
    ("cire",                '\u{002257}'),
    ("cirfnint",            '\u{002A10}'),
    ("cirmid",              '\u{002AEF}'),
    ("cirscir",             '\u{0029C2}'),
    ("clubs",               '\u{002663}'),
    ("clubsuit",            '\u{002663}'),
    ("colon",               '\u{00003A}'),
    ("colone",              '\u{002254}'),
    ("coloneq",             '\u{002254}'),
    ("comma",               '\u{00002C}'),
    ("commat",              '\u{000040}'),
    ("comp",                '\u{002201}'),
    ("compfn",              '\u{002218}'),
    ("complement",          '\u{002201}'),
    ("complexes",           '\u{002102}'),
    ("cong",                '\u{002245}'),
    ("congdot",             '\u{002A6D}'),
    ("conint",              '\u{00222E}'),
    ("copf",                '\u{01D554}'),
    ("coprod",              '\u{002210}'),
    ("copy",                '\u{0000A9}'),
    ("copysr",              '\u{002117}'),
    ("crarr",               '\u{0021B5}'),
    ("cross",               '\u{002717}'),
    ("cscr",                '\u{01D4B8}'),
    ("csub",                '\u{002ACF}'),
    ("csube",               '\u{002AD1}'),
    ("csup",                '\u{002AD0}'),
    ("csupe",               '\u{002AD2}'),
    ("ctdot",               '\u{0022EF}'),
    ("cudarrl",             '\u{002938}'),
    ("cudarrr",             '\u{002935}'),
    ("cuepr",               '\u{0022DE}'),
    ("cuesc",               '\u{0022DF}'),
    ("cularr",              '\u{0021B6}'),
    ("cularrp",             '\u{00293D}'),
    ("cup",                 '\u{00222A}'),
    ("cupbrcap",            '\u{002A48}'),
    ("cupcap",              '\u{002A46}'),
    ("cupcup",              '\u{002A4A}'),
    ("cupdot",              '\u{00228D}'),
    ("cupor",               '\u{002A45}'),
    ("curarr",              '\u{0021B7}'),
    ("curarrm",             '\u{00293C}'),
    ("curlyeqprec",         '\u{0022DE}'),
    ("curlyeqsucc",         '\u{0022DF}'),
    ("curlyvee",            '\u{0022CE}'),
    ("curlywedge",          '\u{0022CF}'),
    ("curren",              '\u{0000A4}'),
    ("curvearrowleft",      '\u{0021B6}'),
    ("curvearrowright",     '\u{0021B7}'),
    ("cuvee",               '\u{0022CE}'),
    ("cuwed",               '\u{0022CF}'),
    ("cwconint",            '\u{002232}'),
    ("cwint",               '\u{002231}'),
    ("cylcty",              '\u{00232D}'),
    ("dArr",                '\u{0021D3}'),
    ("dHar",                '\u{002965}'),
    ("dagger",              '\u{002020}'),
    ("daleth",              '\u{002138}'),
    ("darr",                '\u{002193}'),
    ("dash",                '\u{002010}'),
    ("dashv",               '\u{0022A3}'),
    ("dbkarow",             '\u{00290F}'),
    ("dblac",               '\u{0002DD}'),
    ("dcaron",              '\u{00010F}'),
    ("dcy",                 '\u{000434}'),
    ("dd",                  '\u{002146}'),
    ("ddagger",             '\u{002021}'),
    ("ddarr",               '\u{0021CA}'),
    ("ddotseq",             '\u{002A77}'),
    ("deg",                 '\u{0000B0}'),
    ("delta",               '\u{0003B4}'),
    ("demptyv",             '\u{0029B1}'),
    ("dfisht",              '\u{00297F}'),
    ("dfr",                 '\u{01D521}'),
    ("dharl",               '\u{0021C3}'),
    ("dharr",               '\u{0021C2}'),
    ("diam",                '\u{0022C4}'),
    ("diamond",             '\u{0022C4}'),
    ("diamondsuit",         '\u{002666}'),
    ("diams",               '\u{002666}'),
    ("die",                 '\u{0000A8}'),
    ("digamma",             '\u{0003DD}'),
    ("disin",               '\u{0022F2}'),
    ("div",                 '\u{0000F7}'),
    ("divide",              '\u{0000F7}'),
    ("divideontimes",       '\u{0022C7}'),
    ("divonx",              '\u{0022C7}'),
    ("djcy",                '\u{000452}'),
    ("dlcorn",              '\u{00231E}'),
    ("dlcrop",              '\u{00230D}'),
    ("dollar",              '\u{000024}'),
    ("dopf",                '\u{01D555}'),
    ("dot",                 '\u{0002D9}'),
    ("doteq",               '\u{002250}'),
    ("doteqdot",            '\u{002251}'),
    ("dotminus",            '\u{002238}'),
    ("dotplus",             '\u{002214}'),
    ("dotsquare",           '\u{0022A1}'),
    ("doublebarwedge",      '\u{002306}'),
    ("downarrow",           '\u{002193}'),
    ("downdownarrows",      '\u{0021CA}'),
    ("downharpoonleft",     '\u{0021C3}'),
    ("downharpoonright",    '\u{0021C2}'),
    ("drbkarow",            '\u{002910}'),
    ("drcorn",              '\u{00231F}'),
    ("drcrop",              '\u{00230C}'),
    ("dscr",                '\u{01D4B9}'),
    ("dscy",                '\u{000455}'),
    ("dsol",                '\u{0029F6}'),
    ("dstrok",              '\u{000111}'),
    ("dtdot",               '\u{0022F1}'),
    ("dtri",                '\u{0025BF}'),
    ("dtrif",               '\u{0025BE}'),
    ("duarr",               '\u{0021F5}'),
    ("duhar",               '\u{00296F}'),
    ("dwangle",             '\u{0029A6}'),
    ("dzcy",                '\u{00045F}'),
    ("dzigrarr",            '\u{0027FF}'),
    ("eDDot",               '\u{002A77}'),
    ("eDot",                '\u{002251}'),
    ("eacute",              '\u{0000E9}'),
    ("easter",              '\u{002A6E}'),
    ("ecaron",              '\u{00011B}'),
    ("ecir",                '\u{002256}'),
    ("ecirc",               '\u{0000EA}'),
    ("ecolon",              '\u{002255}'),
    ("ecy",                 '\u{00044D}'),
    ("edot",                '\u{000117}'),
    ("ee",                  '\u{002147}'),
    ("efDot",               '\u{002252}'),
    ("efr",                 '\u{01D522}'),
    ("eg",                  '\u{002A9A}'),
    ("egrave",              '\u{0000E8}'),
    ("egs",                 '\u{002A96}'),
    ("egsdot",              '\u{002A98}'),
    ("el",                  '\u{002A99}'),
    ("elinters",            '\u{0023E7}'),
    ("ell",                 '\u{002113}'),
    ("els",                 '\u{002A95}'),
    ("elsdot",              '\u{002A97}'),
    ("emacr",               '\u{000113}'),
    ("empty",               '\u{002205}'),
    ("emptyset",            '\u{002205}'),
    ("emptyv",              '\u{002205}'),
    ("emsp",                '\u{002003}'),
    ("emsp13",              '\u{002004}'),
    ("emsp14",              '\u{002005}'),
    ("eng",                 '\u{00014B}'),
    ("ensp",                '\u{002002}'),
    ("eogon",               '\u{000119}'),
    ("eopf",                '\u{01D556}'),
    ("epar",                '\u{0022D5}'),
    ("eparsl",              '\u{0029E3}'),
    ("eplus",               '\u{002A71}'),
    ("epsi",                '\u{0003B5}'),
    ("epsilon",             '\u{0003B5}'),
    ("epsiv",               '\u{0003F5}'),
    ("eqcirc",              '\u{002256}'),
    ("eqcolon",             '\u{002255}'),
    ("eqsim",               '\u{002242}'),
    ("eqslantgtr",          '\u{002A96}'),
    ("eqslantless",         '\u{002A95}'),
    ("equals",              '\u{00003D}'),
    ("equest",              '\u{00225F}'),
    ("equiv",               '\u{002261}'),
    ("equivDD",             '\u{002A78}'),
    ("eqvparsl",            '\u{0029E5}'),
    ("erDot",               '\u{002253}'),
    ("erarr",               '\u{002971}'),
    ("escr",                '\u{00212F}'),
    ("esdot",               '\u{002250}'),
    ("esim",                '\u{002242}'),
    ("eta",                 '\u{0003B7}'),
    ("eth",                 '\u{0000F0}'),
    ("euml",                '\u{0000EB}'),
    ("euro",                '\u{0020AC}'),
    ("excl",                '\u{000021}'),
    ("exist",               '\u{002203}'),
    ("expectation",         '\u{002130}'),
    ("exponentiale",        '\u{002147}'),
    ("fallingdotseq",       '\u{002252}'),
    ("fcy",                 '\u{000444}'),
    ("female",              '\u{002640}'),
    ("ffilig",              '\u{00FB03}'),
    ("fflig",               '\u{00FB00}'),
    ("ffllig",              '\u{00FB04}'),
    ("ffr",                 '\u{01D523}'),
    ("filig",               '\u{00FB01}'),
    ("flat",                '\u{00266D}'),
    ("fllig",               '\u{00FB02}'),
    ("fltns",               '\u{0025B1}'),
    ("fnof",                '\u{000192}'),
    ("fopf",                '\u{01D557}'),
    ("forall",              '\u{002200}'),
    ("fork",                '\u{0022D4}'),
    ("forkv",               '\u{002AD9}'),
    ("fpartint",            '\u{002A0D}'),
    ("frac12",              '\u{0000BD}'),
    ("frac13",              '\u{002153}'),
    ("frac14",              '\u{0000BC}'),
    ("frac15",              '\u{002155}'),
    ("frac16",              '\u{002159}'),
    ("frac18",              '\u{00215B}'),
    ("frac23",              '\u{002154}'),
    ("frac25",              '\u{002156}'),
    ("frac34",              '\u{0000BE}'),
    ("frac35",              '\u{002157}'),
    ("frac38",              '\u{00215C}'),
    ("frac45",              '\u{002158}'),
    ("frac56",              '\u{00215A}'),
    ("frac58",              '\u{00215D}'),
    ("frac78",              '\u{00215E}'),
    ("frasl",               '\u{002044}'),
    ("frown",               '\u{002322}'),
    ("fscr",                '\u{01D4BB}'),
    ("gE",                  '\u{002267}'),
    ("gEl",                 '\u{002A8C}'),
    ("gacute",              '\u{0001F5}'),
    ("gamma",               '\u{0003B3}'),
    ("gammad",              '\u{0003DD}'),
    ("gap",                 '\u{002A86}'),
    ("gbreve",              '\u{00011F}'),
    ("gcirc",               '\u{00011D}'),
    ("gcy",                 '\u{000433}'),
    ("gdot",                '\u{000121}'),
    ("ge",                  '\u{002265}'),
    ("gel",                 '\u{0022DB}'),
    ("geq",                 '\u{002265}'),
    ("geqq",                '\u{002267}'),
    ("geqslant",            '\u{002A7E}'),
    ("ges",                 '\u{002A7E}'),
    ("gescc",               '\u{002AA9}'),
    ("gesdot",              '\u{002A80}'),
    ("gesdoto",             '\u{002A82}'),
    ("gesdotol",            '\u{002A84}'),
    ("gesles",              '\u{002A94}'),
    ("gfr",                 '\u{01D524}'),
    ("gg",                  '\u{00226B}'),
    ("ggg",                 '\u{0022D9}'),
    ("gimel",               '\u{002137}'),
    ("gjcy",                '\u{000453}'),
    ("gl",                  '\u{002277}'),
    ("glE",                 '\u{002A92}'),
    ("gla",                 '\u{002AA5}'),
    ("glj",                 '\u{002AA4}'),
    ("gnE",                 '\u{002269}'),
    ("gnap",                '\u{002A8A}'),
    ("gnapprox",            '\u{002A8A}'),
    ("gne",                 '\u{002A88}'),
    ("gneq",                '\u{002A88}'),
    ("gneqq",               '\u{002269}'),
    ("gnsim",               '\u{0022E7}'),
    ("gopf",                '\u{01D558}'),
    ("grave",               '\u{000060}'),
    ("gscr",                '\u{00210A}'),
    ("gsim",                '\u{002273}'),
    ("gsime",               '\u{002A8E}'),
    ("gsiml",               '\u{002A90}'),
    ("gt",                  '\u{00003E}'),
    ("gtcc",                '\u{002AA7}'),
    ("gtcir",               '\u{002A7A}'),
    ("gtdot",               '\u{0022D7}'),
    ("gtlPar",              '\u{002995}'),
    ("gtquest",             '\u{002A7C}'),
    ("gtrapprox",           '\u{002A86}'),
    ("gtrarr",              '\u{002978}'),
    ("gtrdot",              '\u{0022D7}'),
    ("gtreqless",           '\u{0022DB}'),
    ("gtreqqless",          '\u{002A8C}'),
    ("gtrless",             '\u{002277}'),
    ("gtrsim",              '\u{002273}'),
    ("hArr",                '\u{0021D4}'),
    ("hairsp",              '\u{00200A}'),
    ("half",                '\u{0000BD}'),
    ("hamilt",              '\u{00210B}'),
    ("hardcy",              '\u{00044A}'),
    ("harr",                '\u{002194}'),
    ("harrcir",             '\u{002948}'),
    ("harrw",               '\u{0021AD}'),
    ("hbar",                '\u{00210F}'),
    ("hcirc",               '\u{000125}'),
    ("hearts",              '\u{002665}'),
    ("heartsuit",           '\u{002665}'),
    ("hellip",              '\u{002026}'),
    ("hercon",              '\u{0022B9}'),
    ("hfr",                 '\u{01D525}'),
    ("hksearow",            '\u{002925}'),
    ("hkswarow",            '\u{002926}'),
    ("hoarr",               '\u{0021FF}'),
    ("homtht",              '\u{00223B}'),
    ("hookleftarrow",       '\u{0021A9}'),
    ("hookrightarrow",      '\u{0021AA}'),
    ("hopf",                '\u{01D559}'),
    ("horbar",              '\u{002015}'),
    ("hscr",                '\u{01D4BD}'),
    ("hslash",              '\u{00210F}'),
    ("hstrok",              '\u{000127}'),
    ("hybull",              '\u{002043}'),
    ("hyphen",              '\u{002010}'),
    ("iacute",              '\u{0000ED}'),
    ("ic",                  '\u{002063}'),
    ("icirc",               '\u{0000EE}'),
    ("icy",                 '\u{000438}'),
    ("iecy",                '\u{000435}'),
    ("iexcl",               '\u{0000A1}'),
    ("iff",                 '\u{0021D4}'),
    ("ifr",                 '\u{01D526}'),
    ("igrave",              '\u{0000EC}'),
    ("ii",                  '\u{002148}'),
    ("iiiint",              '\u{002A0C}'),
    ("iiint",               '\u{00222D}'),
    ("iinfin",              '\u{0029DC}'),
    ("iiota",               '\u{002129}'),
    ("ijlig",               '\u{000133}'),
    ("imacr",               '\u{00012B}'),
    ("image",               '\u{002111}'),
    ("imagline",            '\u{002110}'),
    ("imagpart",            '\u{002111}'),
    ("imath",               '\u{000131}'),
    ("imof",                '\u{0022B7}'),
    ("imped",               '\u{0001B5}'),
    ("in",                  '\u{002208}'),
    ("incare",              '\u{002105}'),
    ("infin",               '\u{00221E}'),
    ("infintie",            '\u{0029DD}'),
    ("inodot",              '\u{000131}'),
    ("int",                 '\u{00222B}'),
    ("intcal",              '\u{0022BA}'),
    ("integers",            '\u{002124}'),
    ("intercal",            '\u{0022BA}'),
    ("intlarhk",            '\u{002A17}'),
    ("intprod",             '\u{002A3C}'),
    ("iocy",                '\u{000451}'),
    ("iogon",               '\u{00012F}'),
    ("iopf",                '\u{01D55A}'),
    ("iota",                '\u{0003B9}'),
    ("iprod",               '\u{002A3C}'),
    ("iquest",              '\u{0000BF}'),
    ("iscr",                '\u{01D4BE}'),
    ("isin",                '\u{002208}'),
    ("isinE",               '\u{0022F9}'),
    ("isindot",             '\u{0022F5}'),
    ("isins",               '\u{0022F4}'),
    ("isinsv",              '\u{0022F3}'),
    ("isinv",               '\u{002208}'),
    ("it",                  '\u{002062}'),
    ("itilde",              '\u{000129}'),
    ("iukcy",               '\u{000456}'),
    ("iuml",                '\u{0000EF}'),
    ("jcirc",               '\u{000135}'),
    ("jcy",                 '\u{000439}'),
    ("jfr",                 '\u{01D527}'),
    ("jmath",               '\u{000237}'),
    ("jopf",                '\u{01D55B}'),
    ("jscr",                '\u{01D4BF}'),
    ("jsercy",              '\u{000458}'),
    ("jukcy",               '\u{000454}'),
    ("kappa",               '\u{0003BA}'),
    ("kappav",              '\u{0003F0}'),
    ("kcedil",              '\u{000137}'),
    ("kcy",                 '\u{00043A}'),
    ("kfr",                 '\u{01D528}'),
    ("kgreen",              '\u{000138}'),
    ("khcy",                '\u{000445}'),
    ("kjcy",                '\u{00045C}'),
    ("kopf",                '\u{01D55C}'),
    ("kscr",                '\u{01D4C0}'),
    ("lAarr",               '\u{0021DA}'),
    ("lArr",                '\u{0021D0}'),
    ("lAtail",              '\u{00291B}'),
    ("lBarr",               '\u{00290E}'),
    ("lE",                  '\u{002266}'),
    ("lEg",                 '\u{002A8B}'),
    ("lHar",                '\u{002962}'),
    ("lacute",              '\u{00013A}'),
    ("laemptyv",            '\u{0029B4}'),
    ("lagran",              '\u{002112}'),
    ("lambda",              '\u{0003BB}'),
    ("lang",                '\u{0027E8}'),
    ("langd",               '\u{002991}'),
    ("langle",              '\u{0027E8}'),
    ("lap",                 '\u{002A85}'),
    ("laquo",               '\u{0000AB}'),
    ("larr",                '\u{002190}'),
    ("larrb",               '\u{0021E4}'),
    ("larrbfs",             '\u{00291F}'),
    ("larrfs",              '\u{00291D}'),
    ("larrhk",              '\u{0021A9}'),
    ("larrlp",              '\u{0021AB}'),
    ("larrpl",              '\u{002939}'),
    ("larrsim",             '\u{002973}'),
    ("larrtl",              '\u{0021A2}'),
    ("lat",                 '\u{002AAB}'),
    ("latail",              '\u{002919}'),
    ("late",                '\u{002AAD}'),
    ("lbarr",               '\u{00290C}'),
    ("lbbrk",               '\u{002772}'),
    ("lbrace",              '\u{00007B}'),
    ("lbrack",              '\u{00005B}'),
    ("lbrke",               '\u{00298B}'),
    ("lbrksld",             '\u{00298F}'),
    ("lbrkslu",             '\u{00298D}'),
    ("lcaron",              '\u{00013E}'),
    ("lcedil",              '\u{00013C}'),
    ("lceil",               '\u{002308}'),
    ("lcub",                '\u{00007B}'),
    ("lcy",                 '\u{00043B}'),
    ("ldca",                '\u{002936}'),
    ("ldquo",               '\u{00201C}'),
    ("ldquor",              '\u{00201E}'),
    ("ldrdhar",             '\u{002967}'),
    ("ldrushar",            '\u{00294B}'),
    ("ldsh",                '\u{0021B2}'),
    ("le",                  '\u{002264}'),
    ("leftarrow",           '\u{002190}'),
    ("leftarrowtail",       '\u{0021A2}'),
    ("leftharpoondown",     '\u{0021BD}'),
    ("leftharpoonup",       '\u{0021BC}'),
    ("leftleftarrows",      '\u{0021C7}'),
    ("leftrightarrow",      '\u{002194}'),
    ("leftrightarrows",     '\u{0021C6}'),
    ("leftrightharpoons",   '\u{0021CB}'),
    ("leftrightsquigarrow", '\u{0021AD}'),
    ("leftthreetimes",      '\u{0022CB}'),
    ("leg",                 '\u{0022DA}'),
    ("leq",                 '\u{002264}'),
    ("leqq",                '\u{002266}'),
    ("leqslant",            '\u{002A7D}'),
    ("les",                 '\u{002A7D}'),
    ("lescc",               '\u{002AA8}'),
    ("lesdot",              '\u{002A7F}'),
    ("lesdoto",             '\u{002A81}'),
    ("lesdotor",            '\u{002A83}'),
    ("lesges",              '\u{002A93}'),
    ("lessapprox",          '\u{002A85}'),
    ("lessdot",             '\u{0022D6}'),
    ("lesseqgtr",           '\u{0022DA}'),
    ("lesseqqgtr",          '\u{002A8B}'),
    ("lessgtr",             '\u{002276}'),
    ("lesssim",             '\u{002272}'),
    ("lfisht",              '\u{00297C}'),
    ("lfloor",              '\u{00230A}'),
    ("lfr",                 '\u{01D529}'),
    ("lg",                  '\u{002276}'),
    ("lgE",                 '\u{002A91}'),
    ("lhard",               '\u{0021BD}'),
    ("lharu",               '\u{0021BC}'),
    ("lharul",              '\u{00296A}'),
    ("lhblk",               '\u{002584}'),
    ("ljcy",                '\u{000459}'),
    ("ll",                  '\u{00226A}'),
    ("llarr",               '\u{0021C7}'),
    ("llcorner",            '\u{00231E}'),
    ("llhard",              '\u{00296B}'),
    ("lltri",               '\u{0025FA}'),
    ("lmidot",              '\u{000140}'),
    ("lmoust",              '\u{0023B0}'),
    ("lmoustache",          '\u{0023B0}'),
    ("lnE",                 '\u{002268}'),
    ("lnap",                '\u{002A89}'),
    ("lnapprox",            '\u{002A89}'),
    ("lne",                 '\u{002A87}'),
    ("lneq",                '\u{002A87}'),
    ("lneqq",               '\u{002268}'),
    ("lnsim",               '\u{0022E6}'),
    ("loang",               '\u{0027EC}'),
    ("loarr",               '\u{0021FD}'),
    ("lobrk",               '\u{0027E6}'),
    ("longleftarrow",       '\u{0027F5}'),
    ("longleftrightarrow",  '\u{0027F7}'),
    ("longmapsto",          '\u{0027FC}'),
    ("longrightarrow",      '\u{0027F6}'),
    ("looparrowleft",       '\u{0021AB}'),
    ("looparrowright",      '\u{0021AC}'),
    ("lopar",               '\u{002985}'),
    ("lopf",                '\u{01D55D}'),
    ("loplus",              '\u{002A2D}'),
    ("lotimes",             '\u{002A34}'),
    ("lowast",              '\u{002217}'),
    ("lowbar",              '\u{00005F}'),
    ("loz",                 '\u{0025CA}'),
    ("lozenge",             '\u{0025CA}'),
    ("lozf",                '\u{0029EB}'),
    ("lpar",                '\u{000028}'),
    ("lparlt",              '\u{002993}'),
    ("lrarr",               '\u{0021C6}'),
    ("lrcorner",            '\u{00231F}'),
    ("lrhar",               '\u{0021CB}'),
    ("lrhard",              '\u{00296D}'),
    ("lrm",                 '\u{00200E}'),
    ("lrtri",               '\u{0022BF}'),
    ("lsaquo",              '\u{002039}'),
    ("lscr",                '\u{01D4C1}'),
    ("lsh",                 '\u{0021B0}'),
    ("lsim",                '\u{002272}'),
    ("lsime",               '\u{002A8D}'),
    ("lsimg",               '\u{002A8F}'),
    ("lsqb",                '\u{00005B}'),
    ("lsquo",               '\u{002018}'),
    ("lsquor",              '\u{00201A}'),
    ("lstrok",              '\u{000142}'),
    ("lt",                  '\u{00003C}'),
    ("ltcc",                '\u{002AA6}'),
    ("ltcir",               '\u{002A79}'),
    ("ltdot",               '\u{0022D6}'),
    ("lthree",              '\u{0022CB}'),
    ("ltimes",              '\u{0022C9}'),
    ("ltlarr",              '\u{002976}'),
    ("ltquest",             '\u{002A7B}'),
    ("ltrPar",              '\u{002996}'),
    ("ltri",                '\u{0025C3}'),
    ("ltrie",               '\u{0022B4}'),
    ("ltrif",               '\u{0025C2}'),
    ("lurdshar",            '\u{00294A}'),
    ("luruhar",             '\u{002966}'),
    ("mDDot",               '\u{00223A}'),
    ("macr",                '\u{0000AF}'),
    ("male",                '\u{002642}'),
    ("malt",                '\u{002720}'),
    ("maltese",             '\u{002720}'),
    ("map",                 '\u{0021A6}'),
    ("mapsto",              '\u{0021A6}'),
    ("mapstodown",          '\u{0021A7}'),
    ("mapstoleft",          '\u{0021A4}'),
    ("mapstoup",            '\u{0021A5}'),
    ("marker",              '\u{0025AE}'),
    ("mcomma",              '\u{002A29}'),
    ("mcy",                 '\u{00043C}'),
    ("mdash",               '\u{002014}'),
    ("measuredangle",       '\u{002221}'),
    ("mfr",                 '\u{01D52A}'),
    ("mho",                 '\u{002127}'),
    ("micro",               '\u{0000B5}'),
    ("mid",                 '\u{002223}'),
    ("midast",              '\u{00002A}'),
    ("midcir",              '\u{002AF0}'),
    ("middot",              '\u{0000B7}'),
    ("minus",               '\u{002212}'),
    ("minusb",              '\u{00229F}'),
    ("minusd",              '\u{002238}'),
    ("minusdu",             '\u{002A2A}'),
    ("mlcp",                '\u{002ADB}'),
    ("mldr",                '\u{002026}'),
    ("mnplus",              '\u{002213}'),
    ("models",              '\u{0022A7}'),
    ("mopf",                '\u{01D55E}'),
    ("mp",                  '\u{002213}'),
    ("mscr",                '\u{01D4C2}'),
    ("mstpos",              '\u{00223E}'),
    ("mu",                  '\u{0003BC}'),
    ("multimap",            '\u{0022B8}'),
    ("mumap",               '\u{0022B8}'),
    ("nLeftarrow",          '\u{0021CD}'),
    ("nLeftrightarrow",     '\u{0021CE}'),
    ("nRightarrow",         '\u{0021CF}'),
    ("nVDash",              '\u{0022AF}'),
    ("nVdash",              '\u{0022AE}'),
    ("nabla",               '\u{002207}'),
    ("nacute",              '\u{000144}'),
    ("nap",                 '\u{002249}'),
    ("napos",               '\u{000149}'),
    ("napprox",             '\u{002249}'),
    ("natur",               '\u{00266E}'),
    ("natural",             '\u{00266E}'),
    ("naturals",            '\u{002115}'),
    ("nbsp",                '\u{0000A0}'),
    ("ncap",                '\u{002A43}'),
    ("ncaron",              '\u{000148}'),
    ("ncedil",              '\u{000146}'),
    ("ncong",               '\u{002247}'),
    ("ncup",                '\u{002A42}'),
    ("ncy",                 '\u{00043D}'),
    ("ndash",               '\u{002013}'),
    ("ne",                  '\u{002260}'),
    ("neArr",               '\u{0021D7}'),
    ("nearhk",              '\u{002924}'),
    ("nearr",               '\u{002197}'),
    ("nearrow",             '\u{002197}'),
    ("nequiv",              '\u{002262}'),
    ("nesear",              '\u{002928}'),
    ("nexist",              '\u{002204}'),
    ("nexists",             '\u{002204}'),
    ("nfr",                 '\u{01D52B}'),
    ("nge",                 '\u{002271}'),
    ("ngeq",                '\u{002271}'),
    ("ngsim",               '\u{002275}'),
    ("ngt",                 '\u{00226F}'),
    ("ngtr",                '\u{00226F}'),
    ("nhArr",               '\u{0021CE}'),
    ("nharr",               '\u{0021AE}'),
    ("nhpar",               '\u{002AF2}'),
    ("ni",                  '\u{00220B}'),
    ("nis",                 '\u{0022FC}'),
    ("nisd",                '\u{0022FA}'),
    ("niv",                 '\u{00220B}'),
    ("njcy",                '\u{00045A}'),
    ("nlArr",               '\u{0021CD}'),
    ("nlarr",               '\u{00219A}'),
    ("nldr",                '\u{002025}'),
    ("nle",                 '\u{002270}'),
    ("nleftarrow",          '\u{00219A}'),
    ("nleftrightarrow",     '\u{0021AE}'),
    ("nleq",                '\u{002270}'),
    ("nless",               '\u{00226E}'),
    ("nlsim",               '\u{002274}'),
    ("nlt",                 '\u{00226E}'),
    ("nltri",               '\u{0022EA}'),
    ("nltrie",              '\u{0022EC}'),
    ("nmid",                '\u{002224}'),
    ("nopf",                '\u{01D55F}'),
    ("not",                 '\u{0000AC}'),
    ("notin",               '\u{002209}'),
    ("notinva",             '\u{002209}'),
    ("notinvb",             '\u{0022F7}'),
    ("notinvc",             '\u{0022F6}'),
    ("notni",               '\u{00220C}'),
    ("notniva",             '\u{00220C}'),
    ("notnivb",             '\u{0022FE}'),
    ("notnivc",             '\u{0022FD}'),
    ("npar",                '\u{002226}'),
    ("nparallel",           '\u{002226}'),
    ("npolint",             '\u{002A14}'),
    ("npr",                 '\u{002280}'),
    ("nprcue",              '\u{0022E0}'),
    ("nprec",               '\u{002280}'),
    ("nrArr",               '\u{0021CF}'),
    ("nrarr",               '\u{00219B}'),
    ("nrightarrow",         '\u{00219B}'),
    ("nrtri",               '\u{0022EB}'),
    ("nrtrie",              '\u{0022ED}'),
    ("nsc",                 '\u{002281}'),
    ("nsccue",              '\u{0022E1}'),
    ("nscr",                '\u{01D4C3}'),
    ("nshortmid",           '\u{002224}'),
    ("nshortparallel",      '\u{002226}'),
    ("nsim",                '\u{002241}'),
    ("nsime",               '\u{002244}'),
    ("nsimeq",              '\u{002244}'),
    ("nsmid",               '\u{002224}'),
    ("nspar",               '\u{002226}'),
    ("nsqsube",             '\u{0022E2}'),
    ("nsqsupe",             '\u{0022E3}'),
    ("nsub",                '\u{002284}'),
    ("nsube",               '\u{002288}'),
    ("nsubseteq",           '\u{002288}'),
    ("nsucc",               '\u{002281}'),
    ("nsup",                '\u{002285}'),
    ("nsupe",               '\u{002289}'),
    ("nsupseteq",           '\u{002289}'),
    ("ntgl",                '\u{002279}'),
    ("ntilde",              '\u{0000F1}'),
    ("ntlg",                '\u{002278}'),
    ("ntriangleleft",       '\u{0022EA}'),
    ("ntrianglelefteq",     '\u{0022EC}'),
    ("ntriangleright",      '\u{0022EB}'),
    ("ntrianglerighteq",    '\u{0022ED}'),
    ("nu",                  '\u{0003BD}'),
    ("num",                 '\u{000023}'),
    ("numero",              '\u{002116}'),
    ("numsp",               '\u{002007}'),
    ("nvDash",              '\u{0022AD}'),
    ("nvHarr",              '\u{002904}'),
    ("nvdash",              '\u{0022AC}'),
    ("nvinfin",             '\u{0029DE}'),
    ("nvlArr",              '\u{002902}'),
    ("nvrArr",              '\u{002903}'),
    ("nwArr",               '\u{0021D6}'),
    ("nwarhk",              '\u{002923}'),
    ("nwarr",               '\u{002196}'),
    ("nwarrow",             '\u{002196}'),
    ("nwnear",              '\u{002927}'),
    ("oS",                  '\u{0024C8}'),
    ("oacute",              '\u{0000F3}'),
    ("oast",                '\u{00229B}'),
    ("ocir",                '\u{00229A}'),
    ("ocirc",               '\u{0000F4}'),
    ("ocy",                 '\u{00043E}'),
    ("odash",               '\u{00229D}'),
    ("odblac",              '\u{000151}'),
    ("odiv",                '\u{002A38}'),
    ("odot",                '\u{002299}'),
    ("odsold",              '\u{0029BC}'),
    ("oelig",               '\u{000153}'),
    ("ofcir",               '\u{0029BF}'),
    ("ofr",                 '\u{01D52C}'),
    ("ogon",                '\u{0002DB}'),
    ("ograve",              '\u{0000F2}'),
    ("ogt",                 '\u{0029C1}'),
    ("ohbar",               '\u{0029B5}'),
    ("ohm",                 '\u{0003A9}'),
    ("oint",                '\u{00222E}'),
    ("olarr",               '\u{0021BA}'),
    ("olcir",               '\u{0029BE}'),
    ("olcross",             '\u{0029BB}'),
    ("oline",               '\u{00203E}'),
    ("olt",                 '\u{0029C0}'),
    ("omacr",               '\u{00014D}'),
    ("omega",               '\u{0003C9}'),
    ("omicron",             '\u{0003BF}'),
    ("omid",                '\u{0029B6}'),
    ("ominus",              '\u{002296}'),
    ("oopf",                '\u{01D560}'),
    ("opar",                '\u{0029B7}'),
    ("operp",               '\u{0029B9}'),
    ("oplus",               '\u{002295}'),
    ("or",                  '\u{002228}'),
    ("orarr",               '\u{0021BB}'),
    ("ord",                 '\u{002A5D}'),
    ("order",               '\u{002134}'),
    ("orderof",             '\u{002134}'),
    ("ordf",                '\u{0000AA}'),
    ("ordm",                '\u{0000BA}'),
    ("origof",              '\u{0022B6}'),
    ("oror",                '\u{002A56}'),
    ("orslope",             '\u{002A57}'),
    ("orv",                 '\u{002A5B}'),
    ("oscr",                '\u{002134}'),
    ("oslash",              '\u{0000F8}'),
    ("osol",                '\u{002298}'),
    ("otilde",              '\u{0000F5}'),
    ("otimes",              '\u{002297}'),
    ("otimesas",            '\u{002A36}'),
    ("ouml",                '\u{0000F6}'),
    ("ovbar",               '\u{00233D}'),
    ("par",                 '\u{002225}'),
    ("para",                '\u{0000B6}'),
    ("parallel",            '\u{002225}'),
    ("parsim",              '\u{002AF3}'),
    ("parsl",               '\u{002AFD}'),
    ("part",                '\u{002202}'),
    ("pcy",                 '\u{00043F}'),
    ("percnt",              '\u{000025}'),
    ("period",              '\u{00002E}'),
    ("permil",              '\u{002030}'),
    ("perp",                '\u{0022A5}'),
    ("pertenk",             '\u{002031}'),
    ("pfr",                 '\u{01D52D}'),
    ("phi",                 '\u{0003C6}'),
    ("phiv",                '\u{0003D5}'),
    ("phmmat",              '\u{002133}'),
    ("phone",               '\u{00260E}'),
    ("pi",                  '\u{0003C0}'),
    ("pitchfork",           '\u{0022D4}'),
    ("piv",                 '\u{0003D6}'),
    ("planck",              '\u{00210F}'),
    ("planckh",             '\u{00210E}'),
    ("plankv",              '\u{00210F}'),
    ("plus",                '\u{00002B}'),
    ("plusacir",            '\u{002A23}'),
    ("plusb",               '\u{00229E}'),
    ("pluscir",             '\u{002A22}'),
    ("plusdo",              '\u{002214}'),
    ("plusdu",              '\u{002A25}'),
    ("pluse",               '\u{002A72}'),
    ("plusmn",              '\u{0000B1}'),
    ("plussim",             '\u{002A26}'),
    ("plustwo",             '\u{002A27}'),
    ("pm",                  '\u{0000B1}'),
    ("pointint",            '\u{002A15}'),
    ("popf",                '\u{01D561}'),
    ("pound",               '\u{0000A3}'),
    ("pr",                  '\u{00227A}'),
    ("prE",                 '\u{002AB3}'),
    ("prap",                '\u{002AB7}'),
    ("prcue",               '\u{00227C}'),
    ("pre",                 '\u{002AAF}'),
    ("prec",                '\u{00227A}'),
    ("precapprox",          '\u{002AB7}'),
    ("preccurlyeq",         '\u{00227C}'),
    ("preceq",              '\u{002AAF}'),
    ("precnapprox",         '\u{002AB9}'),
    ("precneqq",            '\u{002AB5}'),
    ("precnsim",            '\u{0022E8}'),
    ("precsim",             '\u{00227E}'),
    ("prime",               '\u{002032}'),
    ("primes",              '\u{002119}'),
    ("prnE",                '\u{002AB5}'),
    ("prnap",               '\u{002AB9}'),
    ("prnsim",              '\u{0022E8}'),
    ("prod",                '\u{00220F}'),
    ("profalar",            '\u{00232E}'),
    ("profline",            '\u{002312}'),
    ("profsurf",            '\u{002313}'),
    ("prop",                '\u{00221D}'),
    ("propto",              '\u{00221D}'),
    ("prsim",               '\u{00227E}'),
    ("prurel",              '\u{0022B0}'),
    ("pscr",                '\u{01D4C5}'),
    ("psi",                 '\u{0003C8}'),
    ("puncsp",              '\u{002008}'),
    ("qfr",                 '\u{01D52E}'),
    ("qint",                '\u{002A0C}'),
    ("qopf",                '\u{01D562}'),
    ("qprime",              '\u{002057}'),
    ("qscr",                '\u{01D4C6}'),
    ("quaternions",         '\u{00210D}'),
    ("quatint",             '\u{002A16}'),
    ("quest",               '\u{00003F}'),
    ("questeq",             '\u{00225F}'),
    ("quot",                '\u{000022}'),
    ("rAarr",               '\u{0021DB}'),
    ("rArr",                '\u{0021D2}'),
    ("rAtail",              '\u{00291C}'),
    ("rBarr",               '\u{00290F}'),
    ("rHar",                '\u{002964}'),
    ("racute",              '\u{000155}'),
    ("radic",               '\u{00221A}'),
    ("raemptyv",            '\u{0029B3}'),
    ("rang",                '\u{0027E9}'),
    ("rangd",               '\u{002992}'),
    ("range",               '\u{0029A5}'),
    ("rangle",              '\u{0027E9}'),
    ("raquo",               '\u{0000BB}'),
    ("rarr",                '\u{002192}'),
    ("rarrap",              '\u{002975}'),
    ("rarrb",               '\u{0021E5}'),
    ("rarrbfs",             '\u{002920}'),
    ("rarrc",               '\u{002933}'),
    ("rarrfs",              '\u{00291E}'),
    ("rarrhk",              '\u{0021AA}'),
    ("rarrlp",              '\u{0021AC}'),
    ("rarrpl",              '\u{002945}'),
    ("rarrsim",             '\u{002974}'),
    ("rarrtl",              '\u{0021A3}'),
    ("rarrw",               '\u{00219D}'),
    ("ratail",              '\u{00291A}'),
    ("ratio",               '\u{002236}'),
    ("rationals",           '\u{00211A}'),
    ("rbarr",               '\u{00290D}'),
    ("rbbrk",               '\u{002773}'),
    ("rbrace",              '\u{00007D}'),
    ("rbrack",              '\u{00005D}'),
    ("rbrke",               '\u{00298C}'),
    ("rbrksld",             '\u{00298E}'),
    ("rbrkslu",             '\u{002990}'),
    ("rcaron",              '\u{000159}'),
    ("rcedil",              '\u{000157}'),
    ("rceil",               '\u{002309}'),
    ("rcub",                '\u{00007D}'),
    ("rcy",                 '\u{000440}'),
    ("rdca",                '\u{002937}'),
    ("rdldhar",             '\u{002969}'),
    ("rdquo",               '\u{00201D}'),
    ("rdquor",              '\u{00201D}'),
    ("rdsh",                '\u{0021B3}'),
    ("real",                '\u{00211C}'),
    ("realine",             '\u{00211B}'),
    ("realpart",            '\u{00211C}'),
    ("reals",               '\u{00211D}'),
    ("rect",                '\u{0025AD}'),
    ("reg",                 '\u{0000AE}'),
    ("rfisht",              '\u{00297D}'),
    ("rfloor",              '\u{00230B}'),
    ("rfr",                 '\u{01D52F}'),
    ("rhard",               '\u{0021C1}'),
    ("rharu",               '\u{0021C0}'),
    ("rharul",              '\u{00296C}'),
    ("rho",                 '\u{0003C1}'),
    ("rhov",                '\u{0003F1}'),
    ("rightarrow",          '\u{002192}'),
    ("rightarrowtail",      '\u{0021A3}'),
    ("rightharpoondown",    '\u{0021C1}'),
    ("rightharpoonup",      '\u{0021C0}'),
    ("rightleftarrows",     '\u{0021C4}'),
    ("rightleftharpoons",   '\u{0021CC}'),
    ("rightrightarrows",    '\u{0021C9}'),
    ("rightsquigarrow",     '\u{00219D}'),
    ("rightthreetimes",     '\u{0022CC}'),
    ("ring",                '\u{0002DA}'),
    ("risingdotseq",        '\u{002253}'),
    ("rlarr",               '\u{0021C4}'),
    ("rlhar",               '\u{0021CC}'),
    ("rlm",                 '\u{00200F}'),
    ("rmoust",              '\u{0023B1}'),
    ("rmoustache",          '\u{0023B1}'),
    ("rnmid",               '\u{002AEE}'),
    ("roang",               '\u{0027ED}'),
    ("roarr",               '\u{0021FE}'),
    ("robrk",               '\u{0027E7}'),
    ("ropar",               '\u{002986}'),
    ("ropf",                '\u{01D563}'),
    ("roplus",              '\u{002A2E}'),
    ("rotimes",             '\u{002A35}'),
    ("rpar",                '\u{000029}'),
    ("rpargt",              '\u{002994}'),
    ("rppolint",            '\u{002A12}'),
    ("rrarr",               '\u{0021C9}'),
    ("rsaquo",              '\u{00203A}'),
    ("rscr",                '\u{01D4C7}'),
    ("rsh",                 '\u{0021B1}'),
    ("rsqb",                '\u{00005D}'),
    ("rsquo",               '\u{002019}'),
    ("rsquor",              '\u{002019}'),
    ("rthree",              '\u{0022CC}'),
    ("rtimes",              '\u{0022CA}'),
    ("rtri",                '\u{0025B9}'),
    ("rtrie",               '\u{0022B5}'),
    ("rtrif",               '\u{0025B8}'),
    ("rtriltri",            '\u{0029CE}'),
    ("ruluhar",             '\u{002968}'),
    ("rx",                  '\u{00211E}'),
    ("sacute",              '\u{00015B}'),
    ("sbquo",               '\u{00201A}'),
    ("sc",                  '\u{00227B}'),
    ("scE",                 '\u{002AB4}'),
    ("scap",                '\u{002AB8}'),
    ("scaron",              '\u{000161}'),
    ("sccue",               '\u{00227D}'),
    ("sce",                 '\u{002AB0}'),
    ("scedil",              '\u{00015F}'),
    ("scirc",               '\u{00015D}'),
    ("scnE",                '\u{002AB6}'),
    ("scnap",               '\u{002ABA}'),
    ("scnsim",              '\u{0022E9}'),
    ("scpolint",            '\u{002A13}'),
    ("scsim",               '\u{00227F}'),
    ("scy",                 '\u{000441}'),
    ("sdot",                '\u{0022C5}'),
    ("sdotb",               '\u{0022A1}'),
    ("sdote",               '\u{002A66}'),
    ("seArr",               '\u{0021D8}'),
    ("searhk",              '\u{002925}'),
    ("searr",               '\u{002198}'),
    ("searrow",             '\u{002198}'),
    ("sect",                '\u{0000A7}'),
    ("semi",                '\u{00003B}'),
    ("seswar",              '\u{002929}'),
    ("setminus",            '\u{002216}'),
    ("setmn",               '\u{002216}'),
    ("sext",                '\u{002736}'),
    ("sfr",                 '\u{01D530}'),
    ("sfrown",              '\u{002322}'),
    ("sharp",               '\u{00266F}'),
    ("shchcy",              '\u{000449}'),
    ("shcy",                '\u{000448}'),
    ("shortmid",            '\u{002223}'),
    ("shortparallel",       '\u{002225}'),
    ("shy",                 '\u{0000AD}'),
    ("sigma",               '\u{0003C3}'),
    ("sigmaf",              '\u{0003C2}'),
    ("sigmav",              '\u{0003C2}'),
    ("sim",                 '\u{00223C}'),
    ("simdot",              '\u{002A6A}'),
    ("sime",                '\u{002243}'),
    ("simeq",               '\u{002243}'),
    ("simg",                '\u{002A9E}'),
    ("simgE",               '\u{002AA0}'),
    ("siml",                '\u{002A9D}'),
    ("simlE",               '\u{002A9F}'),
    ("simne",               '\u{002246}'),
    ("simplus",             '\u{002A24}'),
    ("simrarr",             '\u{002972}'),
    ("slarr",               '\u{002190}'),
    ("smallsetminus",       '\u{002216}'),
    ("smashp",              '\u{002A33}'),
    ("smeparsl",            '\u{0029E4}'),
    ("smid",                '\u{002223}'),
    ("smile",               '\u{002323}'),
    ("smt",                 '\u{002AAA}'),
    ("smte",                '\u{002AAC}'),
    ("softcy",              '\u{00044C}'),
    ("sol",                 '\u{00002F}'),
    ("solb",                '\u{0029C4}'),
    ("solbar",              '\u{00233F}'),
    ("sopf",                '\u{01D564}'),
    ("spades",              '\u{002660}'),
    ("spadesuit",           '\u{002660}'),
    ("spar",                '\u{002225}'),
    ("sqcap",               '\u{002293}'),
    ("sqcup",               '\u{002294}'),
    ("sqsub",               '\u{00228F}'),
    ("sqsube",              '\u{002291}'),
    ("sqsubset",            '\u{00228F}'),
    ("sqsubseteq",          '\u{002291}'),
    ("sqsup",               '\u{002290}'),
    ("sqsupe",              '\u{002292}'),
    ("sqsupset",            '\u{002290}'),
    ("sqsupseteq",          '\u{002292}'),
    ("squ",                 '\u{0025A1}'),
    ("square",              '\u{0025A1}'),
    ("squarf",              '\u{0025AA}'),
    ("squf",                '\u{0025AA}'),
    ("srarr",               '\u{002192}'),
    ("sscr",                '\u{01D4C8}'),
    ("ssetmn",              '\u{002216}'),
    ("ssmile",              '\u{002323}'),
    ("sstarf",              '\u{0022C6}'),
    ("star",                '\u{002606}'),
    ("starf",               '\u{002605}'),
    ("straightepsilon",     '\u{0003F5}'),
    ("straightphi",         '\u{0003D5}'),
    ("strns",               '\u{0000AF}'),
    ("sub",                 '\u{002282}'),
    ("subE",                '\u{002AC5}'),
    ("subdot",              '\u{002ABD}'),
    ("sube",                '\u{002286}'),
    ("subedot",             '\u{002AC3}'),
    ("submult",             '\u{002AC1}'),
    ("subnE",               '\u{002ACB}'),
    ("subne",               '\u{00228A}'),
    ("subplus",             '\u{002ABF}'),
    ("subrarr",             '\u{002979}'),
    ("subset",              '\u{002282}'),
    ("subseteq",            '\u{002286}'),
    ("subseteqq",           '\u{002AC5}'),
    ("subsetneq",           '\u{00228A}'),
    ("subsetneqq",          '\u{002ACB}'),
    ("subsim",              '\u{002AC7}'),
    ("subsub",              '\u{002AD5}'),
    ("subsup",              '\u{002AD3}'),
    ("succ",                '\u{00227B}'),
    ("succapprox",          '\u{002AB8}'),
    ("succcurlyeq",         '\u{00227D}'),
    ("succeq",              '\u{002AB0}'),
    ("succnapprox",         '\u{002ABA}'),
    ("succneqq",            '\u{002AB6}'),
    ("succnsim",            '\u{0022E9}'),
    ("succsim",             '\u{00227F}'),
    ("sum",                 '\u{002211}'),
    ("sung",                '\u{00266A}'),
    ("sup",                 '\u{002283}'),
    ("sup1",                '\u{0000B9}'),
    ("sup2",                '\u{0000B2}'),
    ("sup3",                '\u{0000B3}'),
    ("supE",                '\u{002AC6}'),
    ("supdot",              '\u{002ABE}'),
    ("supdsub",             '\u{002AD8}'),
    ("supe",                '\u{002287}'),
    ("supedot",             '\u{002AC4}'),
    ("suphsol",             '\u{0027C9}'),
    ("suphsub",             '\u{002AD7}'),
    ("suplarr",             '\u{00297B}'),
    ("supmult",             '\u{002AC2}'),
    ("supnE",               '\u{002ACC}'),
    ("supne",               '\u{00228B}'),
    ("supplus",             '\u{002AC0}'),
    ("supset",              '\u{002283}'),
    ("supseteq",            '\u{002287}'),
    ("supseteqq",           '\u{002AC6}'),
    ("supsetneq",           '\u{00228B}'),
    ("supsetneqq",          '\u{002ACC}'),
    ("supsim",              '\u{002AC8}'),
    ("supsub",              '\u{002AD4}'),
    ("supsup",              '\u{002AD6}'),
    ("swArr",               '\u{0021D9}'),
    ("swarhk",              '\u{002926}'),
    ("swarr",               '\u{002199}'),
    ("swarrow",             '\u{002199}'),
    ("swnwar",              '\u{00292A}'),
    ("szlig",               '\u{0000DF}'),
    ("target",              '\u{002316}'),
    ("tau",                 '\u{0003C4}'),
    ("tbrk",                '\u{0023B4}'),
    ("tcaron",              '\u{000165}'),
    ("tcedil",              '\u{000163}'),
    ("tcy",                 '\u{000442}'),
    ("tdot",                '\u{0020DB}'),
    ("telrec",              '\u{002315}'),
    ("tfr",                 '\u{01D531}'),
    ("there4",              '\u{002234}'),
    ("therefore",           '\u{002234}'),
    ("theta",               '\u{0003B8}'),
    ("thetasym",            '\u{0003D1}'),
    ("thetav",              '\u{0003D1}'),
    ("thickapprox",         '\u{002248}'),
    ("thicksim",            '\u{00223C}'),
    ("thinsp",              '\u{002009}'),
    ("thkap",               '\u{002248}'),
    ("thksim",              '\u{00223C}'),
    ("thorn",               '\u{0000FE}'),
    ("tilde",               '\u{0002DC}'),
    ("times",               '\u{0000D7}'),
    ("timesb",              '\u{0022A0}'),
    ("timesbar",            '\u{002A31}'),
    ("timesd",              '\u{002A30}'),
    ("tint",                '\u{00222D}'),
    ("toea",                '\u{002928}'),
    ("top",                 '\u{0022A4}'),
    ("topbot",              '\u{002336}'),
    ("topcir",              '\u{002AF1}'),
    ("topf",                '\u{01D565}'),
    ("topfork",             '\u{002ADA}'),
    ("tosa",                '\u{002929}'),
    ("tprime",              '\u{002034}'),
    ("trade",               '\u{002122}'),
    ("triangle",            '\u{0025B5}'),
    ("triangledown",        '\u{0025BF}'),
    ("triangleleft",        '\u{0025C3}'),
    ("trianglelefteq",      '\u{0022B4}'),
    ("triangleq",           '\u{00225C}'),
    ("triangleright",       '\u{0025B9}'),
    ("trianglerighteq",     '\u{0022B5}'),
    ("tridot",              '\u{0025EC}'),
    ("trie",                '\u{00225C}'),
    ("triminus",            '\u{002A3A}'),
    ("triplus",             '\u{002A39}'),
    ("trisb",               '\u{0029CD}'),
    ("tritime",             '\u{002A3B}'),
    ("trpezium",            '\u{0023E2}'),
    ("tscr",                '\u{01D4C9}'),
    ("tscy",                '\u{000446}'),
    ("tshcy",               '\u{00045B}'),
    ("tstrok",              '\u{000167}'),
    ("twixt",               '\u{00226C}'),
    ("twoheadleftarrow",    '\u{00219E}'),
    ("twoheadrightarrow",   '\u{0021A0}'),
    ("uArr",                '\u{0021D1}'),
    ("uHar",                '\u{002963}'),
    ("uacute",              '\u{0000FA}'),
    ("uarr",                '\u{002191}'),
    ("ubrcy",               '\u{00045E}'),
    ("ubreve",              '\u{00016D}'),
    ("ucirc",               '\u{0000FB}'),
    ("ucy",                 '\u{000443}'),
    ("udarr",               '\u{0021C5}'),
    ("udblac",              '\u{000171}'),
    ("udhar",               '\u{00296E}'),
    ("ufisht",              '\u{00297E}'),
    ("ufr",                 '\u{01D532}'),
    ("ugrave",              '\u{0000F9}'),
    ("uharl",               '\u{0021BF}'),
    ("uharr",               '\u{0021BE}'),
    ("uhblk",               '\u{002580}'),
    ("ulcorn",              '\u{00231C}'),
    ("ulcorner",            '\u{00231C}'),
    ("ulcrop",              '\u{00230F}'),
    ("ultri",               '\u{0025F8}'),
    ("umacr",               '\u{00016B}'),
    ("uml",                 '\u{0000A8}'),
    ("uogon",               '\u{000173}'),
    ("uopf",                '\u{01D566}'),
    ("uparrow",             '\u{002191}'),
    ("updownarrow",         '\u{002195}'),
    ("upharpoonleft",       '\u{0021BF}'),
    ("upharpoonright",      '\u{0021BE}'),
    ("uplus",               '\u{00228E}'),
    ("upsi",                '\u{0003C5}'),
    ("upsih",               '\u{0003D2}'),
    ("upsilon",             '\u{0003C5}'),
    ("upuparrows",          '\u{0021C8}'),
    ("urcorn",              '\u{00231D}'),
    ("urcorner",            '\u{00231D}'),
    ("urcrop",              '\u{00230E}'),
    ("uring",               '\u{00016F}'),
    ("urtri",               '\u{0025F9}'),
    ("uscr",                '\u{01D4CA}'),
    ("utdot",               '\u{0022F0}'),
    ("utilde",              '\u{000169}'),
    ("utri",                '\u{0025B5}'),
    ("utrif",               '\u{0025B4}'),
    ("uuarr",               '\u{0021C8}'),
    ("uuml",                '\u{0000FC}'),
    ("uwangle",             '\u{0029A7}'),
    ("vArr",                '\u{0021D5}'),
    ("vBar",                '\u{002AE8}'),
    ("vBarv",               '\u{002AE9}'),
    ("vDash",               '\u{0022A8}'),
    ("vangrt",              '\u{00299C}'),
    ("varepsilon",          '\u{0003F5}'),
    ("varkappa",            '\u{0003F0}'),
    ("varnothing",          '\u{002205}'),
    ("varphi",              '\u{0003D5}'),
    ("varpi",               '\u{0003D6}'),
    ("varpropto",           '\u{00221D}'),
    ("varr",                '\u{002195}'),
    ("varrho",              '\u{0003F1}'),
    ("varsigma",            '\u{0003C2}'),
    ("vartheta",            '\u{0003D1}'),
    ("vartriangleleft",     '\u{0022B2}'),
    ("vartriangleright",    '\u{0022B3}'),
    ("vcy",                 '\u{000432}'),
    ("vdash",               '\u{0022A2}'),
    ("vee",                 '\u{002228}'),
    ("veebar",              '\u{0022BB}'),
    ("veeeq",               '\u{00225A}'),
    ("vellip",              '\u{0022EE}'),
    ("verbar",              '\u{00007C}'),
    ("vert",                '\u{00007C}'),
    ("vfr",                 '\u{01D533}'),
    ("vltri",               '\u{0022B2}'),
    ("vopf",                '\u{01D567}'),
    ("vprop",               '\u{00221D}'),
    ("vrtri",               '\u{0022B3}'),
    ("vscr",                '\u{01D4CB}'),
    ("vzigzag",             '\u{00299A}'),
    ("wcirc",               '\u{000175}'),
    ("wedbar",              '\u{002A5F}'),
    ("wedge",               '\u{002227}'),
    ("wedgeq",              '\u{002259}'),
    ("weierp",              '\u{002118}'),
    ("wfr",                 '\u{01D534}'),
    ("wopf",                '\u{01D568}'),
    ("wp",                  '\u{002118}'),
    ("wr",                  '\u{002240}'),
    ("wreath",              '\u{002240}'),
    ("wscr",                '\u{01D4CC}'),
    ("xcap",                '\u{0022C2}'),
    ("xcirc",               '\u{0025EF}'),
    ("xcup",                '\u{0022C3}'),
    ("xdtri",               '\u{0025BD}'),
    ("xfr",                 '\u{01D535}'),
    ("xhArr",               '\u{0027FA}'),
    ("xharr",               '\u{0027F7}'),
    ("xi",                  '\u{0003BE}'),
    ("xlArr",               '\u{0027F8}'),
    ("xlarr",               '\u{0027F5}'),
    ("xmap",                '\u{0027FC}'),
    ("xnis",                '\u{0022FB}'),
    ("xodot",               '\u{002A00}'),
    ("xopf",                '\u{01D569}'),
    ("xoplus",              '\u{002A01}'),
    ("xotime",              '\u{002A02}'),
    ("xrArr",               '\u{0027F9}'),
    ("xrarr",               '\u{0027F6}'),
    ("xscr",                '\u{01D4CD}'),
    ("xsqcup",              '\u{002A06}'),
    ("xuplus",              '\u{002A04}'),
    ("xutri",               '\u{0025B3}'),
    ("xvee",                '\u{0022C1}'),
    ("xwedge",              '\u{0022C0}'),
    ("yacute",              '\u{0000FD}'),
    ("yacy",                '\u{00044F}'),
    ("ycirc",               '\u{000177}'),
    ("ycy",                 '\u{00044B}'),
    ("yen",                 '\u{0000A5}'),
    ("yfr",                 '\u{01D536}'),
    ("yicy",                '\u{000457}'),
    ("yopf",                '\u{01D56A}'),
    ("yscr",                '\u{01D4CE}'),
    ("yucy",                '\u{00044E}'),
    ("yuml",                '\u{0000FF}'),
    ("zacute",              '\u{00017A}'),
    ("zcaron",              '\u{00017E}'),
    ("zcy",                 '\u{000437}'),
    ("zdot",                '\u{00017C}'),
    ("zeetrf",              '\u{002128}'),
    ("zeta",                '\u{0003B6}'),
    ("zfr",                 '\u{01D537}'),
    ("zhcy",                '\u{000436}'),
    ("zigrarr",             '\u{0021DD}'),
    ("zopf",                '\u{01D56B}'),
    ("zscr",                '\u{01D4CF}'),
    ("zwj",                 '\u{00200D}'),
    ("zwnj",                '\u{00200C}'),
    ];
