use super::ModuleState;
use crate::arena::Handle;

//TODO: use `thiserror`
#[derive(Debug)]
pub enum Error {
    InvalidHeader,
    InvalidWordCount,
    UnknownInstruction(u16),
    UnknownCapability(spirv::Word),
    UnsupportedInstruction(ModuleState, spirv::Op),
    UnsupportedCapability(spirv::Capability),
    UnsupportedExtension(String),
    UnsupportedExtSet(String),
    UnsupportedExtInstSet(spirv::Word),
    UnsupportedExtInst(spirv::Word),
    UnsupportedType(Handle<crate::Type>),
    UnsupportedExecutionModel(spirv::Word),
    UnsupportedExecutionMode(spirv::Word),
    UnsupportedStorageClass(spirv::Word),
    UnsupportedImageDim(spirv::Word),
    UnsupportedImageFormat(spirv::Word),
    UnsupportedBuiltIn(spirv::Word),
    UnsupportedControlFlow(spirv::Word),
    UnsupportedBinaryOperator(spirv::Word),
    UnknownBinaryOperator(spirv::Op),
    UnknownRelationalFunction(spirv::Op),
    InvalidParameter(spirv::Op),
    InvalidOperandCount(spirv::Op, u16),
    InvalidOperand,
    InvalidId(spirv::Word),
    InvalidDecoration(spirv::Word),
    InvalidTypeWidth(spirv::Word),
    InvalidSign(spirv::Word),
    InvalidInnerType(spirv::Word),
    InvalidVectorSize(spirv::Word),
    InvalidAccessType(spirv::Word),
    InvalidAccess(crate::Expression),
    InvalidAccessIndex(spirv::Word),
    InvalidBinding(spirv::Word),
    InvalidGlobalVar(crate::Expression),
    InvalidImageBaseType(Handle<crate::Type>),
    InvalidImage(Handle<crate::Type>),
    InvalidAsType(Handle<crate::Type>),
    InvalidVectorType(Handle<crate::Type>),
    InconsistentComparisonSampling(Handle<crate::GlobalVariable>),
    WrongFunctionResultType(spirv::Word),
    WrongFunctionArgumentType(spirv::Word),
    MissingDecoration(spirv::Decoration),
    BadString,
    IncompleteData,
    InvalidTerminator,
    InvalidEdgeClassification,
    FunctionCallCycle(spirv::Word),
    InvalidArraySize(Handle<crate::Constant>),
    // incomplete implementation error
    UnsupportedMatrixStride(spirv::Word),
}
