use proc_macro::TokenStream;
use quote::quote;
use syn::DeriveInput;

#[proc_macro_derive(Get)]
pub fn get_derive(input: TokenStream) -> TokenStream {
    let ast: DeriveInput = syn::parse(input)
        .expect(" -- parse err at derive dto ");

    let name = &ast.ident.clone();
    TokenStream::from(quote! {
        impl Get for #name {}
    })
}

#[proc_macro_derive(Post)]
pub fn post_derive(input: TokenStream) -> TokenStream {
    let ast: DeriveInput = syn::parse(input)
        .expect(" -- parse err at derive dto ");

    let name = &ast.ident.clone();
    TokenStream::from(quote! {
        impl Post for #name {}
    })
}

#[proc_macro_derive(Put)]
pub fn put_derive(input: TokenStream) -> TokenStream {
    let ast: DeriveInput = syn::parse(input)
        .expect(" -- parse err at derive dto ");

    let name = &ast.ident.clone();
    TokenStream::from(quote! {
        impl Put for #name {}
    })
}

#[proc_macro_derive(Delete)]
pub fn delete_derive(input: TokenStream) -> TokenStream {
    let ast: DeriveInput = syn::parse(input)
        .expect(" -- parse err at derive dto ");

    let name = &ast.ident.clone();
    TokenStream::from(quote! {
        impl Delete for #name {}
    })
}



