mod content_analysis_job;

use nNye_user_business::content_notification::ContentNotification;
use content_analysis_job::ContentAnalysisJob;
use std::io::Result;
use zmq::Context;
use zmq::{REQ, REP};

pub trait INotificationsQueue {
    fn add_notification(&self, notification: &ContentNotification) -> Result<()>;
    fn get_notification(&self) -> ContentNotification;
}

pub trait Constructor {
    fn new(context: &Context, backend_endpoint: &String, frontend_endpoint: &String) -> Self;
}

pub struct NotificationsQueue {
    context: Context,
    backend_endpoint: String,
    frontend_endpoint: String,
}

impl INotificationsQueue for NotificationsQueue {
    fn add_notification(&self, notification: &ContentNotification) -> Result<()> {
        let job = ContentAnalysisJob::from_business_entity(notification);
        let job_bytes = job.to_bytes();

        let requester = &self.context.socket(REQ).unwrap();
        requester
            .connect(&self.frontend_endpoint)
            .expect("failed to connect to requester");
        requester.send(job_bytes, 0).unwrap();
        println!("sent message to queue");
        Ok(())
    }

    fn get_notification(&self) -> ContentNotification {
        let responder = &self.context.socket(REP).unwrap();

        responder
            .connect(&self.backend_endpoint)
            .expect("failed to connect to responder");

        let job_bytes = responder.recv_bytes(0).unwrap();
        let job = ContentAnalysisJob::from_bytes(&job_bytes);
        job.to_business_entitiy()
    }
}

impl Constructor for NotificationsQueue {
    fn new(context: &Context, frontend_endpoint: &String, backend_endpoint: &String) -> NotificationsQueue {
        NotificationsQueue { 
            context: context.clone(), 
            frontend_endpoint: frontend_endpoint.clone(), 
            backend_endpoint: backend_endpoint.clone()
        } 
    }
}


