use bincode::{deserialize, serialize};
use serde::{Deserialize, Serialize};

use nNye_user_business::content_notification::ContentNotification;

#[derive(Serialize, Deserialize)]
pub struct ContentAnalysisJob {
    pub pub_key: String,
    pub content_id: u32,
}

impl ContentAnalysisJob {
    pub fn to_bytes(&self) -> Vec<u8> {
        serialize(&self).unwrap()
    }

    pub fn from_bytes(bytes: &Vec<u8>) -> Self{
        let job: ContentAnalysisJob = deserialize(bytes).unwrap();
        job
    }

    pub fn from_business_entity(notification: &ContentNotification) -> Self {
        ContentAnalysisJob {
            pub_key: notification.get_pub_key().clone(),
            content_id: notification.get_content_id().clone(),
        }
    }

    pub fn to_business_entitiy(&self) -> ContentNotification {
        ContentNotification::new(self.pub_key.clone(), self.content_id.clone())
    }
}
