use std::io::Result;
use std::io::Error;
use std::io::ErrorKind;
use diesel::prelude::*;
use diesel::sqlite::SqliteConnection;
use dotenv::dotenv;
use std::env;
use super::schema::prioritized_content::dsl::*;
use super::entities::prioritized_content::PrioritizedContentEntity;
use super::entities::prioritized_content::NewPrioritizedContentEntity;
use nNye_user_business::content::Content;

pub trait IPrioritizedContentRepository {
    fn add_prioritized_content(&self, content: &Content, _priority: &i32) -> Result<()>; //I need to put _ in front of the priority parameter since 'priority' is already an 
    fn get_top_prioritized_contents(&self, number_of_posts_to_retrieve: &i64);           //alias for the priority column.
    fn delete_top_prioritized_contents();
}

pub struct PrioritizedContentRepository {
    connection: SqliteConnection
}

impl IPrioritizedContentRepository for PrioritizedContentRepository {
    fn add_prioritized_content(&self, content: &Content, _priority: &i32) -> Result<()>{
        let entity = NewPrioritizedContentEntity::from_business(content, _priority);
        diesel::insert_into(prioritized_content)
               .values(&entity)
               .execute(&self.connection)
               .expect("Couldn't insert content");
        Ok(())
    }

    fn get_top_prioritized_contents(&self, number_of_posts_to_retrieve: &i64) {
        let prioritized_contents = prioritized_content
            .order_by(priority.asc())
            .limit(number_of_posts_to_retrieve.clone())
            .load::<PrioritizedContentEntity>(&self.connection)
            .expect("Some Error Occurred");
    }

    fn delete_top_prioritized_contents() {

    }

}

impl PrioritizedContentRepository {
    pub fn new(connection_string: &String) -> Self {
        let connection = SqliteConnection::establish(connection_string) 
                                          .expect(&format!("Couldn't connect to {}", connection_string));
        PrioritizedContentRepository{ connection: connection }
    }
}

pub fn resolve(connection_string: &String) -> impl IPrioritizedContentRepository {
   PrioritizedContentRepository::new(connection_string) 
}
