use diesel::{Queryable, Insertable};
use nNye_user_business::content::Content;

#[derive(Queryable)]
pub struct PrioritizedContentEntity {
   pub id: Option<i32>,
   pub poster_name: String,
   pub poster_account: String,
   pub post_text: Option<String>,
   pub media_type: Option<i32>,
   pub media_path: Option<String>,
   pub date_posted: Option<String>,
   pub priority: i32
}


use super::super::schema::prioritized_content;

#[derive(Insertable)]
#[table_name="prioritized_content"]
pub struct NewPrioritizedContentEntity {
   pub poster_name: String,
   pub poster_account: String,
   pub post_text: Option<String>,
   pub media_type: Option<i32>,
   pub media_path: Option<String>,
   pub date_posted: Option<String>,
   pub priority: i32
}


impl NewPrioritizedContentEntity {
    pub fn from_business(content: &Content, priority: &i32) -> Self {
        NewPrioritizedContentEntity {
            poster_name: content.get_poster_name().clone(),
            poster_account: content.get_poster_account().clone(),
            post_text: content.get_post_text().clone(),
            media_type: Some(content.get_media_type().clone().unwrap() as i32),
            media_path: content.get_media_path().clone(),
            date_posted: Some(content.get_date_posted().clone()),
            priority: priority.clone()
        }
    }
}

