use nNye_solana_communication_layer::ISolana;
use super::content::Content;
use super::enums::MediaType;

/// The business entitiy that represents the notification a user sends out to their network when they post new content.
pub struct ContentNotification {
    /// The user's identifier on Solana.
    pub_key: String,    

    /// The id of the content that was posted.
    content_id: u32,

    solana: Box<dyn ISolana>
}

impl ContentNotification {

    pub fn new(pub_key: String, 
               content_id: u32, 
               solana: Box<dyn ISolana>) -> Self {
        ContentNotification{ pub_key: pub_key, content_id: content_id, solana: solana }
    }

    pub fn get_pub_key(&self) -> &String {
        &self.pub_key
    }

    pub fn get_content_id(&self) -> &u32 {
        &self.content_id
    }

    pub fn get_content (&self) -> Content {
        let ip = &self.solana.get_ip(&self.pub_key);
        self.http_get_content()
        //TODO: form ip
        //TODO: http call to return content
    }

    fn http_get_content(&self) -> Content {
        Content::new(String::from("some_account"),
                     String::from("some_name"),
                     Some(String::from("some_text")),
                     Some(MediaType::PICTURE),
                     Some(String::from("some_paht")),
                     String::from("some_date"))
    }
}
