use super::enums::MediaType;

pub struct Content {
    poster_account: String,
    poster_name: String,
    post_text: Option<String>,
    media_type: Option<MediaType>,
    media_path: Option<String>,
    date_posted: String
}

impl Content {
    pub fn new(poster_account: String,
               poster_name: String,
               post_text: Option<String>,
               media_type: Option<MediaType>,
               media_path: Option<String>,
               date_posted: String) -> Self {
        Content {
            poster_account: poster_account,
            poster_name: poster_name,
            post_text: post_text,
            media_type: media_type,
            media_path: media_path,
            date_posted: date_posted
        }
    }

    pub fn get_poster_account(&self) -> &String {
        &self.poster_account 
    }

    pub fn get_poster_name(&self) -> &String {
        &self.poster_name
    }

    pub fn get_post_text(&self) -> &Option<String> {
        &self.post_text
    }

    pub fn get_media_type(&self) -> &Option<MediaType> {
        &self.media_type
    }

    pub fn get_media_path(&self) -> &Option<String> {
        &self.media_path
    }

    pub fn get_date_posted(&self) -> &String {
        &self.date_posted
    }

    pub fn is_valid() -> bool {
        true
    }

    pub fn compute_priority() -> i32 {
        100
    }
}
